/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.android.callback;

import android.app.Service;
import android.content.Intent;
import com.cloudinary.android.MediaManager;
import com.cloudinary.android.callback.UploadCallback;
import com.cloudinary.android.callback.UploadResult;
import com.cloudinary.android.callback.UploadStatus;
import com.cloudinary.utils.StringUtils;

public abstract class ListenerService
extends Service
implements UploadCallback {
    private static final String TAG = "ListenerService";

    public void onCreate() {
        super.onCreate();
        MediaManager.get().registerCallback(this);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        String requestId;
        if (intent != null && StringUtils.isNotBlank((String)(requestId = intent.getStringExtra("INTENT_EXTRA_REQUEST_ID")))) {
            if ("com.cloudinary.ACTION_REQUEST_STARTED".equals(intent.getAction())) {
                this.onStart(requestId);
            } else if ("com.cloudinary.ACTION_REQUEST_FINISHED".equals(intent.getAction())) {
                UploadStatus result = (UploadStatus)((Object)intent.getSerializableExtra("INTENT_EXTRA_REQUEST_RESULT_STATUS"));
                UploadResult uploadResult = MediaManager.get().popPendingResult(requestId);
                if (result == UploadStatus.FAILURE) {
                    this.onError(requestId, uploadResult.getError());
                } else if (result == UploadStatus.SUCCESS) {
                    this.onSuccess(requestId, uploadResult.getSuccessResultData());
                }
            }
        }
        return 1;
    }

    public void onDestroy() {
        super.onDestroy();
        MediaManager.get().unregisterCallback(this);
    }
}

