/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.android.payload;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Base64;
import com.cloudinary.android.Logger;
import com.cloudinary.android.payload.EmptyByteArrayException;
import com.cloudinary.android.payload.Payload;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class ByteArrayPayload
extends Payload<byte[]> {
    public static final String ENCODING_CHARSET = "UTF8";
    static final String URI_KEY = "bytes";
    private static final String TAG = ByteArrayPayload.class.getSimpleName();

    public ByteArrayPayload(byte[] data) {
        super(data);
    }

    public ByteArrayPayload() {
    }

    @NonNull
    private static String encode(byte[] data) {
        try {
            return new String(Base64.encode((byte[])data, (int)8), ENCODING_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            Logger.e(TAG, "Cannot encode image bytes", e);
            return null;
        }
    }

    private static byte[] decode(String encoded) {
        try {
            return Base64.decode((byte[])encoded.getBytes(ENCODING_CHARSET), (int)8);
        }
        catch (UnsupportedEncodingException e) {
            Logger.e(TAG, "Cannot decode image bytes", e);
            return null;
        }
    }

    @Override
    public String toUri() {
        return "bytes://" + ByteArrayPayload.encode((byte[])this.data);
    }

    @Override
    public long getLength(Context context) {
        return ((byte[])this.data).length;
    }

    @Override
    public Object prepare(Context context) throws EmptyByteArrayException {
        if (this.data == null || ((byte[])this.data).length < 1) {
            throw new EmptyByteArrayException();
        }
        return this.data;
    }

    @Override
    void loadData(String encodedData) {
        this.data = ByteArrayPayload.decode(encodedData);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Payload payload = (Payload)o;
        return this.data != null ? Arrays.equals((byte[])this.data, (byte[])payload.data) : payload.data == null;
    }

    @Override
    public int hashCode() {
        return this.data != null ? Arrays.hashCode((byte[])this.data) : 0;
    }
}

