/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.android.payload;

import android.content.Context;
import com.cloudinary.android.payload.FileNotFoundException;
import com.cloudinary.android.payload.Payload;
import com.cloudinary.android.payload.PayloadNotFoundException;
import com.cloudinary.utils.Base64Coder;
import java.io.File;

public class FilePayload
extends Payload<String> {
    static final String URI_KEY = "file";

    public FilePayload(String filePath) {
        super(filePath);
    }

    public FilePayload() {
    }

    @Override
    public long getLength(Context context) throws PayloadNotFoundException {
        return this.getFile(context).length();
    }

    @Override
    public Object prepare(Context context) throws PayloadNotFoundException {
        return this.getFile(context);
    }

    private File getFile(Context context) throws FileNotFoundException {
        File file;
        File file2 = file = ((String)this.data).contains(File.separator) ? new File((String)this.data) : context.getFileStreamPath((String)this.data);
        if (!file.exists()) {
            throw new FileNotFoundException(String.format("File '%s' does not exist", this.data));
        }
        return file;
    }

    @Override
    public String toUri() {
        return "file://" + Base64Coder.encodeString((String)((String)this.data));
    }

    @Override
    void loadData(String encodedData) {
        this.data = Base64Coder.decodeString((String)encodedData);
    }
}

