/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.android.payload;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import com.cloudinary.android.payload.LocalUriNotFoundException;
import com.cloudinary.android.payload.Payload;
import com.cloudinary.android.payload.PayloadNotFoundException;
import com.cloudinary.utils.Base64Coder;
import java.io.FileNotFoundException;

public class LocalUriPayload
extends Payload<Uri> {
    public static final String[] PROJECTION = new String[]{"_size"};
    static final String URI_KEY = "uri";

    public LocalUriPayload(Uri data) {
        super(data);
    }

    public LocalUriPayload() {
    }

    @Override
    public String toUri() {
        return "uri://" + Base64Coder.encodeString((String)((Uri)this.data).toString());
    }

    @Override
    void loadData(String encodedData) {
        this.data = Uri.parse((String)Base64Coder.decodeString((String)encodedData));
    }

    @Override
    public long getLength(Context context) {
        return this.fetchFileSizeFromUri(context);
    }

    @Override
    public Object prepare(Context context) throws PayloadNotFoundException {
        try {
            return context.getContentResolver().openInputStream((Uri)this.data);
        }
        catch (FileNotFoundException e) {
            throw new LocalUriNotFoundException(String.format("Uri %s could not be found", ((Uri)this.data).toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long fetchFileSizeFromUri(Context context) {
        long size = 0L;
        try (Cursor returnCursor = null;){
            returnCursor = context.getContentResolver().query((Uri)this.data, PROJECTION, null, null, null);
            if (returnCursor != null && returnCursor.moveToNext()) {
                int sizeIndex = returnCursor.getColumnIndex("_size");
                size = returnCursor.getLong(sizeIndex);
            }
        }
        return size;
    }
}

