/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.android.payload;

import android.net.Uri;
import com.cloudinary.android.payload.ByteArrayPayload;
import com.cloudinary.android.payload.FilePayload;
import com.cloudinary.android.payload.LocalUriPayload;
import com.cloudinary.android.payload.Payload;
import com.cloudinary.android.payload.ResourcePayload;

public class PayloadFactory {
    private static final String TAG = PayloadFactory.class.getSimpleName();

    public static Payload fromUri(String uri) {
        Payload payload;
        Uri parsed = Uri.parse((String)uri);
        String scheme = parsed.getScheme();
        if (scheme == null) {
            return null;
        }
        switch (scheme) {
            case "bytes": {
                payload = new ByteArrayPayload();
                break;
            }
            case "file": {
                payload = new FilePayload();
                break;
            }
            case "uri": {
                payload = new LocalUriPayload();
                break;
            }
            case "resource": {
                payload = new ResourcePayload();
                break;
            }
            default: {
                return null;
            }
        }
        payload.loadData(parsed.getHost());
        return payload;
    }
}

