/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.android.payload;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import com.cloudinary.android.payload.Payload;
import com.cloudinary.android.payload.PayloadNotFoundException;
import com.cloudinary.android.payload.ResourceNotFoundException;
import java.io.IOException;

public class ResourcePayload
extends Payload<Integer> {
    static final String URI_KEY = "resource";

    public ResourcePayload(Integer rawResourceId) {
        super(rawResourceId);
    }

    ResourcePayload() {
    }

    @Override
    public String toUri() {
        return "resource://" + this.data;
    }

    @Override
    void loadData(String encodedData) {
        this.data = Integer.parseInt(encodedData);
    }

    @Override
    public long getLength(Context context) throws PayloadNotFoundException {
        AssetFileDescriptor afd = null;
        long size = 0L;
        try {
            afd = context.getResources().openRawResourceFd(((Integer)this.data).intValue());
            size = afd.getLength();
        }
        catch (Resources.NotFoundException e) {
            throw new ResourceNotFoundException(String.format("Resource id %d not found", this.data));
        }
        finally {
            if (afd != null) {
                try {
                    afd.close();
                }
                catch (IOException iOException) {}
            }
        }
        return size;
    }

    @Override
    public Object prepare(Context context) throws PayloadNotFoundException {
        try {
            return context.getResources().openRawResource(((Integer)this.data).intValue());
        }
        catch (Resources.NotFoundException e) {
            throw new ResourceNotFoundException(String.format("Resource id %d not found", this.data));
        }
    }
}

