/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.android.preprocess;

import android.content.Context;
import android.graphics.Bitmap;
import com.cloudinary.android.preprocess.ResourceCreationException;
import com.cloudinary.android.preprocess.ResourceEncoder;
import com.cloudinary.utils.StringUtils;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;

public class BitmapEncoder
implements ResourceEncoder<Bitmap> {
    private static final Format DEFAULT_FORMAT = Format.WEBP;
    private static final int DEFAULT_QUALITY = 100;
    private final Format format;
    private final int quality;

    public BitmapEncoder() {
        this(DEFAULT_FORMAT, 100);
    }

    public BitmapEncoder(Format format, int quality) {
        this.format = format;
        this.quality = quality;
    }

    @Override
    public String encode(Context context, Bitmap resource) throws ResourceCreationException {
        return this.saveFile(context, resource, this.quality, this.format);
    }

    protected final String saveFile(Context context, Bitmap resource, int quality, Format format) throws ResourceCreationException {
        FileOutputStream fos = null;
        String fileName = UUID.randomUUID().toString();
        String file = null;
        try {
            fos = context.openFileOutput(fileName, 0);
            resource.compress(this.adaptFormat(format), quality, (OutputStream)fos);
            resource.recycle();
            file = fileName;
        }
        catch (FileNotFoundException e) {
            throw new ResourceCreationException("Could not create new file");
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                    if (StringUtils.isBlank(file)) {
                        context.deleteFile(fileName);
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return file;
    }

    private Bitmap.CompressFormat adaptFormat(Format format) {
        switch (format) {
            case WEBP: {
                return Bitmap.CompressFormat.WEBP;
            }
            case JPEG: {
                return Bitmap.CompressFormat.JPEG;
            }
        }
        return Bitmap.CompressFormat.PNG;
    }

    public static enum Format {
        WEBP,
        JPEG,
        PNG;

    }
}

