/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.android.preprocess;

import android.content.Context;
import android.graphics.Bitmap;
import com.cloudinary.android.preprocess.Preprocess;

public class Limit
implements Preprocess<Bitmap> {
    private final int width;
    private final int height;

    public Limit(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public Bitmap execute(Context context, Bitmap resource) {
        if (resource.getWidth() > this.width || resource.getHeight() > this.height) {
            double widthRatio = (double)this.width / (double)resource.getWidth();
            double heightRatio = (double)this.height / (double)resource.getHeight();
            if (heightRatio > widthRatio) {
                return Bitmap.createScaledBitmap((Bitmap)resource, (int)this.width, (int)((int)Math.round(widthRatio * (double)resource.getHeight())), (boolean)true);
            }
            return Bitmap.createScaledBitmap((Bitmap)resource, (int)((int)Math.round(heightRatio * (double)resource.getWidth())), (int)this.height, (boolean)true);
        }
        return resource;
    }
}

