/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.android;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.cloudinary.Cloudinary;
import com.cloudinary.Configuration;
import com.cloudinary.Url;
import com.cloudinary.android.BackgroundRequestStrategy;
import com.cloudinary.android.BackgroundStrategyProvider;
import com.cloudinary.android.CallbackDispatcher;
import com.cloudinary.android.DefaultCallbackDispatcher;
import com.cloudinary.android.DefaultImmediateRequestsRunner;
import com.cloudinary.android.DefaultRequestDispatcher;
import com.cloudinary.android.DefaultRequestProcessor;
import com.cloudinary.android.ImmediateRequestsRunner;
import com.cloudinary.android.LogLevel;
import com.cloudinary.android.Logger;
import com.cloudinary.android.RequestDispatcher;
import com.cloudinary.android.RequestParams;
import com.cloudinary.android.RequestProcessor;
import com.cloudinary.android.ResponsiveUrl;
import com.cloudinary.android.UploadContext;
import com.cloudinary.android.UploadRequest;
import com.cloudinary.android.Utils;
import com.cloudinary.android.callback.ErrorInfo;
import com.cloudinary.android.callback.UploadCallback;
import com.cloudinary.android.callback.UploadResult;
import com.cloudinary.android.callback.UploadStatus;
import com.cloudinary.android.payload.ByteArrayPayload;
import com.cloudinary.android.payload.FilePayload;
import com.cloudinary.android.payload.LocalUriPayload;
import com.cloudinary.android.payload.Payload;
import com.cloudinary.android.payload.ResourcePayload;
import com.cloudinary.android.policy.GlobalUploadPolicy;
import com.cloudinary.android.signed.SignatureProvider;
import com.cloudinary.utils.StringUtils;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class MediaManager {
    public static final String VERSION = "1.26.0";
    public static final String INTENT_EXTRA_REQUEST_ID = "INTENT_EXTRA_REQUEST_ID";
    public static final String INTENT_EXTRA_REQUEST_RESULT_STATUS = "INTENT_EXTRA_REQUEST_RESULT_STATUS";
    public static final String ACTION_REQUEST_STARTED = "com.cloudinary.ACTION_REQUEST_STARTED";
    public static final String ACTION_REQUEST_FINISHED = "com.cloudinary.ACTION_REQUEST_FINISHED";
    private static final String TAG = MediaManager.class.getSimpleName();
    private static MediaManager _instance;
    private final Cloudinary cloudinary;
    private final RequestDispatcher requestDispatcher;
    private final RequestProcessor requestProcessor;
    private final CallbackDispatcher callbackDispatcher;
    private final SignatureProvider signatureProvider;
    private final ImmediateRequestsRunner immediateRequestsRunner;
    private final ExecutorService executor;
    private GlobalUploadPolicy globalUploadPolicy = GlobalUploadPolicy.defaultPolicy();

    private MediaManager(@NonNull Context context, @Nullable SignatureProvider signatureProvider, @Nullable Map config) {
        this.executor = new ThreadPoolExecutor(4, 4, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        BackgroundRequestStrategy strategy = BackgroundStrategyProvider.provideStrategy();
        this.callbackDispatcher = new DefaultCallbackDispatcher(context);
        this.requestProcessor = new DefaultRequestProcessor(this.callbackDispatcher);
        this.immediateRequestsRunner = new DefaultImmediateRequestsRunner(this.requestProcessor);
        this.requestDispatcher = new DefaultRequestDispatcher(strategy, this.immediateRequestsRunner);
        strategy.init(context);
        this.signatureProvider = signatureProvider;
        String cloudinaryUrl = Utils.cloudinaryUrlFromContext(context);
        this.cloudinary = config != null ? new Cloudinary(config) : (StringUtils.isNotBlank((String)cloudinaryUrl) ? new Cloudinary(cloudinaryUrl) : new Cloudinary());
        this.callbackDispatcher.registerCallback(new UploadCallback(){

            @Override
            public void onStart(String requestId) {
            }

            @Override
            public void onProgress(String requestId, long bytes, long totalBytes) {
            }

            @Override
            public void onSuccess(String requestId, Map resultData) {
                MediaManager.this.requestDispatcher.queueRoomFreed();
            }

            @Override
            public void onError(String requestId, ErrorInfo error) {
                MediaManager.this.requestDispatcher.queueRoomFreed();
            }

            @Override
            public void onReschedule(String requestId, ErrorInfo error) {
                MediaManager.this.requestDispatcher.queueRoomFreed();
            }
        });
    }

    public static void init(@NonNull Context context) {
        MediaManager.init(context, null, (Map)null);
    }

    public static void init(@NonNull Context context, @Nullable Map config) {
        MediaManager.init(context, null, config);
    }

    public static void init(@NonNull Context context, @Nullable Configuration config) {
        Map map = null;
        if (config != null) {
            map = config.asMap();
        }
        MediaManager.init(context, null, map);
    }

    public static void init(@NonNull Context context, @Nullable SignatureProvider signatureProvider) {
        MediaManager.init(context, signatureProvider, (Map)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(@NonNull Context context, @Nullable SignatureProvider provider, @Nullable Map config) {
        Class<MediaManager> clazz = MediaManager.class;
        synchronized (MediaManager.class) {
            if (context == null) {
                throw new IllegalArgumentException("context cannot be null.");
            }
            if (_instance != null) {
                throw new IllegalStateException("MediaManager is already initialized");
            }
            _instance = new MediaManager(context, provider, config);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static void init(@NonNull Context context, @Nullable SignatureProvider provider, @Nullable Configuration config) {
        Map map = null;
        if (config != null) {
            map = config.asMap();
        }
        MediaManager.init(context, provider, map);
    }

    public static MediaManager get() {
        if (_instance == null) {
            throw new IllegalStateException("Must call init() before accessing Cloudinary.");
        }
        return _instance;
    }

    public static void setLogLevel(LogLevel logLevel) {
        Logger.logLevel = logLevel;
    }

    public Cloudinary getCloudinary() {
        return this.cloudinary;
    }

    public Url url() {
        Url url = this.cloudinary.url();
        if (Build.VERSION.SDK_INT >= 28) {
            url.secure(true);
        }
        return url;
    }

    public boolean cancelRequest(String requestId) {
        return this.immediateRequestsRunner.cancelRequest(requestId) || this.requestDispatcher.cancelRequest(requestId);
    }

    public int cancelAllRequests() {
        return this.requestDispatcher.cancelAllRequests() + this.immediateRequestsRunner.cancelAllRequests();
    }

    public UploadRequest upload(int rawResourceId) {
        return this.buildUploadRequest(new ResourcePayload(rawResourceId));
    }

    public UploadRequest upload(Uri uri) {
        return this.buildUploadRequest(new LocalUriPayload(uri));
    }

    public UploadRequest upload(byte[] bytes) {
        return this.buildUploadRequest(new ByteArrayPayload(bytes));
    }

    public UploadRequest upload(String filePath) {
        return this.buildUploadRequest(new FilePayload(filePath));
    }

    public UploadRequest upload(Payload payload) {
        return this.buildUploadRequest(payload);
    }

    public GlobalUploadPolicy getGlobalUploadPolicy() {
        return this.globalUploadPolicy;
    }

    public void setGlobalUploadPolicy(GlobalUploadPolicy globalUploadPolicy) {
        this.globalUploadPolicy = globalUploadPolicy;
    }

    public void registerCallback(UploadCallback callback) {
        this.callbackDispatcher.registerCallback(callback);
    }

    void registerCallback(String requestId, UploadCallback callback) {
        this.callbackDispatcher.registerCallback(requestId, callback);
    }

    public void unregisterCallback(UploadCallback callback) {
        this.callbackDispatcher.unregisterCallback(callback);
    }

    public UploadResult popPendingResult(String requestId) {
        return this.callbackDispatcher.popPendingResult(requestId);
    }

    void dispatchRequestError(Context context, String requestId, ErrorInfo error) {
        this.callbackDispatcher.dispatchError(context, requestId, error);
    }

    private UploadRequest<Payload> buildUploadRequest(Payload payload) {
        UploadContext<Payload> payloadUploadContext = new UploadContext<Payload>(payload, this.requestDispatcher);
        return new UploadRequest<Payload>(payloadUploadContext);
    }

    public ResponsiveUrl responsiveUrl(boolean autoWidth, boolean autoHeight, @NonNull String cropMode, @NonNull String gravity) {
        return new ResponsiveUrl(this.cloudinary, autoWidth, autoHeight, cropMode, gravity);
    }

    public ResponsiveUrl responsiveUrl(@NonNull ResponsiveUrl.Preset preset) {
        return preset.get(this.getCloudinary());
    }

    public void responsiveUrl(View view, Url baseUrl, ResponsiveUrl.Preset preset, ResponsiveUrl.Callback callback) {
        preset.get(this.getCloudinary()).generate(baseUrl, view, callback);
    }

    public void responsiveUrl(View view, String publicId, ResponsiveUrl.Preset preset, ResponsiveUrl.Callback callback) {
        preset.get(this.getCloudinary()).generate(publicId, view, callback);
    }

    UploadStatus processRequest(Context context, RequestParams params) {
        return this.requestProcessor.processRequest(context, params);
    }

    boolean hasCredentials() {
        return StringUtils.isNotBlank((String)this.cloudinary.config.apiKey) && StringUtils.isNotBlank((String)this.cloudinary.config.apiSecret);
    }

    SignatureProvider getSignatureProvider() {
        return this.signatureProvider;
    }

    void execute(Runnable runnable) {
        this.executor.execute(runnable);
    }
}

