/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.android;

import android.os.Build;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public class MultipartUtility {
    public static final String USER_AGENT = "CloudinaryAndroid/1.26.0 (Android " + Build.VERSION.RELEASE + "; " + Build.MODEL + " Build/" + Build.DISPLAY + ") CloudinaryJava/" + "1.22.0";
    private static final String LINE_FEED = "\r\n";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private final String boundary;
    private final MultipartCallback multipartCallback;
    private HttpURLConnection httpConn;
    private String charset;
    private OutputStream outputStream;
    private PrintWriter writer;

    public MultipartUtility(String requestURL, String charset, String boundary, Map<String, String> headers) throws IOException {
        this(requestURL, charset, boundary, headers, null);
    }

    public MultipartUtility(String requestURL, String charset, String boundary, Map<String, String> headers, MultipartCallback multipartCallback) throws IOException {
        this(requestURL, charset, boundary, headers, multipartCallback, 0, 0);
    }

    public MultipartUtility(String requestURL, String charset, String boundary, Map<String, String> headers, MultipartCallback multipartCallback, int connectTimeout, int readTimeout) throws IOException {
        this.charset = charset;
        this.boundary = boundary;
        this.multipartCallback = multipartCallback;
        URL url = new URL(requestURL);
        this.httpConn = (HttpURLConnection)url.openConnection();
        if (connectTimeout > 0) {
            this.httpConn.setConnectTimeout(connectTimeout);
        }
        if (readTimeout > 0) {
            this.httpConn.setReadTimeout(readTimeout);
        }
        this.httpConn.setDoOutput(true);
        this.httpConn.setChunkedStreamingMode(0);
        this.httpConn.setDoInput(true);
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                this.httpConn.setRequestProperty(header.getKey(), header.getValue());
            }
        }
        this.httpConn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        this.httpConn.setRequestProperty("User-Agent", USER_AGENT);
        this.outputStream = this.httpConn.getOutputStream();
        this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.outputStream, charset), true);
    }

    public MultipartUtility(String requestURL, String charset, String boundary) throws IOException {
        this(requestURL, charset, boundary, null, null);
    }

    public void addFormField(String name, String value) {
        this.writer.append("--" + this.boundary).append(LINE_FEED);
        this.writer.append("Content-Disposition: form-data; name=\"" + name + "\"").append(LINE_FEED);
        this.writer.append("Content-Type: text/plain; charset=" + this.charset).append(LINE_FEED);
        this.writer.append(LINE_FEED);
        this.writer.append(value).append(LINE_FEED);
        this.writer.flush();
    }

    public void addFilePart(String fieldName, File uploadFile, String fileName) throws IOException {
        if (fileName == null) {
            fileName = uploadFile.getName();
        }
        FileInputStream inputStream = new FileInputStream(uploadFile);
        this.addFilePart(fieldName, inputStream, fileName);
    }

    public void addFilePart(String fieldName, File uploadFile) throws IOException {
        this.addFilePart(fieldName, uploadFile, "file");
    }

    public void addFilePart(String fieldName, InputStream inputStream, String fileName) throws IOException {
        int bytesRead;
        if (fileName == null) {
            fileName = "file";
        }
        this.writer.append("--" + this.boundary).append(LINE_FEED);
        this.writer.append("Content-Disposition: form-data; name=\"" + fieldName + "\"; filename=\"" + fileName + "\"").append(LINE_FEED);
        this.writer.append("Content-Type: ").append(APPLICATION_OCTET_STREAM).append(LINE_FEED);
        this.writer.append("Content-Transfer-Encoding: binary").append(LINE_FEED);
        this.writer.append(LINE_FEED);
        this.writer.flush();
        byte[] buffer = new byte[4096];
        long totalRead = 0L;
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            this.outputStream.write(buffer, 0, bytesRead);
            this.notifyCallback(totalRead += (long)bytesRead);
        }
        this.outputStream.flush();
        inputStream.close();
        this.writer.append(LINE_FEED);
        this.writer.flush();
    }

    private void notifyCallback(long bytes) {
        if (this.multipartCallback != null) {
            this.multipartCallback.totalBytesLoaded(bytes);
        }
    }

    public void addFilePart(String fieldName, InputStream inputStream) throws IOException {
        this.addFilePart(fieldName, inputStream, "file");
    }

    public HttpURLConnection execute() throws IOException {
        this.writer.append("--" + this.boundary + "--").append(LINE_FEED);
        this.writer.close();
        return this.httpConn;
    }

    public void close() {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    static interface MultipartCallback {
        public void totalBytesLoaded(long var1);
    }
}

