/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.android;

import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import com.cloudinary.Cloudinary;
import com.cloudinary.Url;

public class ResponsiveUrl {
    private static final int DEFAULT_MIN_DIMENSION = 200;
    private static final int DEFAULT_MAX_DIMENSION = 1000;
    private static final int DEFAULT_STEP_SIZE = 200;
    private static final SparseArray<Url> viewsInProgress = new SparseArray();
    private final Cloudinary cloudinary;
    private final String cropMode;
    private final String gravity;
    private final boolean autoWidth;
    private final boolean autoHeight;
    private int stepSize = 200;
    private int maxDimension = 1000;
    private int minDimension = 200;

    ResponsiveUrl(@NonNull Cloudinary cloudinary, boolean autoWidth, boolean autoHeight, @Nullable String cropMode, @Nullable String gravity) {
        this.cloudinary = cloudinary;
        this.autoWidth = autoWidth;
        this.autoHeight = autoHeight;
        this.cropMode = cropMode;
        this.gravity = gravity;
    }

    public ResponsiveUrl stepSize(int stepSize) {
        this.stepSize = stepSize;
        return this;
    }

    public ResponsiveUrl maxDimension(int maxDimension) {
        this.maxDimension = maxDimension;
        return this;
    }

    public ResponsiveUrl minDimension(int minDimension) {
        this.minDimension = minDimension;
        return this;
    }

    public void generate(String publicId, View view, Callback callback) {
        this.generate(this.cloudinary.url().publicId((Object)publicId), view, callback);
    }

    public void generate(final Url baseUrl, final View view, final Callback callback) {
        this.assertViewValidForResponsive(view);
        final int key = view.hashCode();
        int width = view.getWidth();
        int height = view.getHeight();
        if (this.conditionsAreMet(width, height)) {
            callback.onUrlReady(this.buildUrl(view, baseUrl));
            viewsInProgress.remove(key);
        } else {
            viewsInProgress.put(key, (Object)baseUrl);
            view.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    view.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    if (baseUrl.equals(viewsInProgress.get(key))) {
                        callback.onUrlReady(ResponsiveUrl.this.buildUrl(view, baseUrl));
                        viewsInProgress.remove(key);
                    }
                    return true;
                }
            });
        }
    }

    private void assertViewValidForResponsive(View view) {
        if (Build.VERSION.SDK_INT >= 16 && view instanceof ImageView && ((ImageView)view).getAdjustViewBounds()) {
            throw new IllegalArgumentException("Cannot use responsive Url with AdjustViewBounds");
        }
    }

    private boolean conditionsAreMet(int width, int height) {
        boolean widthOk = !this.autoWidth || width > 0;
        boolean heightOk = !this.autoHeight || height > 0;
        return widthOk && heightOk;
    }

    private Url buildUrl(View view, Url baseUrl) {
        Url url = baseUrl.clone();
        url.transformation().chain();
        if (this.autoHeight) {
            int contentHeight = view.getHeight() - view.getPaddingTop() - view.getPaddingBottom();
            url.transformation().height((Object)this.trimAndRoundUp(contentHeight));
        }
        if (this.autoWidth) {
            int contentWidth = view.getWidth() - view.getPaddingLeft() - view.getPaddingRight();
            url.transformation().width((Object)this.trimAndRoundUp(contentWidth));
        }
        url.transformation().crop(this.cropMode).gravity(this.gravity);
        return url;
    }

    private int trimAndRoundUp(int dimension) {
        int value = ((dimension - 1) / this.stepSize + 1) * this.stepSize;
        return Math.max(this.minDimension, Math.min(value, this.maxDimension));
    }

    public static interface Callback {
        public void onUrlReady(Url var1);
    }

    public static enum Preset {
        AUTO_FILL(true, true, "fill", "auto"),
        FIT(true, true, "fit", "center");

        private final boolean autoWidth;
        private final boolean autoHeight;
        private final String cropMode;
        private final String gravity;

        private Preset(boolean autoWidth, boolean autoHeight, String cropMode, String gravity) {
            this.autoWidth = autoWidth;
            this.autoHeight = autoHeight;
            this.cropMode = cropMode;
            this.gravity = gravity;
        }

        public ResponsiveUrl get(Cloudinary cloudinary) {
            return new ResponsiveUrl(cloudinary, this.autoWidth, this.autoHeight, this.cropMode, this.gravity);
        }
    }
}

