/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.android;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.cloudinary.android.InvalidParamsException;
import com.cloudinary.android.Logger;
import com.cloudinary.android.MediaManager;
import com.cloudinary.android.RequestDispatcher;
import com.cloudinary.android.RequestParams;
import com.cloudinary.android.UploadContext;
import com.cloudinary.android.callback.ErrorInfo;
import com.cloudinary.android.callback.UploadCallback;
import com.cloudinary.android.payload.FilePayload;
import com.cloudinary.android.payload.Payload;
import com.cloudinary.android.payload.PayloadNotFoundException;
import com.cloudinary.android.policy.TimeWindow;
import com.cloudinary.android.policy.UploadPolicy;
import com.cloudinary.android.preprocess.PreprocessChain;
import com.cloudinary.android.preprocess.PreprocessException;
import com.cloudinary.utils.ObjectUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class UploadRequest<T extends Payload> {
    private static final String TAG = UploadRequest.class.getSimpleName();
    private final UploadContext<T> uploadContext;
    private final Object optionsLockObject = new Object();
    private PreprocessChain preprocessChain;
    private String requestId = UUID.randomUUID().toString();
    private boolean dispatched = false;
    private UploadPolicy uploadPolicy = MediaManager.get().getGlobalUploadPolicy();
    private TimeWindow timeWindow = TimeWindow.getDefault();
    private UploadCallback callback;
    private Map<String, Object> options;
    private String optionsAsString = null;
    private Long maxFileSize;
    private boolean startNow = false;

    UploadRequest(UploadContext<T> uploadContext) {
        this.uploadContext = uploadContext;
    }

    UploadRequest(UploadContext<T> uploadContext, @Nullable Map<String, Object> options) {
        this.uploadContext = uploadContext;
        this.options = options;
    }

    static String encodeOptions(Map<String, Object> options) throws IOException {
        return ObjectUtils.serialize(options);
    }

    static Map<String, Object> decodeOptions(String encoded) throws IOException, ClassNotFoundException {
        return (Map)ObjectUtils.deserialize((String)encoded);
    }

    public synchronized UploadRequest<T> callback(UploadCallback callback) {
        this.assertNotDispatched();
        this.callback = new DelegateCallback(callback);
        return this;
    }

    public synchronized UploadRequest<T> unsigned(String uploadPreset) {
        this.assertNotDispatched();
        this.verifyOptionsExist();
        this.options.put("unsigned", true);
        this.options.put("upload_preset", uploadPreset);
        return this;
    }

    public synchronized UploadRequest<T> maxFileSize(long bytes) {
        this.assertNotDispatched();
        this.maxFileSize = bytes;
        return this;
    }

    public synchronized UploadRequest<T> preprocess(PreprocessChain preprocessChain) {
        this.assertNotDispatched();
        this.preprocessChain = preprocessChain;
        return this;
    }

    public synchronized UploadRequest<T> constrain(TimeWindow timeWindow) {
        this.assertNotDispatched();
        this.timeWindow = timeWindow;
        return this;
    }

    public synchronized UploadRequest<T> options(Map<String, Object> options) {
        this.assertNotDispatched();
        this.options = options;
        return this;
    }

    public synchronized UploadRequest<T> option(String name, Object value) {
        this.assertNotDispatched();
        this.verifyOptionsExist();
        this.options.put(name, value);
        return this;
    }

    public synchronized UploadRequest<T> policy(UploadPolicy policy) {
        this.assertNotDispatched();
        this.uploadPolicy = policy;
        return this;
    }

    public synchronized String dispatch() {
        return this.dispatch(null);
    }

    public synchronized String startNow(@NonNull Context context) {
        this.startNow = true;
        return this.dispatch(context);
    }

    public synchronized String dispatch(final @Nullable Context context) {
        boolean hasPreprocess;
        this.assertNotDispatched();
        this.verifyOptionsExist();
        this.dispatched = true;
        this.serializeOptions();
        MediaManager.get().registerCallback(this.requestId, this.callback);
        final RequestDispatcher dispatcher = this.uploadContext.getDispatcher();
        boolean bl = hasPreprocess = this.preprocessChain != null && !this.preprocessChain.isEmpty();
        if (!hasPreprocess && this.maxFileSize == null) {
            this.doDispatch(dispatcher, context, this);
        } else {
            if (context == null) {
                throw new IllegalArgumentException("A valid android context must be supplied to UploadRequest.dispatch() when using preprocessing or setting maxFileSize");
            }
            MediaManager.get().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        UploadRequest newRequest = UploadRequest.this.preprocessChain != null ? UploadRequest.this.preprocessAndClone(context) : UploadRequest.this;
                        long length = ((Payload)newRequest.getPayload()).getLength(context);
                        if (UploadRequest.this.maxFileSize != null && length > UploadRequest.this.maxFileSize) {
                            MediaManager.get().dispatchRequestError(context, UploadRequest.this.requestId, new ErrorInfo(12, String.format("Payload size is too large, %d, max is %d", length, UploadRequest.this.maxFileSize)));
                        } else {
                            UploadRequest.this.doDispatch(dispatcher, context, newRequest);
                        }
                    }
                    catch (RuntimeException e) {
                        Logger.e(TAG, "Error running preprocess for request", e);
                        MediaManager.get().dispatchRequestError(context, UploadRequest.this.requestId, new ErrorInfo(12, e.getClass().getSimpleName() + ": " + e.getMessage()));
                    }
                    catch (PreprocessException e) {
                        MediaManager.get().dispatchRequestError(context, UploadRequest.this.requestId, new ErrorInfo(12, e.getClass().getSimpleName() + ": " + e.getMessage()));
                    }
                    catch (PayloadNotFoundException e) {
                        MediaManager.get().dispatchRequestError(context, UploadRequest.this.requestId, new ErrorInfo(12, e.getClass().getSimpleName() + ": " + e.getMessage()));
                    }
                }
            });
        }
        return this.requestId;
    }

    private void doDispatch(RequestDispatcher dispatcher, @Nullable Context context, UploadRequest<T> uploadRequest) {
        if (this.startNow) {
            if (context == null) {
                throw new IllegalArgumentException("Context cannot be null when calling startNow()");
            }
            dispatcher.startNow(context, uploadRequest);
        } else {
            dispatcher.dispatch(uploadRequest);
        }
    }

    synchronized void serializeOptions() {
        try {
            this.optionsAsString = UploadRequest.encodeOptions(this.options);
        }
        catch (IOException e) {
            throw new InvalidParamsException("Parameters must be serializable", e);
        }
    }

    private UploadRequest preprocessAndClone(Context context) throws PayloadNotFoundException, PreprocessException {
        String newFile = this.preprocessChain.execute(context, (Payload)this.getPayload());
        UploadRequest<FilePayload> uploadRequest = new UploadRequest<FilePayload>(new UploadContext<FilePayload>(new FilePayload(newFile), this.getUploadContext().getDispatcher()));
        uploadRequest.uploadPolicy = this.uploadPolicy;
        uploadRequest.timeWindow = TimeWindow.getDefault();
        uploadRequest.callback = this.callback;
        uploadRequest.options = this.options;
        uploadRequest.optionsAsString = this.optionsAsString;
        uploadRequest.requestId = this.requestId;
        uploadRequest.dispatched = this.dispatched;
        return uploadRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyOptionsExist() {
        if (this.options == null) {
            Object object = this.optionsLockObject;
            synchronized (object) {
                if (this.options == null) {
                    this.options = new HashMap<String, Object>();
                }
            }
        }
    }

    String getRequestId() {
        return this.requestId;
    }

    T getPayload() {
        return this.uploadContext.getPayload();
    }

    UploadCallback getCallback() {
        return this.callback;
    }

    UploadContext<T> getUploadContext() {
        return this.uploadContext;
    }

    TimeWindow getTimeWindow() {
        return this.timeWindow;
    }

    private void assertNotDispatched() {
        if (this.dispatched) {
            throw new IllegalStateException("Request already dispatched");
        }
    }

    private String getOptionsString() {
        return this.optionsAsString;
    }

    UploadPolicy getUploadPolicy() {
        return this.uploadPolicy;
    }

    void defferByMinutes(int minutes) {
        this.timeWindow = this.timeWindow.newDeferredWindow(minutes);
    }

    void populateParamsFromFields(RequestParams target) {
        target.putString("uri", ((Payload)this.getPayload()).toUri());
        target.putString("requestId", this.getRequestId());
        target.putInt("maxErrorRetries", this.getUploadPolicy().getMaxErrorRetries());
        target.putString("options", this.getOptionsString());
    }

    private static final class DelegateCallback
    implements UploadCallback {
        private final UploadCallback callback;

        DelegateCallback(UploadCallback callback) {
            this.callback = callback;
        }

        @Override
        public void onStart(String requestId) {
            this.callback.onStart(requestId);
        }

        @Override
        public void onProgress(String requestId, long bytes, long totalBytes) {
            this.callback.onProgress(requestId, bytes, totalBytes);
        }

        @Override
        public void onSuccess(String requestId, Map resultData) {
            this.callback.onSuccess(requestId, resultData);
            MediaManager.get().unregisterCallback(this);
        }

        @Override
        public void onError(String requestId, ErrorInfo error) {
            this.callback.onError(requestId, error);
            MediaManager.get().unregisterCallback(this);
        }

        @Override
        public void onReschedule(String requestId, ErrorInfo error) {
            this.callback.onReschedule(requestId, error);
        }
    }
}

