/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.android;

import com.cloudinary.ProgressCallback;
import com.cloudinary.android.MultipartUtility;
import com.cloudinary.strategies.AbstractUploaderStrategy;
import com.cloudinary.utils.ObjectUtils;
import com.cloudinary.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.Collection;
import java.util.Map;
import org.cloudinary.json.JSONException;
import org.cloudinary.json.JSONObject;

public class UploaderStrategy
extends AbstractUploaderStrategy {
    protected static String readFully(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int length = 0;
        while ((length = in.read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        return new String(baos.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map callApi(String action, Map<String, Object> params, Map options, Object file, final ProgressCallback progressCallback) throws IOException {
        int code;
        HttpURLConnection connection;
        MultipartUtility.MultipartCallback multipartCallback;
        if (options == null) {
            options = ObjectUtils.emptyMap();
        }
        boolean returnError = ObjectUtils.asBoolean(options.get("return_error"), (Boolean)false);
        if (this.requiresSigning(action, options)) {
            String apiKey = ObjectUtils.asString(options.get("api_key"), (String)this.cloudinary().config.apiKey);
            if (apiKey == null) {
                throw new IllegalArgumentException("Must supply api_key");
            }
            if (options.containsKey("signature") && options.containsKey("timestamp")) {
                params.put("timestamp", options.get("timestamp"));
                params.put("signature", options.get("signature"));
                params.put("api_key", apiKey);
            } else {
                String apiSecret = ObjectUtils.asString(options.get("api_secret"), (String)this.cloudinary().config.apiSecret);
                if (apiSecret == null) {
                    throw new IllegalArgumentException("Must supply api_secret");
                }
                params.put("timestamp", Long.valueOf(System.currentTimeMillis() / 1000L).toString());
                params.put("signature", this.cloudinary().apiSignRequest(params, apiSecret));
                params.put("api_key", apiKey);
            }
        }
        String apiUrl = this.buildUploadUrl(action, options);
        if (progressCallback == null) {
            multipartCallback = null;
        } else {
            final long totalBytes = this.determineLength(file);
            multipartCallback = new MultipartUtility.MultipartCallback(){

                @Override
                public void totalBytesLoaded(long bytes) {
                    progressCallback.onProgress(bytes, totalBytes);
                }
            };
        }
        try (MultipartUtility multipart = null;){
            int connectTimeout = options.get("connect_timeout") != null ? (Integer)options.get("connect_timeout") : 0;
            int readTimeout = options.get("read_timeout") != null ? (Integer)options.get("read_timeout") : 0;
            multipart = new MultipartUtility(apiUrl, "UTF-8", this.cloudinary().randomPublicId(), (Map)options.get("extra_headers"), multipartCallback, connectTimeout, readTimeout);
            for (Map.Entry<String, Object> param : params.entrySet()) {
                if (param.getValue() instanceof Collection) {
                    for (Object value : (Collection)param.getValue()) {
                        multipart.addFormField(param.getKey() + "[]", ObjectUtils.asString(value));
                    }
                    continue;
                }
                if (!StringUtils.isNotBlank((Object)param.getValue())) continue;
                multipart.addFormField(param.getKey(), param.getValue().toString());
            }
            if (file instanceof String && !((String)file).matches("(?s)ftp:.*|https?:.*|s3:.*|gs:.*|data:[^;]*;base64,([a-zA-Z0-9/+\n=]+)")) {
                file = new File((String)file);
            }
            String filename = (String)options.get("filename");
            if (file instanceof File) {
                multipart.addFilePart("file", (File)file, filename);
            } else if (file instanceof String) {
                multipart.addFormField("file", (String)file);
            } else if (file instanceof InputStream) {
                multipart.addFilePart("file", (InputStream)file, filename);
            } else if (file instanceof byte[]) {
                multipart.addFilePart("file", new ByteArrayInputStream((byte[])file), filename);
            }
            connection = multipart.execute();
        }
        try {
            code = connection.getResponseCode();
        }
        catch (IOException e) {
            if (e.getMessage().equals("No authentication challenges found")) {
                code = 401;
            }
            throw e;
        }
        InputStream responseStream = code >= 400 ? connection.getErrorStream() : connection.getInputStream();
        String responseData = UploaderStrategy.readFully(responseStream);
        connection.disconnect();
        if (code != 200 && code != 400 && code != 404 && code != 500) {
            throw new RuntimeException("Server returned unexpected status code - " + code + " - " + responseData);
        }
        try {
            JSONObject result = new JSONObject(responseData);
            if (result.has("error")) {
                JSONObject error = result.getJSONObject("error");
                if (returnError) {
                    error.put("http_code", code);
                } else {
                    throw new RuntimeException(error.getString("message"));
                }
            }
            return ObjectUtils.toMap((JSONObject)result);
        }
        catch (JSONException e) {
            throw new RuntimeException("Invalid JSON response from server " + e.getMessage());
        }
    }

    private long determineLength(Object file) {
        long actualLength = -1L;
        if (file != null) {
            if (file instanceof File) {
                actualLength = ((File)file).length();
            } else if (file instanceof byte[]) {
                actualLength = ((byte[])file).length;
            } else if (!(file instanceof InputStream)) {
                File f = new File(file.toString());
                actualLength = f.length();
            }
        }
        return actualLength;
    }
}

