/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.android.policy;

public class UploadPolicy {
    private static final int DEFAULT_MAX_ERROR_RETRIES = 5;
    private static final long DEFAULT_BACKOFF_MILLIS = 120000L;
    private static final BackoffPolicy DEFAULT_BACKOFF_POLICY = BackoffPolicy.EXPONENTIAL;
    private static String TAG = "UploadPolicy";
    private final NetworkType networkType;
    private final boolean requiresCharging;
    private final boolean requiresIdle;
    private final int maxErrorRetries;
    private final long backoffMillis;
    private final BackoffPolicy backoffPolicy;

    protected UploadPolicy(NetworkType networkType, boolean requiresCharging, boolean requiresIdle, int maxErrorRetries, long backoffMillis, BackoffPolicy backoffPolicy) {
        this.networkType = networkType;
        this.requiresCharging = requiresCharging;
        this.requiresIdle = requiresIdle;
        this.maxErrorRetries = maxErrorRetries;
        this.backoffMillis = backoffMillis;
        this.backoffPolicy = backoffPolicy;
    }

    public static UploadPolicy defaultPolicy() {
        return new Builder().build();
    }

    public NetworkType getNetworkType() {
        return this.networkType;
    }

    public boolean isRequiresCharging() {
        return this.requiresCharging;
    }

    public boolean isRequiresIdle() {
        return this.requiresIdle;
    }

    public int getMaxErrorRetries() {
        return this.maxErrorRetries;
    }

    public BackoffPolicy getBackoffPolicy() {
        return this.backoffPolicy;
    }

    public long getBackoffMillis() {
        return this.backoffMillis;
    }

    public boolean hasRequirements() {
        return this.requiresCharging || this.requiresIdle || this.networkType == NetworkType.UNMETERED;
    }

    public Builder newBuilder() {
        return (Builder)((Builder)((Builder)((Builder)((Builder)new Builder().requiresCharging(this.requiresCharging)).requiresIdle(this.requiresIdle)).backoffCriteria(this.backoffMillis, this.backoffPolicy)).maxRetries(this.maxErrorRetries)).networkPolicy(this.networkType);
    }

    static /* synthetic */ BackoffPolicy access$000() {
        return DEFAULT_BACKOFF_POLICY;
    }

    public static class Builder
    extends BaseBuilder<Builder> {
    }

    static abstract class BaseBuilder<T extends BaseBuilder> {
        NetworkType networkPolicy = NetworkType.ANY;
        boolean requiresCharging = false;
        boolean requiresIdle = false;
        int maxRetries = 5;
        long backoffMillis = 120000L;
        BackoffPolicy backoffPolicy = UploadPolicy.access$000();

        BaseBuilder() {
        }

        public T networkPolicy(NetworkType networkPolicy) {
            if (networkPolicy == NetworkType.NONE) {
                throw new IllegalArgumentException("An upload request requires network");
            }
            this.networkPolicy = networkPolicy;
            return (T)this;
        }

        public T requiresCharging(boolean requiresCharging) {
            this.requiresCharging = requiresCharging;
            return (T)this;
        }

        public T requiresIdle(boolean requiresIdle) {
            this.requiresIdle = requiresIdle;
            return (T)this;
        }

        public T maxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return (T)this;
        }

        public T backoffCriteria(long backoffMs, BackoffPolicy backoffPolicy) {
            this.backoffMillis = backoffMs;
            this.backoffPolicy = backoffPolicy;
            return (T)this;
        }

        public UploadPolicy build() {
            return new UploadPolicy(this.networkPolicy, this.requiresCharging, this.requiresIdle, this.maxRetries, this.backoffMillis, this.backoffPolicy);
        }
    }

    public static enum BackoffPolicy {
        LINEAR,
        EXPONENTIAL;

    }

    public static enum NetworkType {
        NONE,
        ANY,
        UNMETERED;

    }
}

