/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.android.preprocess;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.cloudinary.android.payload.Payload;
import com.cloudinary.android.payload.PayloadNotFoundException;
import com.cloudinary.android.preprocess.PayloadDecodeException;
import com.cloudinary.android.preprocess.ResourceDecoder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class BitmapDecoder
implements ResourceDecoder<Bitmap> {
    private final int width;
    private final int height;

    public BitmapDecoder() {
        this(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public BitmapDecoder(int width, int height) {
        this.width = width;
        this.height = height;
    }

    private static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int halfHeight = height / 2;
            int halfWidth = width / 2;
            while (halfHeight / inSampleSize >= reqHeight && halfWidth / inSampleSize >= reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }

    @Override
    public Bitmap decode(Context context, Payload payload) throws PayloadNotFoundException, PayloadDecodeException {
        return this.bitmapFromPayload(context, payload, this.width, this.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Bitmap bitmapFromPayload(Context context, Payload payload, int width, int height) throws PayloadNotFoundException, PayloadDecodeException {
        Object resource = payload.prepare(context);
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        Bitmap bitmap = null;
        if (resource instanceof File) {
            BitmapFactory.decodeFile((String)((File)resource).getPath(), (BitmapFactory.Options)options);
            options.inSampleSize = BitmapDecoder.calculateInSampleSize(options, width, height);
            options.inJustDecodeBounds = false;
            bitmap = BitmapFactory.decodeFile((String)((File)resource).getPath(), (BitmapFactory.Options)options);
        } else {
            if (resource instanceof InputStream) {
                InputStream is = null;
                try {
                    BitmapFactory.decodeStream((InputStream)((InputStream)resource), null, (BitmapFactory.Options)options);
                    options.inSampleSize = BitmapDecoder.calculateInSampleSize(options, width, height);
                    options.inJustDecodeBounds = false;
                    is = (InputStream)payload.prepare(context);
                    bitmap = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
                }
                finally {
                    try {
                        ((InputStream)resource).close();
                    }
                    catch (IOException iOException) {}
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            if (resource instanceof byte[]) {
                byte[] data = (byte[])resource;
                BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)options);
                options.inSampleSize = BitmapDecoder.calculateInSampleSize(options, width, height);
                options.inJustDecodeBounds = false;
                bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)options);
            }
        }
        if (bitmap == null) {
            throw new PayloadDecodeException();
        }
        return bitmap;
    }
}

