/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary;

import com.cloudinary.Api;
import com.cloudinary.Configuration;
import com.cloudinary.Transformation;
import com.cloudinary.Uploader;
import com.cloudinary.Url;
import com.cloudinary.Util;
import com.cloudinary.strategies.AbstractApiStrategy;
import com.cloudinary.strategies.AbstractUploaderStrategy;
import com.cloudinary.strategies.AbstractUrlBuilderStrategy;
import com.cloudinary.strategies.StrategyLoader;
import com.cloudinary.utils.ObjectUtils;
import com.cloudinary.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Cloudinary {
    private static List<String> UPLOAD_STRATEGIES = new ArrayList<String>(Arrays.asList("com.cloudinary.android.UploaderStrategy", "com.cloudinary.http42.UploaderStrategy", "com.cloudinary.http43.UploaderStrategy"));
    private static List<String> API_STRATEGIES = new ArrayList<String>(Arrays.asList("com.cloudinary.android.ApiStrategy", "com.cloudinary.http42.ApiStrategy", "com.cloudinary.http43.ApiStrategy"));
    private static List<String> URLBUILDER_STRATEGIES = new ArrayList<String>(Arrays.asList("com.cloudinary.android.UrlBuilderStrategy", "com.cloudinary.http42.UrlBuilderStrategy", "com.cloudinary.http43.UrlBuilderStrategy"));
    public static final String CF_SHARED_CDN = "d3jpl91pxevbkh.cloudfront.net";
    public static final String OLD_AKAMAI_SHARED_CDN = "cloudinary-a.akamaihd.net";
    public static final String AKAMAI_SHARED_CDN = "res.cloudinary.com";
    public static final String SHARED_CDN = "res.cloudinary.com";
    public static final String VERSION = "1.1.3";
    public static final String USER_AGENT = "cld-java-1.1.3";
    public final Configuration config;
    private AbstractUploaderStrategy uploaderStrategy;
    private AbstractApiStrategy apiStrategy;
    private AbstractUrlBuilderStrategy urlBuilderStrategy;
    private static final SecureRandom RND = new SecureRandom();

    public Uploader uploader() {
        return new Uploader(this, this.uploaderStrategy);
    }

    public Api api() {
        return new Api(this, this.apiStrategy);
    }

    public static void registerUploaderStrategy(String className) {
        if (!UPLOAD_STRATEGIES.contains(className)) {
            UPLOAD_STRATEGIES.add(className);
        }
    }

    public static void registerAPIStrategy(String className) {
        if (!API_STRATEGIES.contains(className)) {
            API_STRATEGIES.add(className);
        }
    }

    public static void registerUrlBuilderStrategy(String className) {
        if (!URLBUILDER_STRATEGIES.contains(className)) {
            URLBUILDER_STRATEGIES.add(className);
        }
    }

    private void loadStrategies() {
        this.uploaderStrategy = (AbstractUploaderStrategy)StrategyLoader.find(UPLOAD_STRATEGIES);
        if (this.uploaderStrategy == null) {
            throw new UnknownError("Can't find Cloudinary platform adapter [" + StringUtils.join(UPLOAD_STRATEGIES, ",") + "]");
        }
        this.apiStrategy = (AbstractApiStrategy)StrategyLoader.find(API_STRATEGIES);
        if (this.apiStrategy == null) {
            throw new UnknownError("Can't find Cloudinary platform adapter [" + StringUtils.join(API_STRATEGIES, ",") + "]");
        }
        this.urlBuilderStrategy = (AbstractUrlBuilderStrategy)StrategyLoader.find(URLBUILDER_STRATEGIES);
        if (this.urlBuilderStrategy == null) {
            throw new UnknownError("Can't find Cloudinary platform adapter [" + StringUtils.join(URLBUILDER_STRATEGIES, ",") + "]");
        }
    }

    public Cloudinary(Map config) {
        this.loadStrategies();
        this.config = new Configuration(config);
    }

    public Cloudinary(String cloudinaryUrl) {
        this.loadStrategies();
        this.config = new Configuration(this.parseConfigUrl(cloudinaryUrl));
    }

    public Cloudinary() {
        this.loadStrategies();
        String cloudinaryUrl = System.getProperty("CLOUDINARY_URL", System.getenv("CLOUDINARY_URL"));
        this.config = cloudinaryUrl != null ? new Configuration(this.parseConfigUrl(cloudinaryUrl)) : new Configuration();
    }

    public Url url() {
        return new Url(this);
    }

    public String cloudinaryApiUrl(String action, Map options) {
        String cloudinary = ObjectUtils.asString(options.get("upload_prefix"), ObjectUtils.asString(this.config.uploadPrefix, "https://api.cloudinary.com"));
        String cloud_name = ObjectUtils.asString(options.get("cloud_name"), ObjectUtils.asString(this.config.cloudName));
        if (cloud_name == null) {
            throw new IllegalArgumentException("Must supply cloud_name in tag or in configuration");
        }
        String resource_type = ObjectUtils.asString(options.get("resource_type"), "image");
        return StringUtils.join(new String[]{cloudinary, "v1_1", cloud_name, resource_type, action}, "/");
    }

    public String randomPublicId() {
        byte[] bytes = new byte[8];
        RND.nextBytes(bytes);
        return StringUtils.encodeHexString(bytes);
    }

    public String signedPreloadedImage(Map result) {
        return result.get("resource_type") + "/upload/v" + result.get("version") + "/" + result.get("public_id") + (result.containsKey("format") ? "." + result.get("format") : "") + "#" + result.get("signature");
    }

    public String apiSignRequest(Map<String, Object> paramsToSign, String apiSecret) {
        ArrayList<String> params = new ArrayList<String>();
        for (Map.Entry<String, Object> param : new TreeMap<String, Object>(paramsToSign).entrySet()) {
            if (param.getValue() instanceof Collection) {
                params.add(param.getKey() + "=" + StringUtils.join((Collection)param.getValue(), ","));
                continue;
            }
            if (!StringUtils.isNotBlank(param.getValue())) continue;
            params.add(param.getKey() + "=" + param.getValue().toString());
        }
        String to_sign = StringUtils.join(params, "&");
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
        byte[] digest = md.digest((to_sign + apiSecret).getBytes());
        return StringUtils.encodeHexString(digest);
    }

    public void signRequest(Map<String, Object> params, Map<String, Object> options) {
        String apiKey = ObjectUtils.asString(options.get("api_key"), this.config.apiKey);
        if (apiKey == null) {
            throw new IllegalArgumentException("Must supply api_key");
        }
        String apiSecret = ObjectUtils.asString(options.get("api_secret"), this.config.apiSecret);
        if (apiSecret == null) {
            throw new IllegalArgumentException("Must supply api_secret");
        }
        Util.clearEmpty(params);
        params.put("signature", this.apiSignRequest(params, apiSecret));
        params.put("api_key", apiKey);
    }

    public String privateDownload(String publicId, String format, Map<String, Object> options) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("public_id", publicId);
        params.put("format", format);
        params.put("attachment", options.get("attachment"));
        params.put("type", options.get("type"));
        params.put("timestamp", new Long(System.currentTimeMillis() / 1000L).toString());
        this.signRequest(params, options);
        AbstractUrlBuilderStrategy builder = this.urlBuilderStrategy.init(this.cloudinaryApiUrl("download", options));
        for (Map.Entry param : params.entrySet()) {
            builder.addParam((String)param.getKey(), param.getValue().toString());
        }
        return builder.url();
    }

    public String zipDownload(String tag, Map<String, Object> options) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("timestamp", new Long(System.currentTimeMillis() / 1000L).toString());
        params.put("tag", tag);
        Object transformation = options.get("transformation");
        if (transformation != null) {
            if (transformation instanceof Transformation) {
                transformation = ((Transformation)transformation).generate();
            }
            params.put("transformation", transformation.toString());
        }
        params.put("transformation", transformation);
        this.signRequest(params, options);
        AbstractUrlBuilderStrategy builder = this.urlBuilderStrategy.init(this.cloudinaryApiUrl("download_tag.zip", options));
        for (Map.Entry param : params.entrySet()) {
            builder.addParam((String)param.getKey(), param.getValue().toString());
        }
        return builder.url();
    }

    protected Map parseConfigUrl(String cloudinaryUrl) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        URI cloudinaryUri = URI.create(cloudinaryUrl);
        params.put("cloud_name", cloudinaryUri.getHost());
        if (cloudinaryUri.getUserInfo() != null) {
            String[] creds = cloudinaryUri.getUserInfo().split(":");
            params.put("api_key", creds[0]);
            params.put("api_secret", creds[1]);
        }
        params.put("private_cdn", !StringUtils.isEmpty(cloudinaryUri.getPath()));
        params.put("secure_distribution", cloudinaryUri.getPath());
        if (cloudinaryUri.getQuery() != null) {
            for (String param : cloudinaryUri.getQuery().split("&")) {
                String[] keyValue = param.split("=");
                try {
                    params.put(keyValue[0], URLDecoder.decode(keyValue[1], "ASCII"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Unexpected exception", e);
                }
            }
        }
        return params;
    }

    @Deprecated
    public static Map asMap(Object ... values) {
        return ObjectUtils.asMap(values);
    }
}

