/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary;

import com.cloudinary.utils.ObjectUtils;
import com.cloudinary.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

public class Configuration {
    public static final String CF_SHARED_CDN = "d3jpl91pxevbkh.cloudfront.net";
    public static final String OLD_AKAMAI_SHARED_CDN = "cloudinary-a.akamaihd.net";
    public static final String AKAMAI_SHARED_CDN = "res.cloudinary.com";
    public static final String SHARED_CDN = "res.cloudinary.com";
    public static final String VERSION = "1.0.2";
    public static final String USER_AGENT = "cld-android-1.0.2";
    public String cloudName;
    public String apiKey;
    public String apiSecret;
    public String secureDistribution;
    public String cname;
    public String uploadPrefix;
    public boolean secure;
    public boolean privateCdn;
    public boolean cdnSubdomain;
    public boolean shorten;
    public String callback;
    public String proxyHost;
    public int proxyPort;
    public Map<String, Object> properties = new HashMap<String, Object>();
    public Boolean secureCdnSubdomain;
    public boolean useRootPath;
    public int timeout;

    public Configuration() {
    }

    private Configuration(String cloudName, String apiKey, String apiSecret, String secureDistribution, String cname, String uploadPrefix, boolean secure, boolean privateCdn, boolean cdnSubdomain, boolean shorten, String callback, String proxyHost, int proxyPort, Boolean secureCdnSubdomain, boolean useRootPath) {
        this(cloudName, apiKey, apiSecret, secureDistribution, cname, uploadPrefix, secure, privateCdn, cdnSubdomain, shorten, callback, proxyHost, proxyPort, secureCdnSubdomain, useRootPath, 0);
    }

    private Configuration(String cloudName, String apiKey, String apiSecret, String secureDistribution, String cname, String uploadPrefix, boolean secure, boolean privateCdn, boolean cdnSubdomain, boolean shorten, String callback, String proxyHost, int proxyPort, Boolean secureCdnSubdomain, boolean useRootPath, int timeout) {
        this.cloudName = cloudName;
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
        this.secureDistribution = secureDistribution;
        this.cname = cname;
        this.uploadPrefix = uploadPrefix;
        this.secure = secure;
        this.privateCdn = privateCdn;
        this.cdnSubdomain = cdnSubdomain;
        this.shorten = shorten;
        this.callback = callback;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.secureCdnSubdomain = secureCdnSubdomain;
        this.useRootPath = useRootPath;
        this.timeout = 0;
    }

    public Configuration(Map config) {
        this.update(config);
    }

    public void update(Map config) {
        this.cloudName = (String)config.get("cloud_name");
        this.apiKey = (String)config.get("api_key");
        this.apiSecret = (String)config.get("api_secret");
        this.secureDistribution = (String)config.get("secure_distribution");
        this.cname = (String)config.get("cname");
        this.secure = ObjectUtils.asBoolean(config.get("secure"), false);
        this.privateCdn = ObjectUtils.asBoolean(config.get("private_cdn"), false);
        this.cdnSubdomain = ObjectUtils.asBoolean(config.get("cdn_subdomain"), false);
        this.shorten = ObjectUtils.asBoolean(config.get("shorten"), false);
        this.uploadPrefix = (String)config.get("upload_prefix");
        this.callback = (String)config.get("callback");
        this.proxyHost = (String)config.get("proxy_host");
        this.proxyPort = ObjectUtils.asInteger(config.get("proxy_port"), 0);
        this.secureCdnSubdomain = ObjectUtils.asBoolean(config.get("secure_cdn_subdomain"), null);
        this.useRootPath = ObjectUtils.asBoolean(config.get("use_root_path"), false);
        this.timeout = ObjectUtils.asInteger(config.get("timeout"), 0);
    }

    public Configuration(Configuration other) {
        this.cloudName = other.cloudName;
        this.apiKey = other.apiKey;
        this.apiSecret = other.apiSecret;
        this.secureDistribution = other.secureDistribution;
        this.cname = other.cname;
        this.uploadPrefix = other.uploadPrefix;
        this.secure = other.secure;
        this.privateCdn = other.privateCdn;
        this.cdnSubdomain = other.cdnSubdomain;
        this.shorten = other.shorten;
        this.callback = other.callback;
        this.proxyHost = other.proxyHost;
        this.proxyPort = other.proxyPort;
        this.secureCdnSubdomain = other.secureCdnSubdomain;
        this.useRootPath = other.useRootPath;
        this.timeout = other.timeout;
    }

    public static Configuration from(Configuration other) {
        return new Builder().from(other).build();
    }

    public static Configuration from(String cloudinaryUrl) {
        return Configuration.from(Configuration.parseConfigUrl(cloudinaryUrl));
    }

    private static Configuration parseConfigUrl(String cloudinaryUrl) {
        Builder builder = new Builder();
        URI cloudinaryUri = URI.create(cloudinaryUrl);
        builder.setCloudName(cloudinaryUri.getHost());
        if (cloudinaryUri.getUserInfo() != null) {
            String[] creds = cloudinaryUri.getUserInfo().split(":");
            builder.setApiKey(creds[0]);
            builder.setApiSecret(creds[1]);
        }
        builder.setPrivateCdn(!StringUtils.isEmpty(cloudinaryUri.getPath()));
        builder.setSecureDistribution(cloudinaryUri.getPath());
        if (cloudinaryUri.getQuery() != null) {
            for (String param : cloudinaryUri.getQuery().split("&")) {
                String[] keyValue = param.split("=");
                String val = null;
                try {
                    val = URLDecoder.decode(keyValue[1], "ASCII");
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException("Error decoding cloudinaryUrl", e);
                }
                String key = keyValue[0];
                if (key.equals("cname")) {
                    builder.setCname(val);
                    continue;
                }
                if (key.equals("upload_prefix")) {
                    builder.setUploadPrefix(val);
                    continue;
                }
                if (key.equals("secure")) {
                    builder.setSecure(ObjectUtils.asBoolean(val, false));
                    continue;
                }
                if (key.equals("cdn_subdomain")) {
                    builder.setCdnSubdomain(ObjectUtils.asBoolean(val, false));
                    continue;
                }
                if (!key.equals("shorten")) continue;
                builder.setShorten(ObjectUtils.asBoolean(val, false));
            }
        }
        return builder.build();
    }

    public static class Builder {
        private String cloudName;
        private String apiKey;
        private String apiSecret;
        private String secureDistribution;
        private String cname;
        private String uploadPrefix;
        private boolean secure;
        private boolean privateCdn;
        private boolean cdnSubdomain;
        private boolean shorten;
        private String callback;
        private String proxyHost;
        private int proxyPort;
        private Boolean secureCdnSubdomain;
        private boolean useRootPath;
        private int timeout;

        public Builder setTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Configuration build() {
            return new Configuration(this.cloudName, this.apiKey, this.apiSecret, this.secureDistribution, this.cname, this.uploadPrefix, this.secure, this.privateCdn, this.cdnSubdomain, this.shorten, this.callback, this.proxyHost, this.proxyPort, this.secureCdnSubdomain, this.useRootPath);
        }

        public Builder setCloudName(String cloudName) {
            this.cloudName = cloudName;
            return this;
        }

        public Builder setApiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder setApiSecret(String apiSecret) {
            this.apiSecret = apiSecret;
            return this;
        }

        public Builder setSecureDistribution(String secureDistribution) {
            this.secureDistribution = secureDistribution;
            return this;
        }

        public Builder setCname(String cname) {
            this.cname = cname;
            return this;
        }

        public Builder setSecure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public Builder setPrivateCdn(boolean privateCdn) {
            this.privateCdn = privateCdn;
            return this;
        }

        public Builder setSecureCdnSubdomain(Boolean secureCdnSubdomain) {
            this.secureCdnSubdomain = secureCdnSubdomain;
            return this;
        }

        public Builder setCdnSubdomain(boolean cdnSubdomain) {
            this.cdnSubdomain = cdnSubdomain;
            return this;
        }

        public Builder setShorten(boolean shorten) {
            this.shorten = shorten;
            return this;
        }

        public Builder setCallback(String callback) {
            this.callback = callback;
            return this;
        }

        public Builder setUploadPrefix(String uploadPrefix) {
            this.uploadPrefix = uploadPrefix;
            return this;
        }

        public Builder setUseRootPath(boolean useRootPath) {
            this.useRootPath = useRootPath;
            return this;
        }

        public Builder from(Configuration other) {
            this.cloudName = other.cloudName;
            this.apiKey = other.apiKey;
            this.apiSecret = other.apiSecret;
            this.secureDistribution = other.secureDistribution;
            this.cname = other.cname;
            this.uploadPrefix = other.uploadPrefix;
            this.secure = other.secure;
            this.privateCdn = other.privateCdn;
            this.cdnSubdomain = other.cdnSubdomain;
            this.shorten = other.shorten;
            this.callback = other.callback;
            this.proxyHost = other.proxyHost;
            this.proxyPort = other.proxyPort;
            this.secureCdnSubdomain = other.secureCdnSubdomain;
            this.useRootPath = other.useRootPath;
            this.timeout = other.timeout;
            return this;
        }
    }
}

