/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary;

import com.cloudinary.Cloudinary;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StoredFile {
    protected Long version;
    protected String publicId;
    protected String format;
    protected String signature;
    protected String type = "upload";
    protected String resourceType = "image";
    private static final String IMAGE_RESOURCE_TYPE = "image";
    private static final String AUTO_RESOURCE_TYPE = "auto";
    private static final Pattern PRELOADED_PATTERN = Pattern.compile("^([^\\/]+)\\/([^\\/]+)\\/v(\\d+)\\/([^#]+)#?([^\\/]+)?$");

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    protected String getPublicIdForSigning() {
        return this.publicId + (this.format != null && !this.format.isEmpty() && this.resourceType.equals("raw") ? "." + this.format : "");
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getPreloadedFile() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.resourceType).append("/").append(this.type).append("/v").append(this.version).append("/").append(this.publicId);
        if (this.format != null && !this.format.isEmpty()) {
            sb.append(".").append(this.format);
        }
        if (this.signature != null && !this.signature.isEmpty()) {
            sb.append("#").append(this.signature);
        }
        return sb.toString();
    }

    public void setPreloadedFile(String uri) {
        if (uri.matches(PRELOADED_PATTERN.pattern())) {
            int lastDotIndex;
            Matcher match = PRELOADED_PATTERN.matcher(uri);
            match.find();
            this.resourceType = match.group(1);
            this.type = match.group(2);
            this.version = Long.parseLong(match.group(3));
            String filename = match.group(4);
            if (match.groupCount() == 5) {
                this.signature = match.group(5);
            }
            if ((lastDotIndex = filename.lastIndexOf(46)) == -1) {
                this.publicId = filename;
            } else {
                this.publicId = filename.substring(0, lastDotIndex);
                this.format = filename.substring(lastDotIndex + 1);
            }
        }
    }

    public String getComputedSignature(Cloudinary cloudinary) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("version", this.getVersion().toString());
        params.put("public_id", this.getPublicIdForSigning());
        cloudinary.signRequest(params, new HashMap<String, Object>());
        return params.get("signature").toString();
    }

    public boolean getIsImage() {
        return IMAGE_RESOURCE_TYPE.equals(this.resourceType) || AUTO_RESOURCE_TYPE.equals(this.resourceType);
    }
}

