/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary;

import com.cloudinary.utils.ObjectUtils;
import com.cloudinary.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Transformation {
    protected Map transformation;
    protected List<Map> transformations;
    protected String htmlWidth;
    protected String htmlHeight;
    protected boolean hiDPI = false;
    protected boolean isResponsive = false;
    protected static boolean defaultIsResponsive = false;
    protected static Object defaultDPR = null;
    private static final Map DEFAULT_RESPONSIVE_WIDTH_TRANSFORMATION = ObjectUtils.asMap("width", "auto", "crop", "limit");
    protected static Map responsiveWidthTransformation = null;

    public Transformation(Transformation transformation) {
        this(Transformation.dup(transformation.transformations));
        this.hiDPI = transformation.isHiDPI();
        this.isResponsive = transformation.isResponsive();
    }

    public Transformation(List<Map> transformations) {
        this.transformations = transformations;
        if (transformations.isEmpty()) {
            this.chain();
        } else {
            this.transformation = transformations.get(transformations.size() - 1);
        }
    }

    public Transformation() {
        this.transformations = new ArrayList<Map>();
        this.chain();
    }

    public Transformation width(Object value) {
        return this.param("width", value);
    }

    public Transformation height(Object value) {
        return this.param("height", value);
    }

    public Transformation named(String ... value) {
        return this.param("transformation", value);
    }

    public Transformation crop(String value) {
        return this.param("crop", value);
    }

    public Transformation background(String value) {
        return this.param("background", value);
    }

    public Transformation color(String value) {
        return this.param("color", value);
    }

    public Transformation effect(String value) {
        return this.param("effect", value);
    }

    public Transformation effect(String effect, Object param) {
        return this.param("effect", effect + ":" + param);
    }

    public Transformation angle(int value) {
        return this.param("angle", value);
    }

    public Transformation angle(String ... value) {
        return this.param("angle", value);
    }

    public Transformation border(String value) {
        return this.param("border", value);
    }

    public Transformation border(int width, String color) {
        return this.param("border", "" + width + "px_solid_" + color.replaceFirst("^#", "rgb:"));
    }

    public Transformation x(Object value) {
        return this.param("x", value);
    }

    public Transformation y(Object value) {
        return this.param("y", value);
    }

    public Transformation radius(Object value) {
        return this.param("radius", value);
    }

    public Transformation quality(Object value) {
        return this.param("quality", value);
    }

    public Transformation defaultImage(String value) {
        return this.param("default_image", value);
    }

    public Transformation gravity(String value) {
        return this.param("gravity", value);
    }

    public Transformation colorSpace(String value) {
        return this.param("color_space", value);
    }

    public Transformation prefix(String value) {
        return this.param("prefix", value);
    }

    public Transformation overlay(String value) {
        return this.param("overlay", value);
    }

    public Transformation underlay(String value) {
        return this.param("underlay", value);
    }

    public Transformation fetchFormat(String value) {
        return this.param("fetch_format", value);
    }

    public Transformation density(Object value) {
        return this.param("density", value);
    }

    public Transformation page(Object value) {
        return this.param("page", value);
    }

    public Transformation delay(Object value) {
        return this.param("delay", value);
    }

    public Transformation opacity(int value) {
        return this.param("opacity", value);
    }

    public Transformation rawTransformation(String value) {
        return this.param("raw_transformation", value);
    }

    public Transformation flags(String ... value) {
        return this.param("flags", value);
    }

    public Transformation dpr(float value) {
        return this.param("dpr", Float.valueOf(value));
    }

    public Transformation dpr(int value) {
        return this.param("dpr", value);
    }

    public Transformation dpr(String value) {
        return this.param("dpr", value);
    }

    public Transformation responsiveWidth(boolean value) {
        return this.param("responsive_width", value);
    }

    public boolean isResponsive() {
        return this.isResponsive;
    }

    public boolean isHiDPI() {
        return this.hiDPI;
    }

    public Transformation params(Map transformation) {
        this.transformation = transformation;
        this.transformations.add(transformation);
        return this;
    }

    public Transformation chain() {
        return this.params(new HashMap());
    }

    public Transformation param(String key, Object value) {
        this.transformation.put(key, value);
        return this;
    }

    public String generate() {
        return this.generate(this.transformations);
    }

    public String generate(Iterable<Map> optionsList) {
        ArrayList<String> components = new ArrayList<String>();
        for (Map options : optionsList) {
            components.add(this.generate(options));
        }
        return StringUtils.join(components, "/");
    }

    public String generate(Map options) {
        String color;
        String background;
        boolean noHtmlSizes;
        boolean isResponsive = ObjectUtils.asBoolean(options.get("responsive_width"), defaultIsResponsive);
        String size = (String)options.get("size");
        if (size != null) {
            String[] size_components = size.split("x");
            options.put("width", size_components[0]);
            options.put("height", size_components[1]);
        }
        String width = this.htmlWidth = ObjectUtils.asString(options.get("width"));
        String height = this.htmlHeight = ObjectUtils.asString(options.get("height"));
        boolean hasLayer = StringUtils.isNotBlank((String)options.get("overlay")) || StringUtils.isNotBlank((String)options.get("underlay"));
        String crop = (String)options.get("crop");
        String angle = StringUtils.join(ObjectUtils.asArray(options.get("angle")), ".");
        boolean bl = noHtmlSizes = hasLayer || StringUtils.isNotBlank(angle) || "fit".equals(crop) || "limit".equals(crop);
        if (width != null && (width.equals("auto") || Float.parseFloat(width) < 1.0f || noHtmlSizes || isResponsive)) {
            this.htmlWidth = null;
        }
        if (height != null && (Float.parseFloat(height) < 1.0f || noHtmlSizes || isResponsive)) {
            this.htmlHeight = null;
        }
        if ((background = (String)options.get("background")) != null) {
            background = background.replaceFirst("^#", "rgb:");
        }
        if ((color = (String)options.get("color")) != null) {
            color = color.replaceFirst("^#", "rgb:");
        }
        ArrayList<String> transformations = ObjectUtils.asArray(options.get("transformation"));
        boolean allNamed = true;
        for (Object e : transformations) {
            if (!(e instanceof Map)) continue;
            allNamed = false;
            break;
        }
        String namedTransformation = null;
        if (allNamed) {
            namedTransformation = StringUtils.join((List<String>)transformations, ".");
            transformations = new ArrayList();
        } else {
            ArrayList<String> arrayList = transformations;
            transformations = new ArrayList<String>();
            for (Object e : arrayList) {
                String transformationString;
                if (e instanceof Map) {
                    transformationString = this.generate((Map)e);
                } else {
                    HashMap map = new HashMap();
                    map.put("transformation", e);
                    transformationString = this.generate(map);
                }
                transformations.add(transformationString);
            }
        }
        String string = StringUtils.join(ObjectUtils.asArray(options.get("flags")), ".");
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("w", width);
        params.put("h", height);
        params.put("t", namedTransformation);
        params.put("c", crop);
        params.put("b", background);
        params.put("co", color);
        params.put("a", angle);
        params.put("fl", string);
        String string2 = ObjectUtils.asString(options.get("dpr"), null == defaultDPR ? null : defaultDPR.toString());
        params.put("dpr", string2);
        String[] simple_params = new String[]{"x", "x", "y", "y", "r", "radius", "d", "default_image", "g", "gravity", "cs", "color_space", "p", "prefix", "l", "overlay", "u", "underlay", "f", "fetch_format", "dn", "density", "pg", "page", "dl", "delay", "e", "effect", "bo", "border", "q", "quality", "o", "opacity"};
        for (int i = 0; i < simple_params.length; i += 2) {
            params.put(simple_params[i], ObjectUtils.asString(options.get(simple_params[i + 1])));
        }
        ArrayList<String> components = new ArrayList<String>();
        for (Map.Entry param : params.entrySet()) {
            if (!StringUtils.isNotBlank((String)param.getValue())) continue;
            components.add((String)param.getKey() + "_" + (String)param.getValue());
        }
        String raw_transformation = (String)options.get("raw_transformation");
        if (raw_transformation != null) {
            components.add(raw_transformation);
        }
        if (!components.isEmpty()) {
            transformations.add(StringUtils.join(components, ","));
        }
        if (isResponsive) {
            transformations.add(this.generate(Transformation.getResponsiveWidthTransformation()));
        }
        if ("auto".equals(width) || isResponsive) {
            this.isResponsive = true;
        }
        if ("auto".equals(string2)) {
            this.hiDPI = true;
        }
        return StringUtils.join(transformations, "/");
    }

    public String getHtmlWidth() {
        return this.htmlWidth;
    }

    public String getHtmlHeight() {
        return this.htmlHeight;
    }

    private static List<Map> dup(List<Map> transformations) {
        ArrayList<Map> result = new ArrayList<Map>();
        for (Map params : transformations) {
            result.add(new HashMap(params));
        }
        return result;
    }

    public static void setResponsiveWidthTransformation(Map transformation) {
        responsiveWidthTransformation = transformation;
    }

    private static Map getResponsiveWidthTransformation() {
        HashMap result = new HashMap();
        if (null == responsiveWidthTransformation) {
            result.putAll(DEFAULT_RESPONSIVE_WIDTH_TRANSFORMATION);
        } else {
            result.putAll(responsiveWidthTransformation);
        }
        return result;
    }

    public static void setDefaultIsResponsive(boolean isResponsive) {
        defaultIsResponsive = isResponsive;
    }

    public static void setDefaultDPR(Object dpr) {
        defaultDPR = dpr;
    }
}

