/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.utils;

import com.cloudinary.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.cloudinary.json.JSONArray;
import org.cloudinary.json.JSONException;
import org.cloudinary.json.JSONObject;

public class ObjectUtils {
    public static String asString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static String asString(Object value, String defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value.toString();
    }

    public static List asArray(Object value) {
        if (value == null) {
            return Collections.EMPTY_LIST;
        }
        if (value instanceof int[]) {
            ArrayList<Integer> array = new ArrayList<Integer>();
            for (int i : (int[])value) {
                array.add(new Integer(i));
            }
            return array;
        }
        if (value instanceof Object[]) {
            return Arrays.asList((Object[])value);
        }
        if (value instanceof List) {
            return (List)value;
        }
        ArrayList<Object> array = new ArrayList<Object>();
        array.add(value);
        return array;
    }

    public static Boolean asBoolean(Object value, Boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return "true".equals(value);
    }

    public static Float asFloat(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        return Float.valueOf(Float.parseFloat(value.toString()));
    }

    public static Map asMap(Object ... values) {
        if (values.length % 2 != 0) {
            throw new RuntimeException("Usage - (key, value, key, value, ...)");
        }
        HashMap<Object, Object> result = new HashMap<Object, Object>(values.length / 2);
        for (int i = 0; i < values.length; i += 2) {
            result.put(values[i], values[i + 1]);
        }
        return result;
    }

    public static Map emptyMap() {
        return Collections.EMPTY_MAP;
    }

    public static String encodeMap(Object arg) {
        if (arg != null && arg instanceof Map) {
            Map mapArg = (Map)arg;
            HashSet<String> out = new HashSet<String>();
            for (Map.Entry entry : mapArg.entrySet()) {
                out.add((String)entry.getKey() + "=" + (String)entry.getValue());
            }
            return StringUtils.join(out.toArray(), "|");
        }
        if (arg == null) {
            return null;
        }
        return arg.toString();
    }

    public static Map<String, ? extends Object> only(Map<String, ? extends Object> hash, String ... keys) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : keys) {
            if (!hash.containsKey(key)) continue;
            result.put(key, hash.get(key));
        }
        return result;
    }

    public static Map<String, Object> toMap(JSONObject object) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator<String> keys = object.keys();
        while (keys.hasNext()) {
            String key = keys.next();
            map.put(key, ObjectUtils.fromJson(object.get(key)));
        }
        return map;
    }

    private static Object fromJson(Object json) throws JSONException {
        if (json == JSONObject.NULL) {
            return null;
        }
        if (json instanceof JSONObject) {
            return ObjectUtils.toMap((JSONObject)json);
        }
        if (json instanceof JSONArray) {
            return ObjectUtils.toList((JSONArray)json);
        }
        return json;
    }

    public static List toList(JSONArray array) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            list.add(ObjectUtils.fromJson(array.get(i)));
        }
        return list;
    }

    public static Integer asInteger(Object value, Integer defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return Integer.parseInt(value.toString());
    }
}

