/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.transformation;

import com.cloudinary.Transformation;
import com.cloudinary.transformation.BaseExpression;

public class Condition
extends BaseExpression<Condition> {
    public Condition() {
    }

    public Condition(String conditionStr) {
        this();
        if (conditionStr != null) {
            this.expressions.add(Condition.normalize(conditionStr));
        }
    }

    @Override
    protected Condition newInstance() {
        return new Condition();
    }

    protected Condition predicate(String name, String operator, Object value) {
        if (OPERATORS.containsKey(operator)) {
            operator = (String)OPERATORS.get(operator);
        }
        this.expressions.add(String.format("%s_%s_%s", name, operator, value));
        return this;
    }

    public Transformation then() {
        this.getParent().ifCondition(this.serialize());
        return this.getParent();
    }

    public Condition width(String operator, Object value) {
        return this.predicate("w", operator, value);
    }

    public Condition height(String operator, Object value) {
        return this.predicate("h", operator, value);
    }

    public Condition aspectRatio(String operator, Object value) {
        return this.predicate("ar", operator, value);
    }

    @Deprecated
    public Condition faces(String operator, Object value) {
        return this.faceCount(operator, value);
    }

    public Condition faceCount(String operator, Object value) {
        return this.predicate("fc", operator, value);
    }

    @Deprecated
    public Condition pages(String operator, Object value) {
        return this.pageCount(operator, value);
    }

    public Condition pageCount(String operator, Object value) {
        return this.predicate("pc", operator, value);
    }
}

