/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary;

import com.cloudinary.transformation.AbstractLayerBuilder;
import com.cloudinary.utils.ObjectUtils;
import com.cloudinary.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Transformation {
    protected Map transformation;
    protected List<Map> transformations;
    protected String htmlWidth;
    protected String htmlHeight;
    protected boolean hiDPI = false;
    protected boolean isResponsive = false;
    protected static boolean defaultIsResponsive = false;
    protected static Object defaultDPR = null;
    private static final Map DEFAULT_RESPONSIVE_WIDTH_TRANSFORMATION = ObjectUtils.asMap("width", "auto", "crop", "limit");
    protected static Map responsiveWidthTransformation = null;
    private static final Pattern RANGE_VALUE_RE = Pattern.compile("^((?:\\d+\\.)?\\d+)([%pP])?$");
    private static final Pattern RANGE_RE = Pattern.compile("^(\\d+\\.)?\\d+[%pP]?\\.\\.(\\d+\\.)?\\d+[%pP]?$");

    public Transformation(Transformation transformation) {
        this(Transformation.dup(transformation.transformations));
        this.hiDPI = transformation.isHiDPI();
        this.isResponsive = transformation.isResponsive();
    }

    public Transformation(List<Map> transformations) {
        this.transformations = transformations;
        if (transformations.isEmpty()) {
            this.chain();
        } else {
            this.transformation = transformations.get(transformations.size() - 1);
        }
    }

    public Transformation() {
        this.transformations = new ArrayList<Map>();
        this.chain();
    }

    public Transformation width(Object value) {
        return this.param("width", value);
    }

    public Transformation height(Object value) {
        return this.param("height", value);
    }

    public Transformation named(String ... value) {
        return this.param("transformation", value);
    }

    public Transformation crop(String value) {
        return this.param("crop", value);
    }

    public Transformation background(String value) {
        return this.param("background", value);
    }

    public Transformation color(String value) {
        return this.param("color", value);
    }

    public Transformation effect(String value) {
        return this.param("effect", value);
    }

    public Transformation effect(String effect, Object param) {
        return this.param("effect", effect + ":" + param);
    }

    public Transformation angle(int value) {
        return this.param("angle", value);
    }

    public Transformation angle(String ... value) {
        return this.param("angle", value);
    }

    public Transformation border(String value) {
        return this.param("border", value);
    }

    public Transformation border(int width, String color) {
        return this.param("border", "" + width + "px_solid_" + color.replaceFirst("^#", "rgb:"));
    }

    public Transformation x(Object value) {
        return this.param("x", value);
    }

    public Transformation y(Object value) {
        return this.param("y", value);
    }

    public Transformation radius(Object value) {
        return this.param("radius", value);
    }

    public Transformation quality(Object value) {
        return this.param("quality", value);
    }

    public Transformation defaultImage(String value) {
        return this.param("default_image", value);
    }

    public Transformation gravity(String value) {
        return this.param("gravity", value);
    }

    public Transformation colorSpace(String value) {
        return this.param("color_space", value);
    }

    public Transformation prefix(String value) {
        return this.param("prefix", value);
    }

    public Transformation overlay(String value) {
        return this.param("overlay", value);
    }

    public Transformation overlay(AbstractLayerBuilder<?> value) {
        return this.param("overlay", value);
    }

    public Transformation underlay(Object value) {
        return this.param("underlay", value);
    }

    public Transformation underlay(AbstractLayerBuilder<?> value) {
        return this.param("underlay", value);
    }

    public Transformation fetchFormat(String value) {
        return this.param("fetch_format", value);
    }

    public Transformation density(Object value) {
        return this.param("density", value);
    }

    public Transformation page(Object value) {
        return this.param("page", value);
    }

    public Transformation delay(Object value) {
        return this.param("delay", value);
    }

    public Transformation opacity(int value) {
        return this.param("opacity", value);
    }

    public Transformation rawTransformation(String value) {
        return this.param("raw_transformation", value);
    }

    public Transformation flags(String ... value) {
        return this.param("flags", value);
    }

    public Transformation dpr(float value) {
        return this.param("dpr", Float.valueOf(value));
    }

    public Transformation dpr(int value) {
        return this.param("dpr", value);
    }

    public Transformation dpr(String value) {
        return this.param("dpr", value);
    }

    public Transformation duration(String value) {
        return this.param("duration", value);
    }

    public Transformation duration(float value) {
        return this.param("duration", new Float(value));
    }

    public Transformation duration(double value) {
        return this.param("duration", new Double(value));
    }

    public Transformation durationPercent(float value) {
        return this.param("duration", new Float(value).toString() + "p");
    }

    public Transformation durationPercent(double value) {
        return this.param("duration", new Double(value).toString() + "p");
    }

    public Transformation startOffset(String value) {
        return this.param("start_offset", value);
    }

    public Transformation startOffset(float value) {
        return this.param("start_offset", new Float(value));
    }

    public Transformation startOffset(double value) {
        return this.param("start_offset", new Double(value));
    }

    public Transformation startOffsetPercent(float value) {
        return this.param("start_offset", new Float(value).toString() + "p");
    }

    public Transformation startOffsetPercent(double value) {
        return this.param("start_offset", new Double(value).toString() + "p");
    }

    public Transformation endOffset(String value) {
        return this.param("end_offset", value);
    }

    public Transformation endOffset(float value) {
        return this.param("end_offset", new Float(value));
    }

    public Transformation endOffset(double value) {
        return this.param("end_offset", new Double(value));
    }

    public Transformation endOffsetPercent(float value) {
        return this.param("end_offset", new Float(value).toString() + "p");
    }

    public Transformation endOffsetPercent(double value) {
        return this.param("end_offset", new Double(value).toString() + "p");
    }

    public Transformation offset(String value) {
        return this.param("offset", value);
    }

    public Transformation offset(String[] value) {
        if (value.length < 2) {
            throw new IllegalArgumentException("Offset range must include at least 2 items");
        }
        return this.param("offset", value);
    }

    public Transformation offset(float[] value) {
        if (value.length < 2) {
            throw new IllegalArgumentException("Offset range must include at least 2 items");
        }
        Number[] numberArray = new Number[]{Float.valueOf(value[0]), Float.valueOf(value[1])};
        return this.offset(numberArray);
    }

    public Transformation offset(double[] value) {
        if (value.length < 2) {
            throw new IllegalArgumentException("Offset range must include at least 2 items");
        }
        Number[] numberArray = new Number[]{value[0], value[1]};
        return this.offset(numberArray);
    }

    public Transformation offset(Number[] value) {
        if (value.length < 2) {
            throw new IllegalArgumentException("Offset range must include at least 2 items");
        }
        return this.param("offset", value);
    }

    public Transformation videoCodec(String value) {
        return this.param("video_codec", value);
    }

    public Transformation videoCodec(Map<String, String> value) {
        return this.param("video_codec", value);
    }

    public Transformation audioCodec(String value) {
        return this.param("audio_codec", value);
    }

    public Transformation audioFrequency(String value) {
        return this.param("audio_frequency", value);
    }

    public Transformation audioFrequency(int value) {
        return this.param("audio_frequency", value);
    }

    public Transformation bitRate(String value) {
        return this.param("bit_rate", value);
    }

    public Transformation bitRate(int value) {
        return this.param("bit_rate", new Integer(value));
    }

    public Transformation videoSampling(String value) {
        return this.param("video_sampling", value);
    }

    public Transformation videoSamplingFrames(int value) {
        return this.param("video_sampling", value);
    }

    public Transformation videoSamplingSeconds(Number value) {
        return this.param("video_sampling", value.toString() + "s");
    }

    public Transformation videoSamplingSeconds(int value) {
        return this.videoSamplingSeconds(new Integer(value));
    }

    public Transformation videoSamplingSeconds(float value) {
        return this.videoSamplingSeconds(new Float(value));
    }

    public Transformation videoSamplingSeconds(double value) {
        return this.videoSamplingSeconds(new Double(value));
    }

    public Transformation zoom(String value) {
        return this.param("zoom", value);
    }

    public Transformation zoom(float value) {
        return this.param("zoom", new Float(value));
    }

    public Transformation zoom(double value) {
        return this.param("zoom", new Double(value));
    }

    public Transformation aspectRatio(double value) {
        return this.param("aspect_ratio", new Double(value));
    }

    public Transformation aspectRatio(String value) {
        return this.param("aspect_ratio", value);
    }

    public Transformation aspectRatio(int nom, int denom) {
        return this.aspectRatio(Integer.toString(nom) + ":" + Integer.toString(denom));
    }

    public Transformation responsiveWidth(boolean value) {
        return this.param("responsive_width", value);
    }

    public boolean isResponsive() {
        return this.isResponsive;
    }

    public boolean isHiDPI() {
        return this.hiDPI;
    }

    public Transformation params(Map transformation) {
        this.transformation = transformation;
        this.transformations.add(transformation);
        return this;
    }

    public Transformation chain() {
        return this.params(new HashMap());
    }

    public Transformation chainWith(Transformation transformation) {
        List<Map> transformations = Transformation.dup(this.transformations);
        transformations.addAll(Transformation.dup(transformation.transformations));
        return new Transformation(transformations);
    }

    public Transformation param(String key, Object value) {
        this.transformation.put(key, value);
        return this;
    }

    public String generate() {
        return this.generate(this.transformations);
    }

    public String generate(Iterable<Map> optionsList) {
        ArrayList<String> components = new ArrayList<String>();
        for (Map options : optionsList) {
            components.add(this.generate(options));
        }
        return StringUtils.join(components, "/");
    }

    /*
     * WARNING - void declaration
     */
    public String generate(Map options) {
        void var17_23;
        String color;
        String background;
        boolean noHtmlSizes;
        boolean isResponsive = ObjectUtils.asBoolean(options.get("responsive_width"), defaultIsResponsive);
        String size = (String)options.get("size");
        if (size != null) {
            String[] size_components = size.split("x");
            options.put("width", size_components[0]);
            options.put("height", size_components[1]);
        }
        String width = this.htmlWidth = ObjectUtils.asString(options.get("width"));
        String height = this.htmlHeight = ObjectUtils.asString(options.get("height"));
        boolean hasLayer = options.get("overlay") != null && StringUtils.isNotBlank(options.get("overlay").toString()) || options.get("underlay") != null && StringUtils.isNotBlank(options.get("underlay").toString());
        String crop = (String)options.get("crop");
        String angle = StringUtils.join(ObjectUtils.asArray(options.get("angle")), ".");
        boolean bl = noHtmlSizes = hasLayer || StringUtils.isNotBlank(angle) || "fit".equals(crop) || "limit".equals(crop);
        if (width != null && (width.equals("auto") || Float.parseFloat(width) < 1.0f || noHtmlSizes || isResponsive)) {
            this.htmlWidth = null;
        }
        if (height != null && (Float.parseFloat(height) < 1.0f || noHtmlSizes || isResponsive)) {
            this.htmlHeight = null;
        }
        if ((background = (String)options.get("background")) != null) {
            background = background.replaceFirst("^#", "rgb:");
        }
        if ((color = (String)options.get("color")) != null) {
            color = color.replaceFirst("^#", "rgb:");
        }
        ArrayList<String> transformations = ObjectUtils.asArray(options.get("transformation"));
        boolean allNamed = true;
        for (Object e : transformations) {
            if (!(e instanceof Map)) continue;
            allNamed = false;
            break;
        }
        String namedTransformation = null;
        if (allNamed) {
            namedTransformation = StringUtils.join((List<String>)transformations, ".");
            transformations = new ArrayList();
        } else {
            ArrayList<String> arrayList = transformations;
            transformations = new ArrayList<String>();
            for (Object e : arrayList) {
                String transformationString;
                if (e instanceof Map) {
                    transformationString = this.generate((Map)e);
                } else {
                    HashMap map = new HashMap();
                    map.put("transformation", e);
                    transformationString = this.generate(map);
                }
                transformations.add(transformationString);
            }
        }
        String string = StringUtils.join(ObjectUtils.asArray(options.get("flags")), ".");
        String duration = Transformation.normRangeValue(options.get("duration"));
        String string2 = Transformation.normRangeValue(options.get("start_offset"));
        String endOffset = Transformation.normRangeValue(options.get("end_offset"));
        String[] offset = Transformation.splitRange(options.get("offset"));
        if (offset != null) {
            String string3 = Transformation.normRangeValue(offset[0]);
            endOffset = Transformation.normRangeValue(offset[1]);
        }
        String videoCodec = Transformation.processVideoCodecParam(options.get("video_codec"));
        String dpr = ObjectUtils.asString(options.get("dpr"), null == defaultDPR ? null : defaultDPR.toString());
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        params.put("a", angle);
        params.put("b", background);
        params.put("c", crop);
        params.put("co", color);
        params.put("dpr", dpr);
        params.put("du", duration);
        params.put("eo", endOffset);
        params.put("fl", string);
        params.put("h", height);
        params.put("so", var17_23);
        params.put("t", namedTransformation);
        params.put("vc", videoCodec);
        params.put("w", width);
        String[] simple_params = new String[]{"ac", "audio_codec", "af", "audio_frequency", "ar", "aspect_ratio", "bo", "border", "br", "bit_rate", "cs", "color_space", "d", "default_image", "dl", "delay", "dn", "density", "e", "effect", "f", "fetch_format", "g", "gravity", "l", "overlay", "o", "opacity", "p", "prefix", "pg", "page", "q", "quality", "r", "radius", "u", "underlay", "vs", "video_sampling", "x", "x", "y", "y", "z", "zoom"};
        for (int i = 0; i < simple_params.length; i += 2) {
            params.put(simple_params[i], ObjectUtils.asString(options.get(simple_params[i + 1])));
        }
        ArrayList<String> components = new ArrayList<String>();
        for (Map.Entry param : params.entrySet()) {
            if (!StringUtils.isNotBlank((String)param.getValue())) continue;
            components.add((String)param.getKey() + "_" + (String)param.getValue());
        }
        String raw_transformation = (String)options.get("raw_transformation");
        if (raw_transformation != null) {
            components.add(raw_transformation);
        }
        if (!components.isEmpty()) {
            transformations.add(StringUtils.join(components, ","));
        }
        if (isResponsive) {
            transformations.add(this.generate(Transformation.getResponsiveWidthTransformation()));
        }
        if ("auto".equals(width) || isResponsive) {
            this.isResponsive = true;
        }
        if ("auto".equals(dpr)) {
            this.hiDPI = true;
        }
        return StringUtils.join(transformations, "/");
    }

    public String getHtmlWidth() {
        return this.htmlWidth;
    }

    public String getHtmlHeight() {
        return this.htmlHeight;
    }

    private static List<Map> dup(List<Map> transformations) {
        ArrayList<Map> result = new ArrayList<Map>();
        for (Map params : transformations) {
            result.add(new HashMap(params));
        }
        return result;
    }

    public static void setResponsiveWidthTransformation(Map transformation) {
        responsiveWidthTransformation = transformation;
    }

    private static Map getResponsiveWidthTransformation() {
        HashMap result = new HashMap();
        if (null == responsiveWidthTransformation) {
            result.putAll(DEFAULT_RESPONSIVE_WIDTH_TRANSFORMATION);
        } else {
            result.putAll(responsiveWidthTransformation);
        }
        return result;
    }

    public static void setDefaultIsResponsive(boolean isResponsive) {
        defaultIsResponsive = isResponsive;
    }

    public static void setDefaultDPR(Object dpr) {
        defaultDPR = dpr;
    }

    private static String[] splitRange(Object range) {
        if (range instanceof String[] && ((String[])range).length >= 2) {
            String[] stringArrayRange = (String[])range;
            return new String[]{stringArrayRange[0], stringArrayRange[1]};
        }
        if (range instanceof Number[] && ((Number[])range).length >= 2) {
            Number[] numberArrayRange = (Number[])range;
            return new String[]{numberArrayRange[0].toString(), numberArrayRange[1].toString()};
        }
        if (range instanceof String && RANGE_RE.matcher((String)range).matches()) {
            return ((String)range).split("\\.\\.", 2);
        }
        return null;
    }

    private static String normRangeValue(Object objectValue) {
        if (objectValue == null) {
            return null;
        }
        String value = objectValue.toString();
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        Matcher matcher = RANGE_VALUE_RE.matcher(value);
        if (!matcher.matches()) {
            return null;
        }
        String modifier = "";
        if (matcher.groupCount() == 2 && !StringUtils.isEmpty(matcher.group(2))) {
            modifier = "p";
        }
        return matcher.group(1) + modifier;
    }

    private static String processVideoCodecParam(Object param) {
        StringBuilder outParam = new StringBuilder();
        if (param instanceof String) {
            outParam.append(param);
        }
        if (param instanceof Map) {
            Map paramMap = (Map)param;
            outParam.append((String)paramMap.get("codec"));
            if (paramMap.containsKey("profile")) {
                outParam.append(":").append((String)paramMap.get("profile"));
                if (paramMap.containsKey("level")) {
                    outParam.append(":").append((String)paramMap.get("level"));
                }
            }
        }
        return outParam.toString();
    }
}

