/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary;

import com.cloudinary.CustomFunction;
import com.cloudinary.transformation.AbstractLayer;
import com.cloudinary.transformation.Condition;
import com.cloudinary.transformation.Expression;
import com.cloudinary.utils.ObjectUtils;
import com.cloudinary.utils.StringUtils;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Transformation<T extends Transformation>
implements Serializable {
    public static final String VAR_NAME_RE = "^\\$[a-zA-Z][a-zA-Z0-9]+$";
    protected Map transformation;
    protected List<Map> transformations;
    protected String htmlWidth;
    protected String htmlHeight;
    protected boolean hiDPI = false;
    protected boolean isResponsive = false;
    protected static boolean defaultIsResponsive = false;
    protected static Object defaultDPR = null;
    private static final Map<String, String> DEFAULT_RESPONSIVE_WIDTH_TRANSFORMATION = ObjectUtils.asMap("width", "auto", "crop", "limit");
    protected static Map responsiveWidthTransformation = null;
    private static final Pattern RANGE_VALUE_RE = Pattern.compile("^((?:\\d+\\.)?\\d+)([%pP])?$");
    private static final Pattern RANGE_RE = Pattern.compile("^(\\d+\\.)?\\d+[%pP]?\\.\\.(\\d+\\.)?\\d+[%pP]?$");
    private static final String[] SIMPLE_PARAMS = new String[]{"ac", "audio_codec", "af", "audio_frequency", "bo", "border", "br", "bit_rate", "cs", "color_space", "d", "default_image", "dl", "delay", "dn", "density", "f", "fetch_format", "fn", "custom_function", "fps", "fps", "g", "gravity", "l", "overlay", "p", "prefix", "pg", "page", "u", "underlay", "vs", "video_sampling", "sp", "streaming_profile", "ki", "keyframe_interval"};

    public Transformation(Transformation transformation) {
        this(Transformation.dup(transformation.transformations));
        this.hiDPI = transformation.isHiDPI();
        this.isResponsive = transformation.isResponsive();
    }

    public Transformation(List<Map> transformations) {
        this.transformations = transformations;
        if (transformations.isEmpty()) {
            this.chain();
        } else {
            this.transformation = transformations.get(transformations.size() - 1);
        }
    }

    public Transformation() {
        this.transformations = new ArrayList<Map>();
        this.chain();
    }

    public T width(Object value) {
        return this.param("width", value);
    }

    public T height(Object value) {
        return this.param("height", value);
    }

    public T named(String ... value) {
        return this.param("transformation", value);
    }

    public T crop(String value) {
        return this.param("crop", value);
    }

    public T background(String value) {
        return this.param("background", value);
    }

    public T color(String value) {
        return this.param("color", value);
    }

    public T effect(String value) {
        return this.param("effect", value);
    }

    public T effect(String effect, Object param) {
        return this.param("effect", effect + ":" + param);
    }

    public T angle(int value) {
        return this.param("angle", value);
    }

    public T angle(String ... value) {
        return this.param("angle", value);
    }

    public T border(String value) {
        return this.param("border", value);
    }

    public T border(int width, String color) {
        return this.param("border", "" + width + "px_solid_" + this.replaceColorPrefix(color));
    }

    public T x(Object value) {
        return this.param("x", value);
    }

    public T y(Object value) {
        return this.param("y", value);
    }

    public T radius(Object value) {
        return this.param("radius", value);
    }

    public T quality(Object value) {
        return this.param("quality", value);
    }

    public T defaultImage(String value) {
        return this.param("default_image", value);
    }

    public T gravity(String value) {
        return this.param("gravity", value);
    }

    public T keyframeInterval(float value) {
        return this.param("keyframe_interval", Float.valueOf(value));
    }

    public T keyframeInterval(String value) {
        return this.param("keyframe_interval", value);
    }

    public T colorSpace(String value) {
        return this.param("color_space", value);
    }

    public T prefix(String value) {
        return this.param("prefix", value);
    }

    public T overlay(String value) {
        return this.param("overlay", value);
    }

    public T overlay(AbstractLayer<?> value) {
        return this.param("overlay", value);
    }

    public T underlay(String value) {
        return this.param("underlay", value);
    }

    public T underlay(AbstractLayer<?> value) {
        return this.param("underlay", value);
    }

    public T fetchFormat(String value) {
        return this.param("fetch_format", value);
    }

    public T density(Object value) {
        return this.param("density", value);
    }

    public T page(Object value) {
        return this.param("page", value);
    }

    public T delay(Object value) {
        return this.param("delay", value);
    }

    public T opacity(int value) {
        return this.param("opacity", value);
    }

    public T rawTransformation(String value) {
        return this.param("raw_transformation", value);
    }

    public T flags(String ... value) {
        return this.param("flags", value);
    }

    public T dpr(float value) {
        return this.param("dpr", Float.valueOf(value));
    }

    public T dpr(int value) {
        return this.param("dpr", value);
    }

    public T dpr(String value) {
        return this.param("dpr", value);
    }

    public T duration(String value) {
        return this.param("duration", value);
    }

    public T duration(float value) {
        return this.param("duration", new Float(value));
    }

    public T duration(double value) {
        return this.param("duration", new Double(value));
    }

    public T durationPercent(float value) {
        return this.param("duration", new Float(value).toString() + "p");
    }

    public T durationPercent(double value) {
        return this.param("duration", new Double(value).toString() + "p");
    }

    public T startOffset(String value) {
        return this.param("start_offset", value);
    }

    public T startOffset(float value) {
        return this.param("start_offset", new Float(value));
    }

    public T startOffset(double value) {
        return this.param("start_offset", new Double(value));
    }

    public T startOffsetPercent(float value) {
        return this.param("start_offset", new Float(value).toString() + "p");
    }

    public T startOffsetPercent(double value) {
        return this.param("start_offset", new Double(value).toString() + "p");
    }

    public T endOffset(String value) {
        return this.param("end_offset", value);
    }

    public T endOffset(float value) {
        return this.param("end_offset", new Float(value));
    }

    public T endOffset(double value) {
        return this.param("end_offset", new Double(value));
    }

    public T endOffsetPercent(float value) {
        return this.param("end_offset", new Float(value).toString() + "p");
    }

    public T endOffsetPercent(double value) {
        return this.param("end_offset", new Double(value).toString() + "p");
    }

    public T offset(String value) {
        return this.param("offset", value);
    }

    public T offset(String[] value) {
        if (value.length < 2) {
            throw new IllegalArgumentException("Offset range must include at least 2 items");
        }
        return this.param("offset", value);
    }

    public T offset(float[] value) {
        if (value.length < 2) {
            throw new IllegalArgumentException("Offset range must include at least 2 items");
        }
        Number[] numberArray = new Number[]{Float.valueOf(value[0]), Float.valueOf(value[1])};
        return this.offset(numberArray);
    }

    public T offset(double[] value) {
        if (value.length < 2) {
            throw new IllegalArgumentException("Offset range must include at least 2 items");
        }
        Number[] numberArray = new Number[]{value[0], value[1]};
        return this.offset(numberArray);
    }

    public T offset(Number[] value) {
        if (value.length < 2) {
            throw new IllegalArgumentException("Offset range must include at least 2 items");
        }
        return this.param("offset", value);
    }

    public T videoCodec(String value) {
        return this.param("video_codec", value);
    }

    public T videoCodec(Map<String, String> value) {
        return this.param("video_codec", value);
    }

    public T audioCodec(String value) {
        return this.param("audio_codec", value);
    }

    public T audioFrequency(String value) {
        return this.param("audio_frequency", value);
    }

    public T audioFrequency(int value) {
        return this.param("audio_frequency", value);
    }

    public T bitRate(String value) {
        return this.param("bit_rate", value);
    }

    public T bitRate(int value) {
        return this.param("bit_rate", new Integer(value));
    }

    public T videoSampling(String value) {
        return this.param("video_sampling", value);
    }

    public T videoSamplingFrames(int value) {
        return this.param("video_sampling", value);
    }

    public T videoSamplingSeconds(Number value) {
        return this.param("video_sampling", value.toString() + "s");
    }

    public T videoSamplingSeconds(int value) {
        return this.videoSamplingSeconds(new Integer(value));
    }

    public T videoSamplingSeconds(float value) {
        return this.videoSamplingSeconds(new Float(value));
    }

    public T videoSamplingSeconds(double value) {
        return this.videoSamplingSeconds(new Double(value));
    }

    public T zoom(String value) {
        return this.param("zoom", value);
    }

    public T zoom(float value) {
        return this.param("zoom", new Float(value));
    }

    public T zoom(double value) {
        return this.param("zoom", new Double(value));
    }

    public T aspectRatio(double value) {
        return this.param("aspect_ratio", new Double(value));
    }

    public T aspectRatio(String value) {
        return this.param("aspect_ratio", value);
    }

    public T aspectRatio(int nom, int denom) {
        return this.aspectRatio(Integer.toString(nom) + ":" + Integer.toString(denom));
    }

    public T responsiveWidth(boolean value) {
        return this.param("responsive_width", value);
    }

    public Condition ifCondition() {
        return (Condition)new Condition().setParent(this);
    }

    public T ifCondition(String condition) {
        return this.param("if", condition);
    }

    public T ifCondition(Expression expression) {
        return this.ifCondition(expression.toString());
    }

    public T ifCondition(Condition condition) {
        return this.ifCondition(condition.toString());
    }

    public T ifElse() {
        this.chain();
        return this.param("if", "else");
    }

    public T endIf() {
        this.chain();
        int transSize = this.transformations.size();
        for (int i = transSize - 1; i >= 0; --i) {
            Map segment = this.transformations.get(i);
            Object value = segment.get("if");
            if (value == null) continue;
            String ifValue = value.toString();
            if (ifValue.equals("end")) break;
            if (segment.size() > 1) {
                segment.remove("if");
                this.transformations.set(i, segment);
                this.transformations.add(i, ObjectUtils.asMap("if", value));
            }
            if (!"else".equals(ifValue)) break;
        }
        this.param("if", "end");
        return this.chain();
    }

    public T fps(String value) {
        return this.param("fps", value);
    }

    public T fps(double value) {
        return this.param("fps", new Float(value));
    }

    public T fps(int value) {
        return this.param("fps", new Integer(value));
    }

    public T fps(Object rangeStart, Object rangeEnd) {
        if (rangeEnd == null && rangeStart == null) {
            throw new IllegalArgumentException("At least one of [rangeStart, rangeEnd] must be provided");
        }
        StringBuilder builder = new StringBuilder();
        if (rangeStart != null) {
            builder.append(rangeStart);
        }
        builder.append("-");
        if (rangeEnd != null) {
            builder.append(rangeEnd);
        }
        return this.param("fps", builder.toString());
    }

    public T streamingProfile(String value) {
        return this.param("streaming_profile", value);
    }

    public boolean isResponsive() {
        return this.isResponsive;
    }

    public boolean isHiDPI() {
        return this.hiDPI;
    }

    public T params(Map transformation) {
        this.transformation = transformation;
        this.transformations.add(transformation);
        return (T)this;
    }

    public T chain() {
        return this.params(new HashMap());
    }

    public T chainWith(Transformation transformation) {
        List<Map> transformations = Transformation.dup(this.transformations);
        transformations.addAll(Transformation.dup(transformation.transformations));
        return (T)new Transformation<T>(transformations);
    }

    public T param(String key, Object value) {
        this.transformation.put(key, value);
        return (T)this;
    }

    public String generate() {
        return this.generate(this.transformations);
    }

    public String toString() {
        return this.generate();
    }

    public String generate(Iterable<Map> optionsList) {
        ArrayList<String> components = new ArrayList<String>();
        for (Map options : optionsList) {
            if (options.size() <= 0) continue;
            components.add(this.generate(options));
        }
        return StringUtils.join(components, "/");
    }

    /*
     * WARNING - void declaration
     */
    public String generate(Map options) {
        void var17_23;
        String variables;
        String color;
        String background;
        boolean noHtmlSizes;
        boolean isResponsive = ObjectUtils.asBoolean(options.get("responsive_width"), defaultIsResponsive);
        String size = (String)options.get("size");
        if (size != null) {
            String[] size_components = size.split("x");
            options.put("width", size_components[0]);
            options.put("height", size_components[1]);
        }
        String width = this.htmlWidth = ObjectUtils.asString(options.get("width"));
        String height = this.htmlHeight = ObjectUtils.asString(options.get("height"));
        boolean hasLayer = options.get("overlay") != null && StringUtils.isNotBlank(options.get("overlay").toString()) || options.get("underlay") != null && StringUtils.isNotBlank(options.get("underlay").toString());
        String crop = (String)options.get("crop");
        String angle = StringUtils.join(ObjectUtils.asArray(options.get("angle")), ".");
        boolean bl = noHtmlSizes = hasLayer || StringUtils.isNotBlank(angle) || "fit".equals(crop) || "limit".equals(crop);
        if (width != null && (width.startsWith("auto") || !this.isValidAttrValue(width) || noHtmlSizes || isResponsive)) {
            this.htmlWidth = null;
        }
        if (height != null && (!this.isValidAttrValue(height) || noHtmlSizes || isResponsive)) {
            this.htmlHeight = null;
        }
        if ((background = (String)options.get("background")) != null) {
            background = this.replaceColorPrefix(background);
        }
        if ((color = (String)options.get("color")) != null) {
            color = this.replaceColorPrefix(color);
        }
        ArrayList<String> transformations = ObjectUtils.asArray(options.get("transformation"));
        boolean allNamed = true;
        for (Object e : transformations) {
            if (!(e instanceof Map)) continue;
            allNamed = false;
            break;
        }
        String namedTransformation = null;
        if (allNamed) {
            namedTransformation = StringUtils.join((List<String>)transformations, ".");
            transformations = new ArrayList();
        } else {
            ArrayList<String> arrayList = transformations;
            transformations = new ArrayList<String>();
            for (Object e : arrayList) {
                String transformationString;
                if (e instanceof Map) {
                    transformationString = this.generate((Map)e);
                } else {
                    HashMap map = new HashMap();
                    map.put("transformation", e);
                    transformationString = this.generate(map);
                }
                transformations.add(transformationString);
            }
        }
        String string = StringUtils.join(ObjectUtils.asArray(options.get("flags")), ".");
        String duration = Transformation.normRangeValue(options.get("duration"));
        String string2 = Transformation.normAutoRangeValue(options.get("start_offset"));
        String endOffset = Transformation.normRangeValue(options.get("end_offset"));
        String[] offset = Transformation.splitRange(options.get("offset"));
        if (offset != null) {
            String string3 = Transformation.normAutoRangeValue(offset[0]);
            endOffset = Transformation.normRangeValue(offset[1]);
        }
        String videoCodec = Transformation.processVideoCodecParam(options.get("video_codec"));
        String dpr = ObjectUtils.asString(options.get("dpr"), null == defaultDPR ? null : defaultDPR.toString());
        ArrayList<String> components = new ArrayList<String>();
        String ifValue = (String)options.get("if");
        if (ifValue != null) {
            components.add(0, "if_" + Expression.normalize(ifValue));
        }
        TreeSet<String> varParams = new TreeSet<String>();
        for (Object k : options.keySet()) {
            String key = (String)k;
            if (!StringUtils.isVariable(key)) continue;
            varParams.add(key + "_" + ObjectUtils.asString(options.get(k)));
        }
        if (!varParams.isEmpty()) {
            components.add(StringUtils.join(varParams, ","));
        }
        if ((variables = this.processVar((Expression[])options.get("variables"))) != null) {
            components.add(variables);
        }
        AbstractMap params = new HashMap<String, Object>(64);
        params.put("a", Expression.normalize(angle));
        params.put("ar", Expression.normalize(options.get("aspect_ratio")));
        params.put("b", background);
        params.put("c", crop);
        params.put("co", color);
        params.put("dpr", Expression.normalize(dpr));
        params.put("du", duration);
        params.put("e", Expression.normalize(options.get("effect")));
        params.put("eo", endOffset);
        params.put("fl", string);
        params.put("h", Expression.normalize(height));
        params.put("o", Expression.normalize(options.get("opacity")));
        params.put("q", Expression.normalize(options.get("quality")));
        params.put("r", Expression.normalize(options.get("radius")));
        params.put("so", var17_23);
        params.put("t", namedTransformation);
        params.put("vc", videoCodec);
        params.put("w", Expression.normalize(width));
        params.put("x", Expression.normalize(options.get("x")));
        params.put("y", Expression.normalize(options.get("y")));
        params.put("z", Expression.normalize(options.get("zoom")));
        for (int i = 0; i < SIMPLE_PARAMS.length; i += 2) {
            params.put(SIMPLE_PARAMS[i], ObjectUtils.asString(options.get(SIMPLE_PARAMS[i + 1])));
        }
        params = new TreeMap(params);
        for (Map.Entry param : params.entrySet()) {
            if (!StringUtils.isNotBlank((String)param.getValue())) continue;
            components.add((String)param.getKey() + "_" + (String)param.getValue());
        }
        String raw_transformation = (String)options.get("raw_transformation");
        if (raw_transformation != null) {
            components.add(raw_transformation);
        }
        if (!components.isEmpty()) {
            String joined = StringUtils.join(components, ",");
            transformations.add(Expression.normalize(joined));
        }
        if (isResponsive) {
            transformations.add(this.generate(Transformation.getResponsiveWidthTransformation()));
        }
        if ("auto".equals(width) || isResponsive) {
            this.isResponsive = true;
        }
        if ("auto".equals(dpr)) {
            this.hiDPI = true;
        }
        return StringUtils.join(transformations, "/");
    }

    private String replaceColorPrefix(String color) {
        return StringUtils.replaceIfFirstChar(color, '#', "rgb:");
    }

    private String processVar(Expression[] variables) {
        if (variables == null) {
            return null;
        }
        ArrayList<String> s = new ArrayList<String>(variables.length);
        for (Expression variable : variables) {
            s.add(variable.toString());
        }
        return StringUtils.join(s, ",");
    }

    private boolean isValidAttrValue(String value) {
        float parseFloat;
        try {
            parseFloat = Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return parseFloat >= 1.0f;
    }

    public String getHtmlWidth() {
        return this.htmlWidth;
    }

    public String getHtmlHeight() {
        return this.htmlHeight;
    }

    private static List<Map> dup(List<Map> transformations) {
        ArrayList<Map> result = new ArrayList<Map>();
        for (Map params : transformations) {
            result.add(new HashMap(params));
        }
        return result;
    }

    public static void setResponsiveWidthTransformation(Map transformation) {
        responsiveWidthTransformation = transformation;
    }

    private static Map getResponsiveWidthTransformation() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (null == responsiveWidthTransformation) {
            result.putAll(DEFAULT_RESPONSIVE_WIDTH_TRANSFORMATION);
        } else {
            result.putAll(responsiveWidthTransformation);
        }
        return result;
    }

    public static void setDefaultIsResponsive(boolean isResponsive) {
        defaultIsResponsive = isResponsive;
    }

    public static void setDefaultDPR(Object dpr) {
        defaultDPR = dpr;
    }

    private static String[] splitRange(Object range) {
        if (range instanceof String[] && ((String[])range).length >= 2) {
            String[] stringArrayRange = (String[])range;
            return new String[]{stringArrayRange[0], stringArrayRange[1]};
        }
        if (range instanceof Number[] && ((Number[])range).length >= 2) {
            Number[] numberArrayRange = (Number[])range;
            return new String[]{numberArrayRange[0].toString(), numberArrayRange[1].toString()};
        }
        if (range instanceof String && RANGE_RE.matcher((String)range).matches()) {
            return ((String)range).split("\\.\\.", 2);
        }
        return null;
    }

    private static String normRangeValue(Object objectValue) {
        if (objectValue == null) {
            return null;
        }
        String value = objectValue.toString();
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        Matcher matcher = RANGE_VALUE_RE.matcher(value);
        if (!matcher.matches()) {
            return null;
        }
        String modifier = "";
        if (matcher.groupCount() == 2 && !StringUtils.isEmpty(matcher.group(2))) {
            modifier = "p";
        }
        return matcher.group(1) + modifier;
    }

    private static String normAutoRangeValue(Object objectValue) {
        if ("auto".equals(objectValue)) {
            return objectValue.toString();
        }
        return Transformation.normRangeValue(objectValue);
    }

    private static String processVideoCodecParam(Object param) {
        StringBuilder outParam = new StringBuilder();
        if (param instanceof String) {
            outParam.append(param);
        }
        if (param instanceof Map) {
            Map paramMap = (Map)param;
            outParam.append((String)paramMap.get("codec"));
            if (paramMap.containsKey("profile")) {
                outParam.append(":").append((String)paramMap.get("profile"));
                if (paramMap.containsKey("level")) {
                    outParam.append(":").append((String)paramMap.get("level"));
                }
            }
        }
        return outParam.toString();
    }

    public T variable(String name, Object value) {
        return this.param(name, value);
    }

    public T variables(Expression ... variables) {
        return this.param("variables", variables);
    }

    public T customFunction(CustomFunction action) {
        return this.param("custom_function", action.toString());
    }

    public T customPreFunction(CustomFunction action) {
        return this.param("custom_function", "pre:" + action.toString());
    }
}

