/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary;

import com.cloudinary.AccessControlRule;
import com.cloudinary.Coordinates;
import com.cloudinary.Transformation;
import com.cloudinary.utils.ObjectUtils;
import com.cloudinary.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.cloudinary.json.JSONObject;

public class Util {
    static final String[] BOOLEAN_UPLOAD_OPTIONS = new String[]{"backup", "exif", "faces", "colors", "image_metadata", "use_filename", "unique_filename", "eager_async", "invalidate", "discard_original_filename", "overwrite", "phash", "return_delete_token", "async", "quality_analysis", "cinemagraph_analysis"};

    public static final Map<String, Object> buildUploadParams(Map options) {
        if (options == null) {
            options = ObjectUtils.emptyMap();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("public_id", (String)options.get("public_id"));
        params.put("callback", (String)options.get("callback"));
        params.put("format", (String)options.get("format"));
        params.put("type", (String)options.get("type"));
        for (String attr : BOOLEAN_UPLOAD_OPTIONS) {
            Util.putBoolean(attr, options, params);
        }
        params.put("notification_url", (String)options.get("notification_url"));
        params.put("eager_notification_url", (String)options.get("eager_notification_url"));
        params.put("proxy", (String)options.get("proxy"));
        params.put("folder", (String)options.get("folder"));
        params.put("allowed_formats", StringUtils.join(ObjectUtils.asArray(options.get("allowed_formats")), ","));
        params.put("moderation", options.get("moderation"));
        params.put("access_mode", (String)options.get("access_mode"));
        Object responsive_breakpoints = options.get("responsive_breakpoints");
        if (responsive_breakpoints != null) {
            params.put("responsive_breakpoints", JSONObject.wrap(responsive_breakpoints));
        }
        params.put("upload_preset", options.get("upload_preset"));
        if (options.get("signature") == null) {
            Util.putEager("eager", options, params);
            Object transformation = options.get("transformation");
            if (transformation != null) {
                if (transformation instanceof Transformation) {
                    transformation = ((Transformation)transformation).generate();
                }
                params.put("transformation", transformation.toString());
            }
            Util.processWriteParameters(options, params);
        } else {
            params.put("eager", (String)options.get("eager"));
            params.put("transformation", (String)options.get("transformation"));
            params.put("headers", (String)options.get("headers"));
            params.put("tags", (String)options.get("tags"));
            params.put("face_coordinates", (String)options.get("face_coordinates"));
            params.put("context", (String)options.get("context"));
            params.put("ocr", (String)options.get("ocr"));
            params.put("raw_convert", (String)options.get("raw_convert"));
            params.put("categorization", (String)options.get("categorization"));
            params.put("detection", (String)options.get("detection"));
            params.put("similarity_search", (String)options.get("similarity_search"));
            params.put("auto_tagging", (String)options.get("auto_tagging"));
            params.put("access_control", (String)options.get("access_control"));
        }
        return params;
    }

    protected static final String buildEager(List<? extends Transformation> transformations) {
        if (transformations == null) {
            return null;
        }
        ArrayList<String> eager = new ArrayList<String>();
        for (Transformation transformation : transformations) {
            String transformationString = transformation.generate();
            if (!StringUtils.isNotBlank(transformationString)) continue;
            eager.add(transformationString);
        }
        return StringUtils.join(eager, "|");
    }

    public static final void processWriteParameters(Map<String, Object> options, Map<String, Object> params) {
        if (options.get("headers") != null) {
            params.put("headers", Util.buildCustomHeaders(options.get("headers")));
        }
        if (options.get("tags") != null) {
            params.put("tags", StringUtils.join(ObjectUtils.asArray(options.get("tags")), ","));
        }
        if (options.get("face_coordinates") != null) {
            params.put("face_coordinates", Coordinates.parseCoordinates(options.get("face_coordinates")).toString());
        }
        if (options.get("custom_coordinates") != null) {
            params.put("custom_coordinates", Coordinates.parseCoordinates(options.get("custom_coordinates")).toString());
        }
        if (options.get("context") != null) {
            params.put("context", Util.encodeContext(options.get("context")));
        }
        if (options.get("metadata") != null) {
            params.put("metadata", Util.encodeContext(options.get("metadata")));
        }
        if (options.get("access_control") != null) {
            params.put("access_control", Util.encodeAccessControl(options.get("access_control")));
        }
        Util.putObject("ocr", options, params);
        Util.putObject("raw_convert", options, params);
        Util.putObject("categorization", options, params);
        Util.putObject("detection", options, params);
        Util.putObject("similarity_search", options, params);
        Util.putObject("background_removal", options, params);
        if (options.get("auto_tagging") != null) {
            params.put("auto_tagging", ObjectUtils.asFloat(options.get("auto_tagging")));
        }
    }

    protected static String encodeAccessControl(Object accessControl) {
        if (accessControl instanceof AccessControlRule) {
            accessControl = Arrays.asList(accessControl);
        }
        return JSONObject.wrap(accessControl).toString();
    }

    protected static String encodeContext(Object context) {
        if (context instanceof Map) {
            Map mapArg = (Map)context;
            HashSet<String> out = new HashSet<String>();
            for (Map.Entry entry : mapArg.entrySet()) {
                String value = entry.getValue() instanceof List ? Util.encodeList(((List)entry.getValue()).toArray()) : (entry.getValue() instanceof String[] ? Util.encodeList((String[])entry.getValue()) : entry.getValue().toString());
                out.add((String)entry.getKey() + "=" + Util.encodeSingleContextString(value));
            }
            return StringUtils.join(out.toArray(), "|");
        }
        if (context == null) {
            return null;
        }
        return context.toString();
    }

    private static String encodeList(Object[] list) {
        StringBuilder builder = new StringBuilder("[");
        boolean first = true;
        for (Object s : list) {
            if (!first) {
                builder.append(",");
            }
            builder.append("\"").append(Util.encodeSingleContextString(s.toString())).append("\"");
            first = false;
        }
        return builder.append("]").toString();
    }

    private static String encodeSingleContextString(String value) {
        return value.replaceAll("([=\\|])", "\\\\$1");
    }

    protected static final String buildCustomHeaders(Object headers) {
        if (headers == null) {
            return null;
        }
        if (headers instanceof String) {
            return (String)headers;
        }
        if (headers instanceof Object[]) {
            return StringUtils.join((Object[])headers, "\n") + "\n";
        }
        Map headersMap = (Map)headers;
        StringBuilder builder = new StringBuilder();
        for (Map.Entry header : headersMap.entrySet()) {
            builder.append((String)header.getKey()).append(": ").append((String)header.getValue()).append("\n");
        }
        return builder.toString();
    }

    public static void clearEmpty(Map params) {
        Iterator iterator = params.values().iterator();
        while (iterator.hasNext()) {
            Object value = iterator.next();
            if (value != null && !"".equals(value)) continue;
            iterator.remove();
        }
    }

    public static final Map<String, Object> buildArchiveParams(Map options, String targetFormat) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (options != null && options.size() > 0) {
            params.put("type", options.get("type"));
            params.put("mode", options.get("mode"));
            params.put("target_format", targetFormat);
            params.put("target_public_id", options.get("target_public_id"));
            Util.putBoolean("flatten_folders", options, params);
            Util.putBoolean("flatten_transformations", options, params);
            Util.putBoolean("use_original_filename", options, params);
            Util.putBoolean("async", options, params);
            Util.putBoolean("keep_derived", options, params);
            params.put("notification_url", options.get("notification_url"));
            Util.putArray("target_tags", options, params);
            Util.putArray("tags", options, params);
            Util.putArray("public_ids", options, params);
            Util.putArray("fully_qualified_public_ids", options, params);
            Util.putArray("prefixes", options, params);
            Util.putEager("transformations", options, params);
            Util.putObject("timestamp", options, params, Util.timestamp());
            Util.putBoolean("skip_transformation_name", options, params);
            Util.putBoolean("allow_missing", options, params);
            Util.putObject("expires_at", options, params);
        }
        return params;
    }

    private static void putEager(String name, Map from, Map<String, Object> to) {
        Object transformations = from.get(name);
        if (transformations != null) {
            to.put(name, Util.buildEager((List)transformations));
        }
    }

    private static void putBoolean(String name, Map from, Map<String, Object> to) {
        Object value = from.get(name);
        if (value != null) {
            to.put(name, ObjectUtils.asBoolean(value));
        }
    }

    private static void putObject(String name, Map from, Map<String, Object> to) {
        Util.putObject(name, from, to, null);
    }

    private static void putObject(String name, Map from, Map<String, Object> to, Object defaultValue) {
        Object value = from.get(name);
        if (value != null) {
            to.put(name, value);
        } else if (defaultValue != null) {
            to.put(name, defaultValue);
        }
    }

    private static void putArray(String name, Map from, Map<String, Object> to) {
        Object value = from.get(name);
        if (value != null) {
            to.put(name, ObjectUtils.asArray(value));
        }
    }

    protected static String timestamp() {
        return Long.toString(System.currentTimeMillis() / 1000L);
    }
}

