/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary;

import com.cloudinary.Api;
import com.cloudinary.ArchiveParams;
import com.cloudinary.Configuration;
import com.cloudinary.Search;
import com.cloudinary.Transformation;
import com.cloudinary.Uploader;
import com.cloudinary.Url;
import com.cloudinary.Util;
import com.cloudinary.api.signing.ApiResponseSignatureVerifier;
import com.cloudinary.api.signing.NotificationRequestSignatureVerifier;
import com.cloudinary.strategies.AbstractApiStrategy;
import com.cloudinary.strategies.AbstractUploaderStrategy;
import com.cloudinary.strategies.StrategyLoader;
import com.cloudinary.utils.ObjectUtils;
import com.cloudinary.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Cloudinary {
    private static List<String> UPLOAD_STRATEGIES = new ArrayList<String>(Arrays.asList("com.cloudinary.android.UploaderStrategy", "com.cloudinary.http42.UploaderStrategy", "com.cloudinary.http43.UploaderStrategy", "com.cloudinary.http44.UploaderStrategy"));
    public static List<String> API_STRATEGIES = new ArrayList<String>(Arrays.asList("com.cloudinary.android.ApiStrategy", "com.cloudinary.http42.ApiStrategy", "com.cloudinary.http43.ApiStrategy", "com.cloudinary.http44.ApiStrategy"));
    public static final String CF_SHARED_CDN = "d3jpl91pxevbkh.cloudfront.net";
    public static final String OLD_AKAMAI_SHARED_CDN = "cloudinary-a.akamaihd.net";
    public static final String AKAMAI_SHARED_CDN = "res.cloudinary.com";
    public static final String SHARED_CDN = "res.cloudinary.com";
    public static final String VERSION = "1.26.0";
    public static final String USER_AGENT = "CloudinaryJava/1.26.0 (Java " + System.getProperty("java.version") + ")";
    public final Configuration config;
    private AbstractUploaderStrategy uploaderStrategy;
    private AbstractApiStrategy apiStrategy;
    private static final SecureRandom RND = new SecureRandom();

    public Uploader uploader() {
        return new Uploader(this, this.uploaderStrategy);
    }

    public Api api() {
        return new Api(this, this.apiStrategy);
    }

    public Search search() {
        return new Search(this);
    }

    public static void registerUploaderStrategy(String className) {
        if (!UPLOAD_STRATEGIES.contains(className)) {
            UPLOAD_STRATEGIES.add(className);
        }
    }

    public static void registerAPIStrategy(String className) {
        if (!API_STRATEGIES.contains(className)) {
            API_STRATEGIES.add(className);
        }
    }

    private void loadStrategies() {
        if (!this.config.loadStrategies) {
            return;
        }
        this.uploaderStrategy = (AbstractUploaderStrategy)StrategyLoader.find(UPLOAD_STRATEGIES);
        if (this.uploaderStrategy == null) {
            throw new UnknownError("Can't find Cloudinary platform adapter [" + StringUtils.join(UPLOAD_STRATEGIES, ",") + "]");
        }
        this.apiStrategy = (AbstractApiStrategy)StrategyLoader.find(API_STRATEGIES);
        if (this.apiStrategy == null) {
            throw new UnknownError("Can't find Cloudinary platform adapter [" + StringUtils.join(API_STRATEGIES, ",") + "]");
        }
    }

    public Cloudinary(Map config) {
        this.config = new Configuration(config);
        this.loadStrategies();
    }

    public Cloudinary(String cloudinaryUrl) {
        this.config = Configuration.from(cloudinaryUrl);
        this.loadStrategies();
    }

    public Cloudinary() {
        String cloudinaryUrl = System.getProperty("CLOUDINARY_URL", System.getenv("CLOUDINARY_URL"));
        this.config = cloudinaryUrl != null ? Configuration.from(cloudinaryUrl) : new Configuration();
        this.loadStrategies();
    }

    public Url url() {
        return new Url(this);
    }

    public String cloudinaryApiUrl(String action, Map options) {
        String cloudinary = ObjectUtils.asString(options.get("upload_prefix"), ObjectUtils.asString(this.config.uploadPrefix, "https://api.cloudinary.com"));
        String cloud_name = ObjectUtils.asString(options.get("cloud_name"), ObjectUtils.asString(this.config.cloudName));
        if (cloud_name == null) {
            throw new IllegalArgumentException("Must supply cloud_name in tag or in configuration");
        }
        String resource_type = ObjectUtils.asString(options.get("resource_type"), "image");
        return StringUtils.join(new String[]{cloudinary, "v1_1", cloud_name, resource_type, action}, "/");
    }

    public String randomPublicId() {
        byte[] bytes = new byte[8];
        RND.nextBytes(bytes);
        return StringUtils.encodeHexString(bytes);
    }

    public String signedPreloadedImage(Map result) {
        return result.get("resource_type") + "/upload/v" + result.get("version") + "/" + result.get("public_id") + (result.containsKey("format") ? "." + result.get("format") : "") + "#" + result.get("signature");
    }

    public String apiSignRequest(Map<String, Object> paramsToSign, String apiSecret) {
        return Util.produceSignature(paramsToSign, apiSecret);
    }

    public boolean verifyNotificationSignature(String body, String timestamp, String signature, long validFor) {
        return new NotificationRequestSignatureVerifier(this.config.apiSecret).verifySignature(body, timestamp, signature, validFor);
    }

    public boolean verifyApiResponseSignature(String publicId, String version, String signature) {
        return new ApiResponseSignatureVerifier(this.config.apiSecret).verifySignature(publicId, version, signature);
    }

    public void signRequest(Map<String, Object> params, Map<String, Object> options) {
        String apiKey = ObjectUtils.asString(options.get("api_key"), this.config.apiKey);
        if (apiKey == null) {
            throw new IllegalArgumentException("Must supply api_key");
        }
        String apiSecret = ObjectUtils.asString(options.get("api_secret"), this.config.apiSecret);
        if (apiSecret == null) {
            throw new IllegalArgumentException("Must supply api_secret");
        }
        Util.clearEmpty(params);
        params.put("signature", this.apiSignRequest(params, apiSecret));
        params.put("api_key", apiKey);
    }

    public String privateDownload(String publicId, String format, Map<String, Object> options) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("public_id", publicId);
        params.put("format", format);
        params.put("attachment", options.get("attachment"));
        params.put("type", options.get("type"));
        params.put("expires_at", options.get("expires_at"));
        params.put("timestamp", Util.timestamp());
        this.signRequest(params, options);
        return this.buildUrl(this.cloudinaryApiUrl("download", options), params);
    }

    public String zipDownload(String tag, Map<String, Object> options) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("timestamp", Util.timestamp());
        params.put("tag", tag);
        Object transformation = options.get("transformation");
        if (transformation != null) {
            if (transformation instanceof Transformation) {
                transformation = ((Transformation)transformation).generate();
            }
            params.put("transformation", transformation.toString());
        }
        params.put("transformation", transformation);
        this.signRequest(params, options);
        return this.buildUrl(this.cloudinaryApiUrl("download_tag.zip", options), params);
    }

    public String downloadArchive(Map<String, Object> options, String targetFormat) throws UnsupportedEncodingException {
        Map<String, Object> params = Util.buildArchiveParams(options, targetFormat);
        params.put("mode", "download");
        this.signRequest(params, options);
        return this.buildUrl(this.cloudinaryApiUrl("generate_archive", options), params);
    }

    public String downloadArchive(ArchiveParams params) throws UnsupportedEncodingException {
        return this.downloadArchive(params.toMap(), params.targetFormat());
    }

    public String downloadZip(Map<String, Object> options) throws UnsupportedEncodingException {
        return this.downloadArchive(options, "zip");
    }

    private String buildUrl(String base, Map<String, Object> params) throws UnsupportedEncodingException {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(base);
        if (!params.isEmpty()) {
            urlBuilder.append("?");
        }
        boolean first = true;
        for (Map.Entry<String, Object> param : params.entrySet()) {
            String keyValue = null;
            List<Object> value = param.getValue();
            if (!first) {
                urlBuilder.append("&");
            }
            if (value instanceof Object[]) {
                value = Arrays.asList(value);
            }
            if (value instanceof Collection) {
                String key = param.getKey() + "[]=";
                Collection items = value;
                ArrayList<String> encodedItems = new ArrayList<String>();
                for (Object item : items) {
                    encodedItems.add(URLEncoder.encode(item.toString(), "UTF-8"));
                }
                keyValue = key + StringUtils.join(encodedItems, "&" + key);
            } else {
                keyValue = param.getKey() + "=" + URLEncoder.encode(value.toString(), "UTF-8");
            }
            urlBuilder.append(keyValue);
            first = false;
        }
        return urlBuilder.toString();
    }

    @Deprecated
    public static Map asMap(Object ... values) {
        return ObjectUtils.asMap(values);
    }
}

