/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.strategies;

import com.cloudinary.Api;
import com.cloudinary.SmartUrlEncoder;
import com.cloudinary.api.ApiResponse;
import com.cloudinary.utils.StringUtils;
import java.util.Arrays;
import java.util.Map;

public abstract class AbstractApiStrategy {
    protected Api api;

    public void init(Api api) {
        this.api = api;
    }

    protected String createApiUrl(Iterable<String> uri, String prefix, String cloudName) {
        String apiUrl = StringUtils.join(Arrays.asList(prefix, "v1_1", cloudName), "/");
        for (String component : uri) {
            component = SmartUrlEncoder.encode(component);
            apiUrl = apiUrl + "/" + component;
        }
        return apiUrl;
    }

    public abstract ApiResponse callApi(Api.HttpMethod var1, Iterable<String> var2, Map<String, ? extends Object> var3, Map var4) throws Exception;

    public abstract ApiResponse callAccountApi(Api.HttpMethod var1, Iterable<String> var2, Map<String, ? extends Object> var3, Map var4) throws Exception;
}

