/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary;

import com.cloudinary.Api;
import com.cloudinary.Cloudinary;
import com.cloudinary.api.ApiResponse;
import com.cloudinary.utils.ObjectUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Search {
    private final Api api;
    private ArrayList<HashMap<String, Object>> sortByParam;
    private ArrayList<String> aggregateParam;
    private ArrayList<String> withFieldParam;
    private HashMap<String, Object> params;

    Search(Cloudinary cloudinary) {
        this.api = cloudinary.api();
        this.params = new HashMap();
        this.sortByParam = new ArrayList();
        this.aggregateParam = new ArrayList();
        this.withFieldParam = new ArrayList();
    }

    public Search expression(String value) {
        this.params.put("expression", value);
        return this;
    }

    public Search maxResults(Integer value) {
        this.params.put("max_results", value);
        return this;
    }

    public Search nextCursor(String value) {
        this.params.put("next_cursor", value);
        return this;
    }

    public Search aggregate(String field) {
        if (!this.aggregateParam.contains(field)) {
            this.aggregateParam.add(field);
        }
        return this;
    }

    public Search withField(String field) {
        if (!this.withFieldParam.contains(field)) {
            this.withFieldParam.add(field);
        }
        return this;
    }

    public Search sortBy(String field, String dir) {
        HashMap<String, String> sortBucket = new HashMap<String, String>();
        sortBucket.put(field, dir);
        for (int i = 0; i < this.sortByParam.size(); ++i) {
            if (!this.sortByParam.get(i).containsKey(field)) continue;
            this.sortByParam.add(i, sortBucket);
            return this;
        }
        this.sortByParam.add(sortBucket);
        return this;
    }

    public HashMap<String, Object> toQuery() {
        HashMap<String, Object> queryParams = new HashMap<String, Object>(this.params);
        queryParams.put("with_field", this.withFieldParam);
        queryParams.put("sort_by", this.sortByParam);
        queryParams.put("aggregate", this.aggregateParam);
        return queryParams;
    }

    public ApiResponse execute() throws Exception {
        Map options = ObjectUtils.asMap("content_type", "json");
        return this.api.callApi(Api.HttpMethod.POST, Arrays.asList("resources", "search"), this.toQuery(), options);
    }
}

