/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.utils;

import com.cloudinary.utils.Base64Map;
import com.cloudinary.utils.StringUtils;
import java.util.Arrays;
import java.util.List;

public class Analytics {
    private String sdkTokenQueryKey = "_a";
    private String sdkQueryDelimiter = "=";
    public String algoVersion = "A";
    public String SDKCode = "";
    public String SDKSemver = "";
    public String techVersion = "";

    public Analytics() {
        this("G", "1.33.0", System.getProperty("java.version"));
    }

    public Analytics(String sdkCode, String sdkVersion, String techVersion) {
        this.SDKCode = sdkCode;
        this.SDKSemver = sdkVersion;
        this.techVersion = techVersion;
    }

    public Analytics setSDKCode(String SDKCode) {
        this.SDKCode = SDKCode;
        return this;
    }

    public Analytics setSDKSemver(String SDKSemver) {
        this.SDKSemver = SDKSemver;
        return this;
    }

    public Analytics setTechVersion(String techVersion) {
        this.techVersion = techVersion;
        return this;
    }

    public String toQueryParam() {
        try {
            return this.sdkTokenQueryKey + this.sdkQueryDelimiter + this.getAlgorithmVersion() + this.getSDKType() + this.getSDKVersion() + this.getTechVersion() + this.getSDKFeatureCode();
        }
        catch (Exception e) {
            return this.sdkTokenQueryKey + this.sdkQueryDelimiter + "E";
        }
    }

    private String getTechVersion() throws Exception {
        String[] techVersionString = this.techVersion.split("_");
        Object[] versions = techVersionString[0].split("\\.");
        if (versions.length > 2) {
            versions = (String[])Arrays.copyOf(versions, versions.length - 1);
        }
        return this.getPaddedString(StringUtils.join(versions, "."));
    }

    private String getSDKType() {
        return this.SDKCode;
    }

    private String getAlgorithmVersion() {
        return "A";
    }

    private String getSDKFeatureCode() {
        return "0";
    }

    private String getSDKVersion() throws Exception {
        return this.getPaddedString(this.SDKSemver);
    }

    private String getPaddedString(String string) throws Exception {
        String paddedReversedSemver = "";
        int parts = string.split("\\.").length;
        int paddedStringLength = parts * 6;
        try {
            paddedReversedSemver = this.reverseVersion(string);
        }
        catch (Exception e) {
            throw new Exception("Error");
        }
        int num = Integer.parseInt(StringUtils.join(paddedReversedSemver.split("\\."), ""));
        String paddedBinary = StringUtils.padStart(Integer.toBinaryString(num), paddedStringLength, '0');
        if (paddedBinary.length() % 6 != 0) {
            throw new Exception("Error");
        }
        String result = "";
        List<String> resultList = StringUtils.getAllSubStringWithSize(paddedBinary, 6);
        for (int i = 0; i < resultList.size(); ++i) {
            result = result + Base64Map.values.get(resultList.get(i));
        }
        return result;
    }

    private String reverseVersion(String SDKSemver) throws Exception {
        if (SDKSemver.split("\\.").length < 2) {
            throw new Exception("invalid semVer, must have at least two segments");
        }
        String[] versionArray = SDKSemver.split("\\.");
        for (int i = 0; i < versionArray.length; ++i) {
            versionArray[i] = StringUtils.padStart(versionArray[i], 2, '0');
        }
        return StringUtils.join(StringUtils.reverseStringArray(versionArray), ".");
    }
}

