/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary;

import com.cloudinary.utils.ObjectUtils;
import com.cloudinary.utils.StringUtils;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class AuthToken {
    public static final AuthToken NULL_AUTH_TOKEN = new AuthToken().setNull();
    private static final String AUTH_TOKEN_NAME = "__cld_token__";
    private String tokenName = "__cld_token__";
    private String key;
    private long startTime;
    private long expiration;
    private String ip;
    private List<String> acl = new ArrayList<String>();
    private long duration;
    private boolean isNullToken = false;
    private static final Pattern UNSAFE_URL_CHARS_PATTERN = Pattern.compile("[ \"#%&'/:;<=>?@\\[\\\\\\]^`{|}~]");

    public AuthToken() {
    }

    public AuthToken(String key) {
        this.key = key;
    }

    public AuthToken(Map options) {
        if (options != null) {
            this.tokenName = ObjectUtils.asString(options.get("tokenName"), this.tokenName);
            this.key = (String)options.get("key");
            this.startTime = ObjectUtils.asLong(options.get("startTime"), 0L);
            this.expiration = ObjectUtils.asLong(options.get("expiration"), 0L);
            this.ip = (String)options.get("ip");
            Object acl = options.get("acl");
            if (acl != null) {
                if (acl instanceof String) {
                    this.acl = Collections.singletonList(acl.toString());
                } else if (Collection.class.isAssignableFrom(acl.getClass())) {
                    this.acl = new ArrayList<String>((Collection)acl);
                }
            }
            this.duration = ObjectUtils.asLong(options.get("duration"), 0L);
        }
    }

    public Map<String, Object> asMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("tokenName", this.tokenName);
        result.put("key", this.key);
        result.put("startTime", this.startTime);
        result.put("expiration", this.expiration);
        result.put("ip", this.ip);
        result.put("acl", this.acl);
        result.put("duration", this.duration);
        return result;
    }

    public AuthToken tokenName(String tokenName) {
        this.tokenName = tokenName;
        return this;
    }

    public AuthToken startTime(long startTime) {
        this.startTime = startTime;
        return this;
    }

    public AuthToken expiration(long expiration) {
        this.expiration = expiration;
        return this;
    }

    public AuthToken ip(String ip) {
        this.ip = ip;
        return this;
    }

    public AuthToken acl(String ... acl) {
        this.acl = Arrays.asList(acl);
        return this;
    }

    public AuthToken duration(long duration) {
        this.duration = duration;
        return this;
    }

    public String generate() {
        return this.generate(null);
    }

    public String generate(String url) {
        if (url == null && (this.acl == null || this.acl.size() == 0)) {
            throw new IllegalArgumentException("Must provide acl or url");
        }
        long expiration = this.expiration;
        if (expiration == 0L) {
            if (this.duration > 0L) {
                long start = this.startTime > 0L ? this.startTime : Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTimeInMillis() / 1000L;
                expiration = start + this.duration;
            } else {
                throw new IllegalArgumentException("Must provide either expiration or duration");
            }
        }
        ArrayList<String> tokenParts = new ArrayList<String>();
        if (this.ip != null) {
            tokenParts.add("ip=" + this.ip);
        }
        if (this.startTime > 0L) {
            tokenParts.add("st=" + this.startTime);
        }
        tokenParts.add("exp=" + expiration);
        if (this.acl != null && this.acl.size() > 0) {
            tokenParts.add("acl=" + this.escapeToLower(String.join((CharSequence)"!", this.acl)));
        }
        ArrayList<String> toSign = new ArrayList<String>(tokenParts);
        if (url != null && (this.acl == null || this.acl.size() == 0)) {
            toSign.add("url=" + this.escapeToLower(url));
        }
        String auth = this.digest(StringUtils.join(toSign, "~"));
        tokenParts.add("hmac=" + auth);
        return this.tokenName + "=" + StringUtils.join(tokenParts, "~");
    }

    private String escapeToLower(String url) {
        String encodedUrl = StringUtils.urlEncode(url, UNSAFE_URL_CHARS_PATTERN, Charset.forName("UTF-8"));
        return encodedUrl;
    }

    public AuthToken copy() {
        AuthToken authToken = new AuthToken(this.key);
        authToken.tokenName = this.tokenName;
        authToken.startTime = this.startTime;
        authToken.expiration = this.expiration;
        authToken.ip = this.ip;
        authToken.acl = this.acl;
        authToken.duration = this.duration;
        return authToken;
    }

    public AuthToken merge(AuthToken other) {
        if (other.equals(NULL_AUTH_TOKEN)) {
            return other;
        }
        AuthToken merged = new AuthToken();
        merged.key = other.key != null ? other.key : this.key;
        merged.tokenName = other.tokenName != null ? other.tokenName : this.tokenName;
        merged.startTime = other.startTime != 0L ? other.startTime : this.startTime;
        merged.expiration = other.expiration != 0L ? other.expiration : this.expiration;
        merged.ip = other.ip != null ? other.ip : this.ip;
        merged.acl = other.acl != null ? other.acl : this.acl;
        merged.duration = other.duration != 0L ? other.duration : this.duration;
        return merged;
    }

    private String digest(String message) {
        byte[] binKey = StringUtils.hexStringToByteArray(this.key);
        try {
            Mac hmac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret = new SecretKeySpec(binKey, "HmacSHA256");
            hmac.init(secret);
            byte[] bytes = message.getBytes();
            return StringUtils.encodeHexString(hmac.doFinal(bytes)).toLowerCase();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Cannot create authorization token.", e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Cannot create authorization token.", e);
        }
    }

    private AuthToken setNull() {
        this.isNullToken = true;
        return this;
    }

    public boolean equals(Object o) {
        if (o instanceof AuthToken) {
            AuthToken other = (AuthToken)o;
            return this.isNullToken && other.isNullToken || (this.key == null ? other.key == null : this.key.equals(other.key)) && this.tokenName.equals(other.tokenName) && this.startTime == other.startTime && this.expiration == other.expiration && this.duration == other.duration && (this.ip == null ? other.ip == null : this.ip.equals(other.ip)) && (this.acl == null ? other.acl == null : this.acl.equals(other.acl));
        }
        return false;
    }

    public int hashCode() {
        if (this.isNullToken) {
            return 0;
        }
        return Arrays.asList(this.tokenName, this.startTime, this.expiration, this.duration, this.ip, this.acl).hashCode();
    }
}

