/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.provisioning;

import com.cloudinary.Api;
import com.cloudinary.Cloudinary;
import com.cloudinary.Util;
import com.cloudinary.api.ApiResponse;
import com.cloudinary.provisioning.AccountConfiguration;
import com.cloudinary.utils.ObjectUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Account {
    private static final String CLOUDINARY_ACCOUNT_URL = "CLOUDINARY_ACCOUNT_URL";
    public static final String PROVISIONING = "provisioning";
    public static final String ACCOUNTS = "accounts";
    public static final String USERS = "users";
    public static final String USER_GROUPS = "user_groups";
    private final AccountConfiguration configuration;
    private final String accountId;
    private final String key;
    private final String secret;
    private final Api api;

    public Account(Cloudinary cloudinary) {
        String provisioningData = System.getProperty(CLOUDINARY_ACCOUNT_URL, System.getenv(CLOUDINARY_ACCOUNT_URL));
        if (provisioningData == null) {
            throw new IllegalArgumentException("Must provide configuration instance or set an ENV variable: CLOUDINARY_ACCOUNT_URL=account://provisioning_api_key:provisioning_api_secret@account_id");
        }
        this.configuration = AccountConfiguration.from(provisioningData);
        this.accountId = this.configuration.accountId;
        this.key = this.configuration.provisioningApiKey;
        this.secret = this.configuration.provisioningApiSecret;
        this.api = cloudinary.api();
    }

    public Account(AccountConfiguration accountConfiguration, Cloudinary cloudinary) {
        this.configuration = accountConfiguration;
        this.api = cloudinary.api();
        this.accountId = accountConfiguration.accountId;
        this.key = accountConfiguration.provisioningApiKey;
        this.secret = accountConfiguration.provisioningApiSecret;
    }

    private ApiResponse callAccountApi(Api.HttpMethod method, List<String> uri, Map<String, Object> params, Map<String, Object> options) throws Exception {
        if ((options = this.verifyOptions(options)).containsKey("provisioning_api_key")) {
            if (!options.containsKey("provisioning_api_secret")) {
                throw new IllegalArgumentException("When providing key or secret through options, both must be provided");
            }
        } else {
            if (options.containsKey("provisioning_api_secret")) {
                throw new IllegalArgumentException("When providing key or secret through options, both must be provided");
            }
            options.put("provisioning_api_key", this.key);
            options.put("provisioning_api_secret", this.secret);
        }
        Util.clearEmpty(params);
        return this.api.getStrategy().callAccountApi(method, uri, params, options);
    }

    public ApiResponse subAccount(String subAccountId) throws Exception {
        return this.subAccount(subAccountId, Collections.emptyMap());
    }

    public ApiResponse subAccount(String subAccountId, Map<String, Object> options) throws Exception {
        List<String> uri = Arrays.asList(PROVISIONING, ACCOUNTS, this.accountId, "sub_accounts", subAccountId);
        return this.callAccountApi(Api.HttpMethod.GET, uri, Collections.emptyMap(), options);
    }

    public ApiResponse subAccounts(Boolean enabled, List<String> ids, String prefix) throws Exception {
        return this.subAccounts(enabled, ids, prefix, Collections.emptyMap());
    }

    public ApiResponse subAccounts(Boolean enabled, List<String> ids, String prefix, Map<String, Object> options) throws Exception {
        List<String> uri = Arrays.asList(PROVISIONING, ACCOUNTS, this.accountId, "sub_accounts");
        return this.callAccountApi(Api.HttpMethod.GET, uri, ObjectUtils.asMap("accountId", this.accountId, "enabled", enabled, "ids", ids, "prefix", prefix), options);
    }

    public ApiResponse createSubAccount(String name, String cloudName, Map customAttributes, boolean enabled, String baseAccount) throws Exception {
        return this.createSubAccount(name, cloudName, customAttributes, enabled, baseAccount, Collections.emptyMap());
    }

    public ApiResponse createSubAccount(String name, String cloudName, Map customAttributes, boolean enabled, String baseAccount, Map<String, Object> options) throws Exception {
        options = this.verifyOptions(options);
        options.put("content_type", "json");
        List<String> uri = Arrays.asList(PROVISIONING, ACCOUNTS, this.accountId, "sub_accounts");
        return this.callAccountApi(Api.HttpMethod.POST, uri, ObjectUtils.asMap("cloud_name", cloudName, "name", name, "custom_attributes", customAttributes, "enabled", enabled, "base_sub_account_id", baseAccount), options);
    }

    public ApiResponse updateSubAccount(String subAccountId, String name, String cloudName, Map<String, String> customAttributes, Boolean enabled) throws Exception {
        return this.updateSubAccount(subAccountId, name, cloudName, customAttributes, enabled, Collections.emptyMap());
    }

    public ApiResponse updateSubAccount(String subAccountId, String name, String cloudName, Map<String, String> customAttributes, Boolean enabled, Map<String, Object> options) throws Exception {
        options = this.verifyOptions(options);
        options.put("content_type", "json");
        List<String> uri = Arrays.asList(PROVISIONING, ACCOUNTS, this.accountId, "sub_accounts", subAccountId);
        return this.callAccountApi(Api.HttpMethod.PUT, uri, ObjectUtils.asMap("cloud_name", cloudName, "name", name, "custom_attributes", customAttributes, "enabled", enabled), options);
    }

    public ApiResponse deleteSubAccount(String subAccountId) throws Exception {
        return this.deleteSubAccount(subAccountId, Collections.emptyMap());
    }

    public ApiResponse deleteSubAccount(String subAccountId, Map<String, Object> options) throws Exception {
        List<String> uri = Arrays.asList(PROVISIONING, ACCOUNTS, this.accountId, "sub_accounts", subAccountId);
        return this.callAccountApi(Api.HttpMethod.DELETE, uri, Collections.emptyMap(), options);
    }

    public ApiResponse user(String userId) throws Exception {
        return this.user(userId, null);
    }

    public ApiResponse user(String userId, Map<String, Object> options) throws Exception {
        List<String> uri = Arrays.asList(PROVISIONING, ACCOUNTS, this.accountId, USERS, userId);
        return this.callAccountApi(Api.HttpMethod.GET, uri, Collections.emptyMap(), options);
    }

    public ApiResponse users(Boolean pending, List<String> userIds, String prefix, String subAccountId) throws Exception {
        return this.users(pending, userIds, prefix, subAccountId, null);
    }

    public ApiResponse users(Boolean pending, List<String> userIds, String prefix, String subAccountId, Map<String, Object> options) throws Exception {
        List<String> uri = Arrays.asList(PROVISIONING, ACCOUNTS, this.accountId, USERS);
        return this.callAccountApi(Api.HttpMethod.GET, uri, ObjectUtils.asMap("accountId", this.accountId, "pending", pending, "ids", userIds, "prefix", prefix, "sub_account_id", subAccountId), options);
    }

    public ApiResponse createUser(String name, String email, Role role, List<String> subAccountsIds) throws Exception {
        return this.createUser(name, email, role, subAccountsIds, null);
    }

    public ApiResponse createUser(String name, String email, Role role, List<String> subAccountsIds, Map<String, Object> options) throws Exception {
        return this.createUser(name, email, role, null, subAccountsIds, options);
    }

    public ApiResponse createUser(String name, String email, Role role, Boolean enabled, List<String> subAccountsIds, Map<String, Object> options) throws Exception {
        List<String> uri = Arrays.asList(PROVISIONING, ACCOUNTS, this.accountId, USERS);
        return this.performUserAction(Api.HttpMethod.POST, uri, email, name, role, enabled, subAccountsIds, options);
    }

    public ApiResponse updateUser(String userId, String name, String email, Role role, List<String> subAccountsIds) throws Exception {
        return this.updateUser(userId, name, email, role, subAccountsIds, null);
    }

    public ApiResponse updateUser(String userId, String name, String email, Role role, List<String> subAccountsIds, Map<String, Object> options) throws Exception {
        return this.updateUser(userId, name, email, role, null, subAccountsIds, options);
    }

    public ApiResponse updateUser(String userId, String name, String email, Role role, Boolean enabled, List<String> subAccountsIds, Map<String, Object> options) throws Exception {
        List<String> uri = Arrays.asList(PROVISIONING, ACCOUNTS, this.accountId, USERS, userId);
        return this.performUserAction(Api.HttpMethod.PUT, uri, email, name, role, enabled, subAccountsIds, options);
    }

    public ApiResponse deleteUser(String userId) throws Exception {
        return this.deleteUser(userId, null);
    }

    public ApiResponse deleteUser(String userId, Map<String, Object> options) throws Exception {
        List<String> uri = Arrays.asList(PROVISIONING, ACCOUNTS, this.accountId, USERS, userId);
        return this.callAccountApi(Api.HttpMethod.DELETE, uri, Collections.emptyMap(), options);
    }

    public ApiResponse createUserGroup(String name) throws Exception {
        return this.createUserGroup(name, null);
    }

    public ApiResponse createUserGroup(String name, Map<String, Object> options) throws Exception {
        List<String> uri = Arrays.asList(PROVISIONING, ACCOUNTS, this.accountId, USER_GROUPS);
        return this.callAccountApi(Api.HttpMethod.POST, uri, ObjectUtils.asMap("name", name), options);
    }

    public ApiResponse updateUserGroup(String groupId, String name) throws Exception {
        return this.updateUserGroup(groupId, name, null);
    }

    public ApiResponse updateUserGroup(String groupId, String name, Map<String, Object> options) throws Exception {
        List<String> uri = Arrays.asList(PROVISIONING, ACCOUNTS, this.accountId, USER_GROUPS, groupId);
        return this.callAccountApi(Api.HttpMethod.PUT, uri, ObjectUtils.asMap("name", name), options);
    }

    public ApiResponse deleteUserGroup(String groupId) throws Exception {
        return this.deleteUserGroup(groupId, null);
    }

    public ApiResponse deleteUserGroup(String groupId, Map<String, Object> options) throws Exception {
        List<String> uri = Arrays.asList(PROVISIONING, ACCOUNTS, this.accountId, USER_GROUPS, groupId);
        return this.callAccountApi(Api.HttpMethod.DELETE, uri, Collections.emptyMap(), options);
    }

    public ApiResponse addUserToGroup(String groupId, String userId) throws Exception {
        return this.addUserToGroup(groupId, userId, null);
    }

    public ApiResponse addUserToGroup(String groupId, String userId, Map<String, Object> options) throws Exception {
        List<String> uri = Arrays.asList(PROVISIONING, ACCOUNTS, this.accountId, USER_GROUPS, groupId, USERS, userId);
        return this.callAccountApi(Api.HttpMethod.POST, uri, Collections.emptyMap(), options);
    }

    public ApiResponse removeUserFromGroup(String groupId, String userId) throws Exception {
        return this.removeUserFromGroup(groupId, userId, null);
    }

    public ApiResponse removeUserFromGroup(String groupId, String userId, Map<String, Object> options) throws Exception {
        List<String> uri = Arrays.asList(PROVISIONING, ACCOUNTS, this.accountId, USER_GROUPS, groupId, USERS, userId);
        return this.callAccountApi(Api.HttpMethod.DELETE, uri, Collections.emptyMap(), options);
    }

    public ApiResponse userGroup(String groupId) throws Exception {
        return this.userGroup(groupId, null);
    }

    public ApiResponse userGroup(String groupId, Map<String, Object> options) throws Exception {
        List<String> uri = Arrays.asList(PROVISIONING, ACCOUNTS, this.accountId, USER_GROUPS, groupId);
        return this.callAccountApi(Api.HttpMethod.GET, uri, Collections.emptyMap(), options);
    }

    public ApiResponse userGroups() throws Exception {
        return this.userGroups(Collections.emptyMap());
    }

    public ApiResponse userGroups(Map<String, Object> options) throws Exception {
        List<String> uri = Arrays.asList(PROVISIONING, ACCOUNTS, this.accountId, USER_GROUPS);
        return this.callAccountApi(Api.HttpMethod.GET, uri, Collections.emptyMap(), options);
    }

    public ApiResponse userGroupUsers(String groupId) throws Exception {
        return this.userGroupUsers(groupId, null);
    }

    public ApiResponse userGroupUsers(String groupId, Map<String, Object> options) throws Exception {
        List<String> uri = Arrays.asList(PROVISIONING, ACCOUNTS, this.accountId, USER_GROUPS, groupId, USERS);
        return this.callAccountApi(Api.HttpMethod.GET, uri, Collections.emptyMap(), options);
    }

    private ApiResponse performUserAction(Api.HttpMethod method, List<String> uri, String email, String name, Role role, Boolean enabled, List<String> subAccountsIds, Map<String, Object> options) throws Exception {
        options = this.verifyOptions(options);
        options.put("content_type", "json");
        return this.callAccountApi(method, uri, ObjectUtils.asMap("email", email, "name", name, "role", role == null ? null : role.serializedValue, "enabled", enabled, "sub_account_ids", subAccountsIds), options);
    }

    private Map<String, Object> verifyOptions(Map<String, Object> options) {
        if (options == null || options == Collections.EMPTY_MAP) {
            return new HashMap<String, Object>(2);
        }
        return options;
    }

    public static enum Role {
        MASTER_ADMIN("master_admin"),
        ADMIN("admin"),
        TECHNICAL_ADMIN("technical_admin"),
        BILLING("billing"),
        REPORTS("reports"),
        MEDIA_LIBRARY_ADMIN("media_library_admin"),
        MEDIA_LIBRARY_USER("media_library_user");

        private final String serializedValue;

        private Role(String serializedValue) {
            this.serializedValue = serializedValue;
        }

        public String toString() {
            return this.serializedValue;
        }
    }
}

