/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.metadata;

import com.cloudinary.metadata.MetadataDataSource;
import com.cloudinary.metadata.MetadataFieldType;
import com.cloudinary.metadata.MetadataValidation;
import com.cloudinary.metadata.Restrictions;
import java.text.ParseException;
import org.cloudinary.json.JSONObject;

public class MetadataField<T>
extends JSONObject {
    public static final String DEFAULT_VALUE = "default_value";
    public static final String EXTERNAL_ID = "external_id";
    public static final String LABEL = "label";
    public static final String MANDATORY = "mandatory";
    public static final String TYPE = "type";
    public static final String VALIDATION = "validation";
    public static final String RESTRICTIONS = "restrictions";

    public MetadataField(MetadataFieldType type) {
        this.put(TYPE, type.toString());
    }

    public MetadataField(String type) {
        this.put(TYPE, type);
    }

    public MetadataFieldType getType() {
        return MetadataFieldType.valueOf(this.optString(TYPE).toUpperCase());
    }

    public String getExternalId() {
        return this.optString(EXTERNAL_ID);
    }

    public void setExternalId(String externalId) {
        this.put(EXTERNAL_ID, externalId);
    }

    public String getLabel() {
        return this.optString(LABEL);
    }

    public void setLabel(String label) {
        this.put(LABEL, label);
    }

    public boolean isMandatory() {
        return this.optBoolean(MANDATORY);
    }

    public void setMandatory(Boolean mandatory) {
        this.put(MANDATORY, mandatory);
    }

    public T getDefaultValue() throws ParseException {
        return (T)this.opt(DEFAULT_VALUE);
    }

    public void setDefaultValue(T defaultValue) {
        this.put(DEFAULT_VALUE, defaultValue);
    }

    public MetadataValidation getValidation() {
        return (MetadataValidation)this.optJSONObject(VALIDATION);
    }

    public void setValidation(MetadataValidation validation) {
        this.put(VALIDATION, validation);
    }

    public MetadataDataSource getDataSource() {
        return (MetadataDataSource)this.optJSONObject("datasource");
    }

    public void setDataSource(MetadataDataSource dataSource) {
        this.put("datasource", dataSource);
    }

    public void setRestrictions(Restrictions restrictions) {
        this.put(RESTRICTIONS, restrictions.toHash());
    }
}

