/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.utils;

import com.cloudinary.utils.Base64Map;
import com.cloudinary.utils.StringUtils;
import java.util.Arrays;
import java.util.List;

public class Analytics {
    private String sdkTokenQueryKey = "_a";
    private String sdkQueryDelimiter = "=";
    public String algoVersion = "D";
    public String prodcut = "A";
    public String SDKCode = "";
    public String SDKSemver = "";
    public String techVersion = "";
    public String osType;
    public String osVersion;
    public String featureFlag = "0";

    public Analytics() {
        this("G", "1.39.0", System.getProperty("java.version"), "Z", "0.0", "0");
    }

    public Analytics(String sdkCode, String sdkVersion, String techVersion, String osType, String osVersion, String featureFlag) {
        this.SDKCode = sdkCode;
        this.SDKSemver = sdkVersion;
        this.techVersion = techVersion;
        this.osType = osType;
        this.osVersion = osVersion;
        this.featureFlag = featureFlag;
    }

    public Analytics setSDKCode(String SDKCode) {
        this.SDKCode = SDKCode;
        return this;
    }

    public Analytics setSDKSemver(String SDKSemver) {
        this.SDKSemver = SDKSemver;
        return this;
    }

    public Analytics setTechVersion(String techVersion) {
        this.techVersion = techVersion;
        return this;
    }

    public Analytics setFeatureFlag(String flag) {
        this.featureFlag = flag;
        return this;
    }

    public String toQueryParam() {
        try {
            return this.sdkTokenQueryKey + this.sdkQueryDelimiter + this.getAlgorithmVersion() + this.prodcut + this.getSDKType() + this.getSDKVersion() + this.getTechVersion() + this.getOsType() + this.getOsVersion() + this.getSDKFeatureFlag();
        }
        catch (Exception e) {
            return this.sdkTokenQueryKey + this.sdkQueryDelimiter + "E";
        }
    }

    private String getTechVersion() throws Exception {
        String[] techVersionString = this.techVersion.split("_");
        String[] versions = techVersionString[0].split("\\.");
        return this.versionArrayToString(versions);
    }

    private String versionArrayToString(String[] versions) throws Exception {
        if (versions.length > 2) {
            versions = Arrays.copyOf(versions, versions.length - 1);
        }
        return this.getPaddedString(StringUtils.join(versions, "."));
    }

    private String versionArrayToOsString(String[] versions) throws Exception {
        if (versions.length > 2) {
            versions = Arrays.copyOf(versions, versions.length - 1);
        }
        return this.getOsVersionString(StringUtils.join(versions, "."));
    }

    private String getOsType() {
        return this.osType != null ? this.osType : "Z";
    }

    private String getOsVersion() throws Exception {
        return this.osVersion != null ? this.versionArrayToOsString(this.osVersion.split("\\.")) : this.versionArrayToString(System.getProperty("os.version").split("\\."));
    }

    private String getSDKType() {
        return this.SDKCode;
    }

    private String getAlgorithmVersion() {
        return this.algoVersion;
    }

    private String getSDKFeatureFlag() {
        return this.featureFlag;
    }

    private String getSDKVersion() throws Exception {
        return this.getPaddedString(this.SDKSemver);
    }

    private String getOsVersionString(String string) throws Exception {
        String[] parts = string.split("\\.");
        String result = "";
        for (int i = 0; i < parts.length; ++i) {
            int num = Integer.parseInt(parts[i]);
            String binaryString = Integer.toBinaryString(num);
            binaryString = StringUtils.padStart(binaryString, 6, '0');
            result = result + Base64Map.values.get(binaryString);
        }
        return result;
    }

    private String getPaddedString(String string) throws Exception {
        String paddedReversedSemver = "";
        int parts = string.split("\\.").length;
        int paddedStringLength = parts * 6;
        try {
            paddedReversedSemver = this.reverseVersion(string);
        }
        catch (Exception e) {
            throw new Exception("Error");
        }
        int num = Integer.parseInt(StringUtils.join(paddedReversedSemver.split("\\."), ""));
        String paddedBinary = StringUtils.padStart(Integer.toBinaryString(num), paddedStringLength, '0');
        if (paddedBinary.length() % 6 != 0) {
            throw new Exception("Error");
        }
        String result = "";
        List<String> resultList = StringUtils.getAllSubStringWithSize(paddedBinary, 6);
        for (int i = 0; i < resultList.size(); ++i) {
            result = result + Base64Map.values.get(resultList.get(i));
        }
        return result;
    }

    private String reverseVersion(String SDKSemver) throws Exception {
        if (SDKSemver.split("\\.").length < 2) {
            throw new Exception("invalid semVer, must have at least two segments");
        }
        String[] versionArray = SDKSemver.split("\\.");
        for (int i = 0; i < versionArray.length; ++i) {
            versionArray[i] = StringUtils.padStart(versionArray[i], 2, '0');
        }
        return StringUtils.join(StringUtils.reverseStringArray(versionArray), ".");
    }
}

