/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.transformation;

import com.cloudinary.Transformation;
import com.cloudinary.utils.ObjectUtils;
import com.cloudinary.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Condition {
    public static final Map OPERATORS = ObjectUtils.asMap("=", "eq", "!=", "ne", "<", "lt", ">", "gt", "<=", "lte", ">=", "gte", "&&", "and", "||", "or");
    public static final Map PARAMETERS = ObjectUtils.asMap("width", "w", "height", "h", "aspect_ratio", "ar", "aspectRatio", "ar", "page_count", "pc", "pageCount", "pc", "face_count", "fc", "faceCount", "fc");
    protected List<String> predicateList = new ArrayList<String>();
    private Transformation parent = null;

    public Condition() {
    }

    public Condition(String conditionStr) {
        this();
        if (conditionStr != null) {
            this.predicateList.add(this.literal(conditionStr));
        }
    }

    private String literal(String conditionStr) {
        conditionStr = conditionStr.replaceAll("[ _]+", "_");
        Pattern replaceRE = Pattern.compile("(" + StringUtils.join(PARAMETERS.keySet(), "|") + "|[=<>&|!]+)");
        Matcher matcher = replaceRE.matcher(conditionStr);
        StringBuffer result = new StringBuffer(conditionStr.length());
        while (matcher.find()) {
            String replacement = OPERATORS.containsKey(matcher.group()) ? (String)OPERATORS.get(matcher.group()) : (PARAMETERS.containsKey(matcher.group()) ? (String)PARAMETERS.get(matcher.group()) : matcher.group());
            matcher.appendReplacement(result, replacement);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public Transformation getParent() {
        return this.parent;
    }

    public Condition setParent(Transformation parent) {
        this.parent = parent;
        return this;
    }

    public String serialize() {
        return StringUtils.join(this.predicateList, "_");
    }

    public String toString() {
        return this.serialize();
    }

    protected Condition predicate(String name, String operator, String value) {
        if (OPERATORS.containsKey(operator)) {
            operator = (String)OPERATORS.get(operator);
        }
        this.predicateList.add(String.format("%s_%s_%s", name, operator, value));
        return this;
    }

    public Condition and() {
        this.predicateList.add("and");
        return this;
    }

    public Condition or() {
        this.predicateList.add("or");
        return this;
    }

    public Transformation then() {
        this.getParent().ifCondition(this.serialize());
        return this.getParent();
    }

    public Condition width(String operator, Object value) {
        this.predicateList.add("w_" + operator + "_" + value);
        return this;
    }

    public Condition height(String operator, Object value) {
        this.predicateList.add("h_" + operator + "_" + value);
        return this;
    }

    public Condition aspectRatio(String operator, Object value) {
        this.predicateList.add("ar_" + operator + "_" + value);
        return this;
    }

    public Condition faces(String operator, Object value) {
        return this.faceCount(operator, value);
    }

    public Condition faceCount(String operator, Object value) {
        this.predicateList.add("fc_" + operator + "_" + value);
        return this;
    }

    public Condition pages(String operator, Object value) {
        return this.pageCount(operator, value);
    }

    public Condition pageCount(String operator, Object value) {
        this.predicateList.add("pc_" + operator + "_" + value);
        return this;
    }
}

