/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.utils;

public final class HtmlEscape {
    private static char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private HtmlEscape() {
    }

    public static String escapeTextArea(String original) {
        return HtmlEscape.escapeTags(HtmlEscape.escapeSpecial(original));
    }

    public static String escape(String original) {
        return HtmlEscape.escapeBr(HtmlEscape.escapeTags(HtmlEscape.escapeSpecial(original)));
    }

    public static String escapeTags(String original) {
        if (original == null) {
            return "";
        }
        StringBuffer out = new StringBuffer("");
        char[] chars = original.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            boolean found = true;
            switch (chars[i]) {
                case '<': {
                    out.append("&lt;");
                    break;
                }
                case '>': {
                    out.append("&gt;");
                    break;
                }
                case '\"': {
                    out.append("&quot;");
                    break;
                }
                default: {
                    found = false;
                }
            }
            if (found) continue;
            out.append(chars[i]);
        }
        return out.toString();
    }

    public static String escapeBr(String original) {
        if (original == null) {
            return "";
        }
        StringBuffer out = new StringBuffer("");
        char[] chars = original.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            boolean found = true;
            switch (chars[i]) {
                case '\n': {
                    out.append("<br/>");
                    break;
                }
                case '\r': {
                    break;
                }
                default: {
                    found = false;
                }
            }
            if (found) continue;
            out.append(chars[i]);
        }
        return out.toString();
    }

    public static String escapeSpecial(String original) {
        if (original == null) {
            return "";
        }
        StringBuffer out = new StringBuffer("");
        char[] chars = original.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            boolean found = true;
            switch (chars[i]) {
                case '&': {
                    out.append("&amp;");
                    break;
                }
                case '\u00c6': {
                    out.append("&AElig;");
                    break;
                }
                case '\u00c1': {
                    out.append("&Aacute;");
                    break;
                }
                case '\u00c2': {
                    out.append("&Acirc;");
                    break;
                }
                case '\u00c0': {
                    out.append("&Agrave;");
                    break;
                }
                case '\u00c5': {
                    out.append("&Aring;");
                    break;
                }
                case '\u00c3': {
                    out.append("&Atilde;");
                    break;
                }
                case '\u00c4': {
                    out.append("&Auml;");
                    break;
                }
                case '\u00c7': {
                    out.append("&Ccedil;");
                    break;
                }
                case '\u00d0': {
                    out.append("&ETH;");
                    break;
                }
                case '\u00c9': {
                    out.append("&Eacute;");
                    break;
                }
                case '\u00ca': {
                    out.append("&Ecirc;");
                    break;
                }
                case '\u00c8': {
                    out.append("&Egrave;");
                    break;
                }
                case '\u00cb': {
                    out.append("&Euml;");
                    break;
                }
                case '\u00cd': {
                    out.append("&Iacute;");
                    break;
                }
                case '\u00ce': {
                    out.append("&Icirc;");
                    break;
                }
                case '\u00cc': {
                    out.append("&Igrave;");
                    break;
                }
                case '\u00cf': {
                    out.append("&Iuml;");
                    break;
                }
                case '\u00d1': {
                    out.append("&Ntilde;");
                    break;
                }
                case '\u00d3': {
                    out.append("&Oacute;");
                    break;
                }
                case '\u00d4': {
                    out.append("&Ocirc;");
                    break;
                }
                case '\u00d2': {
                    out.append("&Ograve;");
                    break;
                }
                case '\u00d8': {
                    out.append("&Oslash;");
                    break;
                }
                case '\u00d5': {
                    out.append("&Otilde;");
                    break;
                }
                case '\u00d6': {
                    out.append("&Ouml;");
                    break;
                }
                case '\u00de': {
                    out.append("&THORN;");
                    break;
                }
                case '\u00da': {
                    out.append("&Uacute;");
                    break;
                }
                case '\u00db': {
                    out.append("&Ucirc;");
                    break;
                }
                case '\u00d9': {
                    out.append("&Ugrave;");
                    break;
                }
                case '\u00dc': {
                    out.append("&Uuml;");
                    break;
                }
                case '\u00dd': {
                    out.append("&Yacute;");
                    break;
                }
                case '\u00e1': {
                    out.append("&aacute;");
                    break;
                }
                case '\u00e2': {
                    out.append("&acirc;");
                    break;
                }
                case '\u00e6': {
                    out.append("&aelig;");
                    break;
                }
                case '\u00e0': {
                    out.append("&agrave;");
                    break;
                }
                case '\u00e5': {
                    out.append("&aring;");
                    break;
                }
                case '\u00e3': {
                    out.append("&atilde;");
                    break;
                }
                case '\u00e4': {
                    out.append("&auml;");
                    break;
                }
                case '\u00e7': {
                    out.append("&ccedil;");
                    break;
                }
                case '\u00e9': {
                    out.append("&eacute;");
                    break;
                }
                case '\u00ea': {
                    out.append("&ecirc;");
                    break;
                }
                case '\u00e8': {
                    out.append("&egrave;");
                    break;
                }
                case '\u00f0': {
                    out.append("&eth;");
                    break;
                }
                case '\u00eb': {
                    out.append("&euml;");
                    break;
                }
                case '\u00ed': {
                    out.append("&iacute;");
                    break;
                }
                case '\u00ee': {
                    out.append("&icirc;");
                    break;
                }
                case '\u00ec': {
                    out.append("&igrave;");
                    break;
                }
                case '\u00ef': {
                    out.append("&iuml;");
                    break;
                }
                case '\u00f1': {
                    out.append("&ntilde;");
                    break;
                }
                case '\u00f3': {
                    out.append("&oacute;");
                    break;
                }
                case '\u00f4': {
                    out.append("&ocirc;");
                    break;
                }
                case '\u00f2': {
                    out.append("&ograve;");
                    break;
                }
                case '\u00f8': {
                    out.append("&oslash;");
                    break;
                }
                case '\u00f5': {
                    out.append("&otilde;");
                    break;
                }
                case '\u00f6': {
                    out.append("&ouml;");
                    break;
                }
                case '\u00df': {
                    out.append("&szlig;");
                    break;
                }
                case '\u00fe': {
                    out.append("&thorn;");
                    break;
                }
                case '\u00fa': {
                    out.append("&uacute;");
                    break;
                }
                case '\u00fb': {
                    out.append("&ucirc;");
                    break;
                }
                case '\u00f9': {
                    out.append("&ugrave;");
                    break;
                }
                case '\u00fc': {
                    out.append("&uuml;");
                    break;
                }
                case '\u00fd': {
                    out.append("&yacute;");
                    break;
                }
                case '\u00ff': {
                    out.append("&yuml;");
                    break;
                }
                case '\u00a2': {
                    out.append("&cent;");
                    break;
                }
                default: {
                    found = false;
                }
            }
            if (found) continue;
            if (chars[i] > '\u007f') {
                char c = chars[i];
                int a4 = c % 16;
                c = (char)(c / 16);
                int a3 = c % 16;
                c = (char)(c / 16);
                int a2 = c % 16;
                c = (char)(c / 16);
                int a1 = c % 16;
                out.append("&#x" + hex[a1] + hex[a2] + hex[a3] + hex[a4] + ";");
                continue;
            }
            out.append(chars[i]);
        }
        return out.toString();
    }
}

