/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary;

import com.cloudinary.AuthToken;
import com.cloudinary.SignatureAlgorithm;
import com.cloudinary.utils.ObjectUtils;
import com.cloudinary.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

public class Configuration {
    public static final String CF_SHARED_CDN = "d3jpl91pxevbkh.cloudfront.net";
    public static final String OLD_AKAMAI_SHARED_CDN = "cloudinary-a.akamaihd.net";
    public static final String AKAMAI_SHARED_CDN = "res.cloudinary.com";
    public static final String SHARED_CDN = "res.cloudinary.com";
    public static final String VERSION = "1.0.2";
    public static final String USER_AGENT = "cld-android-1.0.2";
    public static final boolean DEFAULT_IS_LONG_SIGNATURE = false;
    public static final SignatureAlgorithm DEFAULT_SIGNATURE_ALGORITHM = SignatureAlgorithm.SHA1;
    public static final int DEFAULT_SIGNATURE_VERSION = 2;
    private static final String CONFIG_PROP_SIGNATURE_ALGORITHM = "signature_algorithm";
    public String cloudName;
    public String apiKey;
    public String apiSecret;
    public String secureDistribution;
    public String cname;
    public String uploadPrefix;
    public boolean secure;
    public boolean privateCdn;
    public boolean cdnSubdomain;
    public boolean shorten;
    public String callback;
    public String proxyHost;
    public int proxyPort;
    public Map<String, Object> properties = new HashMap<String, Object>();
    public Boolean secureCdnSubdomain;
    public boolean useRootPath;
    public boolean useFetchFormat;
    public int timeout;
    public boolean loadStrategies = true;
    public boolean clientHints = false;
    public AuthToken authToken;
    public boolean forceVersion = true;
    public boolean longUrlSignature = false;
    public SignatureAlgorithm signatureAlgorithm = DEFAULT_SIGNATURE_ALGORITHM;
    public int signatureVersion = 2;
    public String oauthToken = null;
    public Boolean analytics;

    public Configuration() {
    }

    private Configuration(String cloudName, String apiKey, String apiSecret, String secureDistribution, String cname, String uploadPrefix, boolean secure, boolean privateCdn, boolean cdnSubdomain, boolean shorten, String callback, String proxyHost, int proxyPort, Boolean secureCdnSubdomain, boolean useRootPath, boolean useFetchFormat, int timeout, boolean loadStrategies, boolean forceVersion, boolean longUrlSignature, SignatureAlgorithm signatureAlgorithm, int signatureVersion, String oauthToken, boolean analytics) {
        this.cloudName = cloudName;
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
        this.secureDistribution = secureDistribution;
        this.cname = cname;
        this.uploadPrefix = uploadPrefix;
        this.secure = secure;
        this.privateCdn = privateCdn;
        this.cdnSubdomain = cdnSubdomain;
        this.shorten = shorten;
        this.callback = callback;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.secureCdnSubdomain = secureCdnSubdomain;
        this.useRootPath = useRootPath;
        this.useFetchFormat = useFetchFormat;
        this.timeout = timeout;
        this.loadStrategies = loadStrategies;
        this.forceVersion = forceVersion;
        this.longUrlSignature = longUrlSignature;
        this.signatureAlgorithm = signatureAlgorithm;
        this.signatureVersion = signatureVersion;
        this.oauthToken = oauthToken;
        this.analytics = analytics;
    }

    public Configuration(Map config) {
        this.update(config);
    }

    public void update(Map config) {
        this.cloudName = (String)config.get("cloud_name");
        this.apiKey = (String)config.get("api_key");
        this.apiSecret = (String)config.get("api_secret");
        this.secureDistribution = (String)config.get("secure_distribution");
        this.cname = (String)config.get("cname");
        this.secure = ObjectUtils.asBoolean(config.get("secure"), true);
        this.privateCdn = ObjectUtils.asBoolean(config.get("private_cdn"), false);
        this.cdnSubdomain = ObjectUtils.asBoolean(config.get("cdn_subdomain"), false);
        this.shorten = ObjectUtils.asBoolean(config.get("shorten"), false);
        this.uploadPrefix = (String)config.get("upload_prefix");
        this.callback = (String)config.get("callback");
        this.proxyHost = (String)config.get("proxy_host");
        this.proxyPort = ObjectUtils.asInteger(config.get("proxy_port"), 0);
        this.secureCdnSubdomain = ObjectUtils.asBoolean(config.get("secure_cdn_subdomain"), null);
        this.useRootPath = ObjectUtils.asBoolean(config.get("use_root_path"), false);
        this.useFetchFormat = ObjectUtils.asBoolean(config.get("use_fetch_format"), false);
        this.loadStrategies = ObjectUtils.asBoolean(config.get("load_strategies"), true);
        this.timeout = ObjectUtils.asInteger(config.get("timeout"), 0);
        this.clientHints = ObjectUtils.asBoolean(config.get("client_hints"), false);
        this.analytics = ObjectUtils.asBoolean(config.get("analytics"), true);
        Map tokenMap = (Map)config.get("auth_token");
        if (tokenMap != null) {
            this.authToken = new AuthToken(tokenMap);
        }
        this.forceVersion = ObjectUtils.asBoolean(config.get("force_version"), true);
        Map properties = (Map)config.get("properties");
        if (properties != null) {
            this.properties.putAll(properties);
        }
        this.longUrlSignature = ObjectUtils.asBoolean(config.get("long_url_signature"), false);
        this.signatureAlgorithm = SignatureAlgorithm.valueOf(ObjectUtils.asString(config.get(CONFIG_PROP_SIGNATURE_ALGORITHM), DEFAULT_SIGNATURE_ALGORITHM.name()));
        this.signatureVersion = ObjectUtils.asInteger(config.get("signature_version"), 2);
        this.oauthToken = (String)config.get("oauth_token");
    }

    public Map<String, Object> asMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cloud_name", this.cloudName);
        map.put("api_key", this.apiKey);
        map.put("api_secret", this.apiSecret);
        map.put("secure_distribution", this.secureDistribution);
        map.put("cname", this.cname);
        map.put("secure", this.secure);
        map.put("private_cdn", this.privateCdn);
        map.put("cdn_subdomain", this.cdnSubdomain);
        map.put("shorten", this.shorten);
        map.put("upload_prefix", this.uploadPrefix);
        map.put("callback", this.callback);
        map.put("proxy_host", this.proxyHost);
        map.put("proxy_port", this.proxyPort);
        map.put("secure_cdn_subdomain", this.secureCdnSubdomain);
        map.put("use_root_path", this.useRootPath);
        map.put("use_fetch_format", this.useFetchFormat);
        map.put("load_strategies", this.loadStrategies);
        map.put("timeout", this.timeout);
        map.put("client_hints", this.clientHints);
        if (this.authToken != null) {
            map.put("auth_token", this.authToken.asMap());
        }
        map.put("force_version", this.forceVersion);
        map.put("properties", new HashMap<String, Object>(this.properties));
        map.put("long_url_signature", this.longUrlSignature);
        map.put(CONFIG_PROP_SIGNATURE_ALGORITHM, this.signatureAlgorithm.toString());
        map.put("signature_version", this.signatureVersion);
        map.put("oauth_token", this.oauthToken);
        map.put("analytics", this.analytics);
        return map;
    }

    public Configuration(Configuration other) {
        this.cloudName = other.cloudName;
        this.apiKey = other.apiKey;
        this.apiSecret = other.apiSecret;
        this.secureDistribution = other.secureDistribution;
        this.cname = other.cname;
        this.uploadPrefix = other.uploadPrefix;
        this.secure = other.secure;
        this.privateCdn = other.privateCdn;
        this.cdnSubdomain = other.cdnSubdomain;
        this.shorten = other.shorten;
        this.callback = other.callback;
        this.proxyHost = other.proxyHost;
        this.proxyPort = other.proxyPort;
        this.secureCdnSubdomain = other.secureCdnSubdomain;
        this.useRootPath = other.useRootPath;
        this.useFetchFormat = other.useFetchFormat;
        this.timeout = other.timeout;
        this.clientHints = other.clientHints;
        if (other.authToken != null) {
            this.authToken = other.authToken.copy();
        }
        this.forceVersion = other.forceVersion;
        this.loadStrategies = other.loadStrategies;
        this.properties.putAll(other.properties);
        this.longUrlSignature = other.longUrlSignature;
        this.signatureAlgorithm = other.signatureAlgorithm;
        this.signatureVersion = other.signatureVersion;
        this.oauthToken = other.oauthToken;
        this.analytics = other.analytics;
    }

    public static Configuration from(Configuration other) {
        return new Builder().from(other).build();
    }

    public static Configuration from(String cloudinaryUrl) {
        Configuration config = new Configuration();
        config.update(Configuration.parseConfigUrl(cloudinaryUrl));
        return config;
    }

    protected static Map parseConfigUrl(String cloudinaryUrl) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        URI cloudinaryUri = URI.create(cloudinaryUrl);
        if (cloudinaryUri.getScheme() == null || !cloudinaryUri.getScheme().equalsIgnoreCase("cloudinary")) {
            throw new IllegalArgumentException("Invalid CLOUDINARY_URL scheme. Expecting to start with 'cloudinary://'");
        }
        params.put("cloud_name", cloudinaryUri.getHost());
        if (cloudinaryUri.getUserInfo() != null) {
            String[] creds = cloudinaryUri.getUserInfo().split(":");
            params.put("api_key", creds[0]);
            if (creds.length > 1) {
                params.put("api_secret", creds[1]);
            }
        }
        params.put("private_cdn", !StringUtils.isEmpty(cloudinaryUri.getPath()));
        params.put("secure_distribution", cloudinaryUri.getPath());
        Configuration.updateMapfromURI(params, cloudinaryUri);
        return params;
    }

    private static void updateMapfromURI(Map params, URI cloudinaryUri) {
        if (cloudinaryUri.getQuery() != null) {
            for (String param : cloudinaryUri.getQuery().split("&")) {
                String[] keyValue = param.split("=");
                try {
                    String value = URLDecoder.decode(keyValue[1], "ASCII");
                    String key = keyValue[0];
                    if (Configuration.isNestedKey(key)) {
                        Configuration.putNestedValue(params, key, value);
                        continue;
                    }
                    params.put(key, value);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Unexpected exception", e);
                }
            }
        }
    }

    private static void putNestedValue(Map params, String key, String value) {
        String[] chain = key.split("[\\[\\]]+");
        Map outer = params;
        String innerKey = chain[0];
        int i = 0;
        while (i < chain.length - 1) {
            HashMap inner = (HashMap)outer.get(innerKey);
            if (inner == null) {
                inner = new HashMap();
                outer.put(innerKey, inner);
            }
            outer = inner;
            innerKey = chain[++i];
        }
        outer.put(innerKey, value);
    }

    private static boolean isNestedKey(String key) {
        return key.matches("\\w+\\[\\w+\\]");
    }

    public static class Builder {
        private String cloudName;
        private String apiKey;
        private String apiSecret;
        private String secureDistribution;
        private String cname;
        private String uploadPrefix;
        private boolean secure;
        private boolean privateCdn;
        private boolean cdnSubdomain;
        private boolean shorten;
        private String callback;
        private String proxyHost;
        private int proxyPort;
        private Boolean secureCdnSubdomain;
        private boolean useRootPath;
        private boolean useFetchFormat;
        private boolean loadStrategies = true;
        private int timeout;
        private boolean clientHints = false;
        private AuthToken authToken;
        private boolean forceVersion = true;
        private boolean longUrlSignature = false;
        private SignatureAlgorithm signatureAlgorithm = DEFAULT_SIGNATURE_ALGORITHM;
        private int signatureVersion = 2;
        private String oauthToken = null;
        private boolean analytics;

        public Builder setTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Configuration build() {
            Configuration configuration = new Configuration(this.cloudName, this.apiKey, this.apiSecret, this.secureDistribution, this.cname, this.uploadPrefix, this.secure, this.privateCdn, this.cdnSubdomain, this.shorten, this.callback, this.proxyHost, this.proxyPort, this.secureCdnSubdomain, this.useRootPath, this.useFetchFormat, this.timeout, this.loadStrategies, this.forceVersion, this.longUrlSignature, this.signatureAlgorithm, this.signatureVersion, this.oauthToken, this.analytics);
            configuration.clientHints = this.clientHints;
            return configuration;
        }

        public Builder setCloudName(String cloudName) {
            this.cloudName = cloudName;
            return this;
        }

        public Builder setApiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder setApiSecret(String apiSecret) {
            this.apiSecret = apiSecret;
            return this;
        }

        public Builder setSecureDistribution(String secureDistribution) {
            this.secureDistribution = secureDistribution;
            return this;
        }

        public Builder setCname(String cname) {
            this.cname = cname;
            return this;
        }

        public Builder setSecure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public Builder setPrivateCdn(boolean privateCdn) {
            this.privateCdn = privateCdn;
            return this;
        }

        public Builder setSecureCdnSubdomain(Boolean secureCdnSubdomain) {
            this.secureCdnSubdomain = secureCdnSubdomain;
            return this;
        }

        public Builder setCdnSubdomain(boolean cdnSubdomain) {
            this.cdnSubdomain = cdnSubdomain;
            return this;
        }

        public Builder setShorten(boolean shorten) {
            this.shorten = shorten;
            return this;
        }

        public Builder setCallback(String callback) {
            this.callback = callback;
            return this;
        }

        public Builder setUploadPrefix(String uploadPrefix) {
            this.uploadPrefix = uploadPrefix;
            return this;
        }

        public Builder setUseRootPath(boolean useRootPath) {
            this.useRootPath = useRootPath;
            return this;
        }

        public Builder setUseFetchFormat(boolean useFetchFormat) {
            this.useFetchFormat = useFetchFormat;
            return this;
        }

        public Builder setLoadStrategies(boolean loadStrategies) {
            this.loadStrategies = loadStrategies;
            return this;
        }

        public Builder setAnalytics(boolean analytics) {
            this.analytics = analytics;
            return this;
        }

        public Builder setClientHints(boolean clientHints) {
            this.clientHints = clientHints;
            return this;
        }

        public Builder setAuthToken(AuthToken authToken) {
            this.authToken = authToken;
            return this;
        }

        public Builder setForceVersion(boolean forceVersion) {
            this.forceVersion = forceVersion;
            return this;
        }

        public Builder setIsLongUrlSignature(boolean isLong) {
            this.longUrlSignature = isLong;
            return this;
        }

        public Builder setSignatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
            return this;
        }

        public Builder setSignatureVersion(int signatureVersion) {
            this.signatureVersion = signatureVersion;
            return this;
        }

        public Builder setOAuthToken(String oauthToken) {
            this.oauthToken = oauthToken;
            return this;
        }

        public Builder from(Configuration other) {
            this.cloudName = other.cloudName;
            this.apiKey = other.apiKey;
            this.apiSecret = other.apiSecret;
            this.secureDistribution = other.secureDistribution;
            this.cname = other.cname;
            this.uploadPrefix = other.uploadPrefix;
            this.secure = other.secure;
            this.privateCdn = other.privateCdn;
            this.cdnSubdomain = other.cdnSubdomain;
            this.shorten = other.shorten;
            this.callback = other.callback;
            this.proxyHost = other.proxyHost;
            this.proxyPort = other.proxyPort;
            this.secureCdnSubdomain = other.secureCdnSubdomain;
            this.useRootPath = other.useRootPath;
            this.useFetchFormat = other.useFetchFormat;
            this.loadStrategies = other.loadStrategies;
            this.timeout = other.timeout;
            this.clientHints = other.clientHints;
            this.authToken = other.authToken == null ? null : other.authToken.copy();
            this.forceVersion = other.forceVersion;
            this.longUrlSignature = other.longUrlSignature;
            this.signatureAlgorithm = other.signatureAlgorithm;
            this.signatureVersion = other.signatureVersion;
            this.oauthToken = other.oauthToken;
            this.analytics = other.analytics;
            return this;
        }
    }
}

