/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.http42;

import com.cloudinary.Api;
import com.cloudinary.api.ApiResponse;
import com.cloudinary.api.exceptions.GeneralError;
import com.cloudinary.http42.api.Response;
import com.cloudinary.strategies.AbstractApiStrategy;
import com.cloudinary.utils.ObjectUtils;
import com.cloudinary.utils.StringUtils;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.cloudinary.json.JSONException;
import org.cloudinary.json.JSONObject;

public class ApiStrategy
extends AbstractApiStrategy {
    public ApiResponse callApi(Api.HttpMethod method, Iterable<String> uri, Map<String, ? extends Object> params, Map options) throws Exception {
        if (options == null) {
            options = ObjectUtils.emptyMap();
        }
        String prefix = ObjectUtils.asString(options.get("upload_prefix"), (String)ObjectUtils.asString((Object)this.api.cloudinary.config.uploadPrefix, (String)"https://api.cloudinary.com"));
        String cloudName = ObjectUtils.asString(options.get("cloud_name"), (String)this.api.cloudinary.config.cloudName);
        if (cloudName == null) {
            throw new IllegalArgumentException("Must supply cloud_name");
        }
        String apiKey = ObjectUtils.asString(options.get("api_key"), (String)this.api.cloudinary.config.apiKey);
        String apiSecret = ObjectUtils.asString(options.get("api_secret"), (String)this.api.cloudinary.config.apiSecret);
        String oauthToken = ObjectUtils.asString(options.get("oauth_token"), (String)this.api.cloudinary.config.oauthToken);
        String contentType = ObjectUtils.asString(options.get("content_type"), (String)"urlencoded");
        int timeout = ObjectUtils.asInteger(options.get("timeout"), (Integer)this.api.cloudinary.config.timeout);
        this.validateAuthorization(apiKey, apiSecret, oauthToken);
        String apiUrl = this.createApiUrl(uri, prefix, cloudName);
        return this.getApiResponse(method, params, apiKey, apiSecret, oauthToken, contentType, timeout, apiUrl);
    }

    public ApiResponse callAccountApi(Api.HttpMethod method, Iterable<String> uri, Map<String, ?> params, Map options) throws Exception {
        String prefix = ObjectUtils.asString(options.get("upload_prefix"), (String)"https://api.cloudinary.com");
        String apiKey = ObjectUtils.asString(options.get("provisioning_api_key"));
        if (apiKey == null) {
            throw new IllegalArgumentException("Must supply provisioning_api_key");
        }
        String apiSecret = ObjectUtils.asString(options.get("provisioning_api_secret"));
        if (apiSecret == null) {
            throw new IllegalArgumentException("Must supply provisioning_api_secret");
        }
        String contentType = ObjectUtils.asString(options.get("content_type"), (String)"urlencoded");
        int timeout = ObjectUtils.asInteger(options.get("timeout"), (Integer)this.api.cloudinary.config.timeout);
        String apiUrl = StringUtils.join(Arrays.asList(prefix, "v1_1"), (String)"/");
        for (String component : uri) {
            apiUrl = apiUrl + "/" + component;
        }
        return this.getApiResponse(method, params, apiKey, apiSecret, null, contentType, timeout, apiUrl);
    }

    private ApiResponse getApiResponse(Api.HttpMethod method, Map<String, ?> params, String apiKey, String apiSecret, String oauthToken, String contentType, int timeout, String apiUrl) throws Exception {
        Map result;
        URIBuilder apiUrlBuilder = new URIBuilder(apiUrl);
        if (!contentType.equals("json")) {
            for (Map.Entry<String, ?> param : params.entrySet()) {
                if (param.getValue() instanceof Iterable) {
                    for (String single : (Iterable)param.getValue()) {
                        apiUrlBuilder.addParameter(param.getKey() + "[]", single);
                    }
                    continue;
                }
                apiUrlBuilder.addParameter(param.getKey(), ObjectUtils.asString(param.getValue()));
            }
        }
        ClientConnectionManager connectionManager = (ClientConnectionManager)this.api.cloudinary.config.properties.get("connectionManager");
        DefaultHttpClient client = new DefaultHttpClient(connectionManager);
        if (timeout > 0) {
            HttpParams httpParams = client.getParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)timeout);
            HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)timeout);
        }
        URI apiUri = apiUrlBuilder.build();
        HttpGet request = null;
        switch (method) {
            case GET: {
                request = new HttpGet(apiUri);
                break;
            }
            case PUT: {
                request = new HttpPut(apiUri);
                break;
            }
            case POST: {
                request = new HttpPost(apiUri);
                break;
            }
            case DELETE: {
                request = new HttpDelete(apiUri);
            }
        }
        request.setHeader("Authorization", this.getAuthorizationHeaderValue(apiKey, apiSecret, oauthToken));
        request.setHeader("User-Agent", this.api.cloudinary.getUserAgent() + " ApacheHTTPComponents/4.2");
        if (contentType.equals("json")) {
            JSONObject asJSON = ObjectUtils.toJSON(params);
            StringEntity requestEntity = new StringEntity(asJSON.toString(), ContentType.APPLICATION_JSON);
            ((HttpEntityEnclosingRequestBase)request).setEntity((HttpEntity)requestEntity);
        }
        HttpResponse response = client.execute((HttpUriRequest)request);
        int code = response.getStatusLine().getStatusCode();
        InputStream responseStream = response.getEntity().getContent();
        String responseData = StringUtils.read((InputStream)responseStream);
        Class exceptionClass = (Class)Api.CLOUDINARY_API_ERROR_CLASSES.get(code);
        if (code != 200 && exceptionClass == null) {
            throw new GeneralError("Server returned unexpected status code - " + code + " - " + responseData);
        }
        try {
            JSONObject responseJSON = new JSONObject(responseData);
            result = ObjectUtils.toMap((JSONObject)responseJSON);
        }
        catch (JSONException e) {
            throw new RuntimeException("Invalid JSON response from server " + e.getMessage());
        }
        if (code == 200) {
            return new Response(response, result);
        }
        String message = (String)((Map)result.get("error")).get("message");
        Constructor exceptionConstructor = exceptionClass.getConstructor(String.class);
        throw (Exception)exceptionConstructor.newInstance(message);
    }
}

