/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.http42;

import com.cloudinary.ProgressCallback;
import com.cloudinary.Util;
import com.cloudinary.strategies.AbstractUploaderStrategy;
import com.cloudinary.utils.ObjectUtils;
import com.cloudinary.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;

public class UploaderStrategy
extends AbstractUploaderStrategy {
    public Map callApi(String action, Map<String, Object> params, Map options, Object file, ProgressCallback progressCallback) throws IOException {
        if (progressCallback != null) {
            throw new IllegalArgumentException("Progress callback is not supported");
        }
        if (options == null) {
            options = ObjectUtils.emptyMap();
        }
        boolean returnError = ObjectUtils.asBoolean(options.get("return_error"), (Boolean)false);
        if (this.requiresSigning(action, options)) {
            this.uploader.signRequestParams(params, options);
        } else {
            Util.clearEmpty(params);
        }
        String apiUrl = this.buildUploadUrl(action, options);
        ClientConnectionManager connectionManager = (ClientConnectionManager)this.uploader.cloudinary().config.properties.get("connectionManager");
        DefaultHttpClient client = new DefaultHttpClient(connectionManager);
        if (this.uploader.cloudinary().config.proxyHost != null && this.uploader.cloudinary().config.proxyPort != 0) {
            HttpHost proxy = new HttpHost(this.uploader.cloudinary().config.proxyHost, this.uploader.cloudinary().config.proxyPort);
            client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
        }
        HttpPost postMethod = new HttpPost(apiUrl);
        postMethod.setHeader("User-Agent", this.cloudinary().getUserAgent() + " ApacheHTTPComponents/4.2");
        Map extraHeaders = (Map)options.get("extra_headers");
        if (extraHeaders != null) {
            for (Map.Entry header : extraHeaders.entrySet()) {
                postMethod.setHeader((String)header.getKey(), (String)header.getValue());
            }
        }
        Charset utf8 = Charset.forName("UTF-8");
        MultipartEntity multipart = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        for (Map.Entry<String, Object> param : params.entrySet()) {
            if (param.getValue() instanceof Collection) {
                for (Object value : (Collection)param.getValue()) {
                    multipart.addPart(param.getKey() + "[]", (ContentBody)new StringBody(ObjectUtils.asString(value), utf8));
                }
                continue;
            }
            String value = param.getValue().toString();
            if (!StringUtils.isNotBlank((String)value)) continue;
            multipart.addPart(param.getKey(), (ContentBody)new StringBody(value, utf8));
        }
        if (file instanceof String && !StringUtils.isRemoteUrl((String)((String)file))) {
            File _file = new File((String)file);
            if (!_file.isFile() && !_file.canRead()) {
                throw new IOException("File not found or unreadable: " + file);
            }
            file = _file;
        }
        String filename = (String)options.get("filename");
        if (file instanceof File) {
            multipart.addPart("file", (ContentBody)new FileBody((File)file, filename, "application/octet-stream", null));
        } else if (file instanceof String) {
            multipart.addPart("file", (ContentBody)new StringBody((String)file, utf8));
        } else if (file instanceof byte[]) {
            if (filename == null) {
                filename = "file";
            }
            multipart.addPart("file", (ContentBody)new ByteArrayBody((byte[])file, filename));
        } else if (file != null) {
            throw new IOException("Unrecognized file parameter " + file);
        }
        postMethod.setEntity((HttpEntity)multipart);
        HttpResponse response = client.execute((HttpUriRequest)postMethod);
        int code = response.getStatusLine().getStatusCode();
        InputStream responseStream = response.getEntity().getContent();
        String responseData = StringUtils.read((InputStream)responseStream);
        return this.processResponse(returnError, code, responseData);
    }
}

