/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.http43;

import com.cloudinary.Uploader;
import com.cloudinary.Util;
import com.cloudinary.strategies.AbstractUploaderStrategy;
import com.cloudinary.utils.ObjectUtils;
import com.cloudinary.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MIME;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.cloudinary.json.JSONException;
import org.cloudinary.json.JSONObject;

public class UploaderStrategy
extends AbstractUploaderStrategy {
    private CloseableHttpClient client = null;

    public void init(Uploader uploader) {
        HttpClientConnectionManager connectionManager;
        super.init(uploader);
        HttpClientBuilder clientBuilder = HttpClients.custom();
        clientBuilder.useSystemProperties().setUserAgent("CloudinaryJava/1.2.2 Apache HTTP Components/4.3");
        if (this.cloudinary().config.proxyHost != null && this.cloudinary().config.proxyPort != 0) {
            HttpHost proxy = new HttpHost(this.cloudinary().config.proxyHost, this.cloudinary().config.proxyPort);
            clientBuilder.setProxy(proxy);
        }
        if ((connectionManager = (HttpClientConnectionManager)this.cloudinary().config.properties.get("connectionManager")) != null) {
            clientBuilder.setConnectionManager(connectionManager);
        }
        this.client = clientBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map callApi(String action, Map<String, Object> params, Map options, Object file) throws IOException {
        Map result;
        if (options == null) {
            options = ObjectUtils.emptyMap();
        }
        boolean returnError = ObjectUtils.asBoolean(options.get("return_error"), (Boolean)false);
        if (options.get("unsigned") == null || Boolean.FALSE.equals(options.get("unsigned"))) {
            this.uploader.signRequestParams(params, options);
        } else {
            Util.clearEmpty(params);
        }
        String apiUrl = this.uploader.cloudinary().cloudinaryApiUrl(action, options);
        HttpPost postMethod = new HttpPost(apiUrl);
        if (options.get("content_range") != null) {
            postMethod.setHeader("Content-Range", (String)options.get("content_range"));
        }
        MultipartEntityBuilder multipart = MultipartEntityBuilder.create();
        multipart.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        ContentType contentType = ContentType.MULTIPART_FORM_DATA.withCharset(MIME.UTF8_CHARSET);
        for (Map.Entry<String, Object> param : params.entrySet()) {
            if (param.getValue() instanceof Collection) {
                for (Object value : (Collection)param.getValue()) {
                    multipart.addTextBody(param.getKey() + "[]", ObjectUtils.asString(value), contentType);
                }
                continue;
            }
            String value = param.getValue().toString();
            if (!StringUtils.isNotBlank((String)value)) continue;
            multipart.addTextBody(param.getKey(), value, contentType);
        }
        if (file instanceof String && !((String)file).matches("ftp:.*|https?:.*|s3:.*|data:[^;]*;base64,([a-zA-Z0-9/+\n=]+)")) {
            file = new File((String)file);
        }
        String filename = (String)options.get("filename");
        if (file instanceof File) {
            if (filename == null) {
                filename = ((File)file).getName();
            }
            multipart.addBinaryBody("file", (File)file, ContentType.APPLICATION_OCTET_STREAM, filename);
        } else if (file instanceof String) {
            multipart.addTextBody("file", (String)file);
        } else if (file instanceof byte[]) {
            if (filename == null) {
                filename = "file";
            }
            multipart.addBinaryBody("file", (byte[])file, ContentType.APPLICATION_OCTET_STREAM, filename);
        } else if (file != null) {
            throw new IOException("Unrecognized file parameter " + file);
        }
        postMethod.setEntity(multipart.build());
        String responseData = null;
        int code = 0;
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)postMethod);
        try {
            code = response.getStatusLine().getStatusCode();
            InputStream responseStream = response.getEntity().getContent();
            responseData = StringUtils.read((InputStream)responseStream);
        }
        finally {
            response.close();
        }
        if (code != 200 && code != 400 && code != 500) {
            throw new RuntimeException("Server returned unexpected status code - " + code + " - " + responseData);
        }
        try {
            JSONObject responseJSON = new JSONObject(responseData);
            result = ObjectUtils.toMap((JSONObject)responseJSON);
        }
        catch (JSONException e) {
            throw new RuntimeException("Invalid JSON response from server " + e.getMessage());
        }
        if (result.containsKey("error")) {
            Map error = (Map)result.get("error");
            if (returnError) {
                error.put("http_code", code);
            } else {
                throw new RuntimeException((String)error.get("message"));
            }
        }
        return result;
    }
}

