/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.http44;

import com.cloudinary.Api;
import com.cloudinary.api.ApiResponse;
import com.cloudinary.api.exceptions.GeneralError;
import com.cloudinary.http44.ApiUtils;
import com.cloudinary.http44.api.Response;
import com.cloudinary.strategies.AbstractApiStrategy;
import com.cloudinary.utils.Base64Coder;
import com.cloudinary.utils.ObjectUtils;
import com.cloudinary.utils.StringUtils;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.cloudinary.json.JSONException;
import org.cloudinary.json.JSONObject;

public class ApiStrategy
extends AbstractApiStrategy {
    private CloseableHttpClient client = null;

    public void init(Api api) {
        int timeout;
        HttpClientConnectionManager connectionManager;
        super.init(api);
        HttpClientBuilder clientBuilder = HttpClients.custom();
        clientBuilder.useSystemProperties().setUserAgent("CloudinaryJava/1.20.0 ApacheHTTPComponents/4.4");
        if (api.cloudinary.config.proxyHost != null && api.cloudinary.config.proxyPort != 0) {
            HttpHost proxy = new HttpHost(api.cloudinary.config.proxyHost, api.cloudinary.config.proxyPort);
            clientBuilder.setProxy(proxy);
        }
        if ((connectionManager = (HttpClientConnectionManager)api.cloudinary.config.properties.get("connectionManager")) != null) {
            clientBuilder.setConnectionManager(connectionManager);
        }
        if ((timeout = this.api.cloudinary.config.timeout) > 0) {
            RequestConfig config = RequestConfig.custom().setSocketTimeout(timeout * 1000).setConnectTimeout(timeout * 1000).build();
            clientBuilder.setDefaultRequestConfig(config);
        }
        this.client = clientBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiResponse callApi(Api.HttpMethod method, Iterable<String> uri, Map<String, ?> params, Map options) throws Exception {
        Map result;
        if (options == null) {
            options = ObjectUtils.emptyMap();
        }
        String prefix = ObjectUtils.asString(options.get("upload_prefix"), (String)ObjectUtils.asString((Object)this.api.cloudinary.config.uploadPrefix, (String)"https://api.cloudinary.com"));
        String cloudName = ObjectUtils.asString(options.get("cloud_name"), (String)this.api.cloudinary.config.cloudName);
        if (cloudName == null) {
            throw new IllegalArgumentException("Must supply cloud_name");
        }
        String apiKey = ObjectUtils.asString(options.get("api_key"), (String)this.api.cloudinary.config.apiKey);
        if (apiKey == null) {
            throw new IllegalArgumentException("Must supply api_key");
        }
        String apiSecret = ObjectUtils.asString(options.get("api_secret"), (String)this.api.cloudinary.config.apiSecret);
        if (apiSecret == null) {
            throw new IllegalArgumentException("Must supply api_secret");
        }
        String apiUrl = StringUtils.join(Arrays.asList(prefix, "v1_1", cloudName), (String)"/");
        for (String component : uri) {
            apiUrl = apiUrl + "/" + component;
        }
        HttpUriRequest request = this.prepareRequest(method, apiUrl, params, options);
        request.setHeader("Authorization", "Basic " + Base64Coder.encodeString((String)(apiKey + ":" + apiSecret)));
        String responseData = null;
        int code = 0;
        try (CloseableHttpResponse response = this.client.execute(request);){
            code = response.getStatusLine().getStatusCode();
            InputStream responseStream = response.getEntity().getContent();
            responseData = StringUtils.read((InputStream)responseStream);
        }
        Class exceptionClass = (Class)Api.CLOUDINARY_API_ERROR_CLASSES.get(code);
        if (code != 200 && exceptionClass == null) {
            throw new GeneralError("Server returned unexpected status code - " + code + " - " + responseData);
        }
        try {
            JSONObject responseJSON = new JSONObject(responseData);
            result = ObjectUtils.toMap((JSONObject)responseJSON);
        }
        catch (JSONException e) {
            throw new RuntimeException("Invalid JSON response from server " + e.getMessage());
        }
        if (code == 200) {
            return new Response((HttpResponse)response, result);
        }
        String message = (String)((Map)result.get("error")).get("message");
        Constructor exceptionConstructor = exceptionClass.getConstructor(String.class);
        throw (Exception)exceptionConstructor.newInstance(message);
    }

    private HttpUriRequest prepareRequest(Api.HttpMethod method, String apiUrl, Map<String, ?> params, Map options) throws URISyntaxException, UnsupportedEncodingException {
        HttpGet request;
        String contentType = ObjectUtils.asString(options.get("content_type"), (String)"urlencoded");
        URIBuilder apiUrlBuilder = new URIBuilder(apiUrl);
        List<NameValuePair> urlEncodedParams = ApiUtils.prepareParams(params);
        if (method == Api.HttpMethod.GET) {
            apiUrlBuilder.setParameters(ApiUtils.prepareParams(params));
            URI apiUri = apiUrlBuilder.build();
            request = new HttpGet(apiUri);
        } else {
            HashMap paramsCopy = new HashMap(params);
            URI apiUri = apiUrlBuilder.build();
            switch (method) {
                case PUT: {
                    request = new HttpPut(apiUri);
                    break;
                }
                case DELETE: {
                    paramsCopy.put("_method", "delete");
                }
                case POST: {
                    request = new HttpPost(apiUri);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown HTTP method");
                }
            }
            if (contentType.equals("json")) {
                JSONObject asJSON = ObjectUtils.toJSON(paramsCopy);
                StringEntity requestEntity = new StringEntity(asJSON.toString(), ContentType.APPLICATION_JSON);
                ((HttpEntityEnclosingRequestBase)request).setEntity((HttpEntity)requestEntity);
            } else {
                ((HttpEntityEnclosingRequestBase)request).setEntity((HttpEntity)new UrlEncodedFormEntity(ApiUtils.prepareParams(paramsCopy), Consts.UTF_8));
            }
        }
        ApiUtils.setTimeouts((HttpRequestBase)request, options);
        return request;
    }
}

