/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.http44;

import com.cloudinary.Cloudinary;
import com.cloudinary.ProgressCallback;
import com.cloudinary.Uploader;
import com.cloudinary.Util;
import com.cloudinary.http44.ApiUtils;
import com.cloudinary.strategies.AbstractUploaderStrategy;
import com.cloudinary.utils.ObjectUtils;
import com.cloudinary.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MIME;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;

public class UploaderStrategy
extends AbstractUploaderStrategy {
    private CloseableHttpClient client = null;

    public void init(Uploader uploader) {
        HttpClientConnectionManager connectionManager;
        super.init(uploader);
        HttpClientBuilder clientBuilder = HttpClients.custom();
        clientBuilder.useSystemProperties().setUserAgent(Cloudinary.USER_AGENT + " ApacheHTTPComponents/4.4");
        if (this.cloudinary().config.proxyHost != null && this.cloudinary().config.proxyPort != 0) {
            HttpHost proxy = new HttpHost(this.cloudinary().config.proxyHost, this.cloudinary().config.proxyPort);
            clientBuilder.setProxy(proxy);
        }
        if ((connectionManager = (HttpClientConnectionManager)this.cloudinary().config.properties.get("connectionManager")) != null) {
            clientBuilder.setConnectionManager(connectionManager);
        }
        this.client = clientBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map callApi(String action, Map<String, Object> params, Map options, Object file, ProgressCallback progressCallback) throws IOException {
        if (progressCallback != null) {
            throw new IllegalArgumentException("Progress callback is not supported");
        }
        if (options == null) {
            options = ObjectUtils.emptyMap();
        }
        boolean returnError = ObjectUtils.asBoolean(options.get("return_error"), (Boolean)false);
        if (this.requiresSigning(action, options)) {
            this.uploader.signRequestParams(params, options);
        } else {
            Util.clearEmpty(params);
        }
        String apiUrl = this.buildUploadUrl(action, options);
        HttpPost postMethod = new HttpPost(apiUrl);
        ApiUtils.setTimeouts((HttpRequestBase)postMethod, options);
        Map extraHeaders = (Map)options.get("extra_headers");
        if (extraHeaders != null) {
            for (Map.Entry header : extraHeaders.entrySet()) {
                postMethod.setHeader((String)header.getKey(), (String)header.getValue());
            }
        }
        MultipartEntityBuilder multipart = MultipartEntityBuilder.create();
        multipart.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        ContentType contentType = ContentType.MULTIPART_FORM_DATA.withCharset(MIME.UTF8_CHARSET);
        for (Map.Entry<String, Object> param : params.entrySet()) {
            if (param.getValue() instanceof Collection) {
                for (Object value : (Collection)param.getValue()) {
                    multipart.addTextBody(param.getKey() + "[]", ObjectUtils.asString(value), contentType);
                }
                continue;
            }
            String value = param.getValue().toString();
            if (!StringUtils.isNotBlank((String)value)) continue;
            multipart.addTextBody(param.getKey(), value, contentType);
        }
        if (file instanceof String && !StringUtils.isRemoteUrl((String)((String)file))) {
            File _file = new File((String)file);
            if (!_file.isFile() && !_file.canRead()) {
                throw new IOException("File not found or unreadable: " + file);
            }
            file = _file;
        }
        String filename = (String)options.get("filename");
        if (file instanceof File) {
            if (filename == null) {
                filename = ((File)file).getName();
            }
            multipart.addBinaryBody("file", (File)file, ContentType.APPLICATION_OCTET_STREAM, filename);
        } else if (file instanceof String) {
            multipart.addTextBody("file", (String)file, contentType);
        } else if (file instanceof byte[]) {
            if (filename == null) {
                filename = "file";
            }
            multipart.addBinaryBody("file", (byte[])file, ContentType.APPLICATION_OCTET_STREAM, filename);
        } else if (file != null) {
            throw new IOException("Unrecognized file parameter " + file);
        }
        postMethod.setEntity(multipart.build());
        String responseData = null;
        int code = 0;
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)postMethod);
        try {
            code = response.getStatusLine().getStatusCode();
            InputStream responseStream = response.getEntity().getContent();
            responseData = StringUtils.read((InputStream)responseStream);
        }
        finally {
            response.close();
        }
        Map result = this.processResponse(returnError, code, responseData);
        return result;
    }
}

