/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.http44;

import com.cloudinary.Api;
import com.cloudinary.api.ApiResponse;
import com.cloudinary.api.exceptions.GeneralError;
import com.cloudinary.http44.ApiUtils;
import com.cloudinary.http44.api.Response;
import com.cloudinary.strategies.AbstractApiStrategy;
import com.cloudinary.utils.ObjectUtils;
import com.cloudinary.utils.StringUtils;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.cloudinary.json.JSONException;
import org.cloudinary.json.JSONObject;

public class ApiStrategy
extends AbstractApiStrategy {
    private CloseableHttpClient client = null;

    public void init(Api api) {
        int timeout;
        HttpClientConnectionManager connectionManager;
        super.init(api);
        HttpClientBuilder clientBuilder = HttpClients.custom();
        clientBuilder.useSystemProperties().setUserAgent(this.api.cloudinary.getUserAgent() + " ApacheHTTPComponents/4.4");
        if (api.cloudinary.config.proxyHost != null && api.cloudinary.config.proxyPort != 0) {
            HttpHost proxy = new HttpHost(api.cloudinary.config.proxyHost, api.cloudinary.config.proxyPort);
            clientBuilder.setProxy(proxy);
        }
        if ((connectionManager = (HttpClientConnectionManager)api.cloudinary.config.properties.get("connectionManager")) != null) {
            clientBuilder.setConnectionManager(connectionManager);
        }
        if ((timeout = this.api.cloudinary.config.timeout) > 0) {
            RequestConfig config = RequestConfig.custom().setSocketTimeout(timeout * 1000).setConnectTimeout(timeout * 1000).build();
            clientBuilder.setDefaultRequestConfig(config);
        }
        this.client = clientBuilder.build();
    }

    public ApiResponse callApi(Api.HttpMethod method, Iterable<String> uri, Map<String, ?> params, Map options) throws Exception {
        if (options == null) {
            options = ObjectUtils.emptyMap();
        }
        String prefix = ObjectUtils.asString(options.get("upload_prefix"), (String)ObjectUtils.asString((Object)this.api.cloudinary.config.uploadPrefix, (String)"https://api.cloudinary.com"));
        String cloudName = ObjectUtils.asString(options.get("cloud_name"), (String)this.api.cloudinary.config.cloudName);
        if (cloudName == null) {
            throw new IllegalArgumentException("Must supply cloud_name");
        }
        String apiKey = ObjectUtils.asString(options.get("api_key"), (String)this.api.cloudinary.config.apiKey);
        String apiSecret = ObjectUtils.asString(options.get("api_secret"), (String)this.api.cloudinary.config.apiSecret);
        String oauthToken = ObjectUtils.asString(options.get("oauth_token"), (String)this.api.cloudinary.config.oauthToken);
        this.validateAuthorization(apiKey, apiSecret, oauthToken);
        String apiUrl = this.createApiUrl(uri, prefix, cloudName);
        HttpUriRequest request = this.prepareRequest(method, apiUrl, params, options);
        request.setHeader("Authorization", this.getAuthorizationHeaderValue(apiKey, apiSecret, oauthToken));
        return this.getApiResponse(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApiResponse getApiResponse(HttpUriRequest request) throws Exception {
        Map result;
        String responseData = null;
        int code = 0;
        try (CloseableHttpResponse response = this.client.execute(request);){
            code = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            responseData = StringUtils.read((InputStream)entity.getContent());
            EntityUtils.consume((HttpEntity)entity);
        }
        Class exceptionClass = (Class)Api.CLOUDINARY_API_ERROR_CLASSES.get(code);
        if (code != 200 && exceptionClass == null) {
            throw new GeneralError("Server returned unexpected status code - " + code + " - " + responseData);
        }
        try {
            JSONObject responseJSON = new JSONObject(responseData);
            result = ObjectUtils.toMap((JSONObject)responseJSON);
        }
        catch (JSONException e) {
            throw new RuntimeException("Invalid JSON response from server " + e.getMessage());
        }
        if (code == 200) {
            return new Response((HttpResponse)response, result);
        }
        String message = (String)((Map)result.get("error")).get("message");
        Constructor exceptionConstructor = exceptionClass.getConstructor(String.class);
        throw (Exception)exceptionConstructor.newInstance(message);
    }

    public ApiResponse callAccountApi(Api.HttpMethod method, Iterable<String> uri, Map<String, ?> params, Map options) throws Exception {
        if (options == null) {
            options = ObjectUtils.emptyMap();
        }
        String prefix = ObjectUtils.asString(options.get("upload_prefix"), (String)"https://api.cloudinary.com");
        String apiKey = ObjectUtils.asString(options.get("provisioning_api_key"));
        if (apiKey == null) {
            throw new IllegalArgumentException("Must supply provisioning_api_key");
        }
        String apiSecret = ObjectUtils.asString(options.get("provisioning_api_secret"));
        if (apiSecret == null) {
            throw new IllegalArgumentException("Must supply provisioning_api_secret");
        }
        String apiUrl = StringUtils.join(Arrays.asList(prefix, "v1_1"), (String)"/");
        for (String component : uri) {
            apiUrl = apiUrl + "/" + component;
        }
        HttpUriRequest request = this.prepareRequest(method, apiUrl, params, options);
        request.setHeader("Authorization", this.getAuthorizationHeaderValue(apiKey, apiSecret, null));
        return this.getApiResponse(request);
    }

    private HttpUriRequest prepareRequest(Api.HttpMethod method, String apiUrl, Map<String, ?> params, Map options) throws URISyntaxException, UnsupportedEncodingException {
        HttpGet request;
        String contentType = ObjectUtils.asString(options.get("content_type"), (String)"urlencoded");
        URIBuilder apiUrlBuilder = new URIBuilder(apiUrl);
        List<NameValuePair> urlEncodedParams = ApiUtils.prepareParams(params);
        if (method == Api.HttpMethod.GET) {
            apiUrlBuilder.setParameters(ApiUtils.prepareParams(params));
            URI apiUri = apiUrlBuilder.build();
            request = new HttpGet(apiUri);
        } else {
            HashMap paramsCopy = new HashMap(params);
            URI apiUri = apiUrlBuilder.build();
            switch (method) {
                case PUT: {
                    request = new HttpPut(apiUri);
                    break;
                }
                case DELETE: {
                    paramsCopy.put("_method", "delete");
                }
                case POST: {
                    request = new HttpPost(apiUri);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown HTTP method");
                }
            }
            if (contentType.equals("json")) {
                JSONObject asJSON = ObjectUtils.toJSON(paramsCopy);
                StringEntity requestEntity = new StringEntity(asJSON.toString(), ContentType.APPLICATION_JSON);
                ((HttpEntityEnclosingRequestBase)request).setEntity((HttpEntity)requestEntity);
            } else {
                ((HttpEntityEnclosingRequestBase)request).setEntity((HttpEntity)new UrlEncodedFormEntity(ApiUtils.prepareParams(paramsCopy), Consts.UTF_8));
            }
        }
        ApiUtils.setTimeouts((HttpRequestBase)request, options);
        return request;
    }
}

