/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.http5;

import com.cloudinary.Api;
import com.cloudinary.api.ApiResponse;
import com.cloudinary.api.exceptions.GeneralError;
import com.cloudinary.http5.ApiUtils;
import com.cloudinary.http5.api.Response;
import com.cloudinary.strategies.AbstractApiStrategy;
import com.cloudinary.utils.ObjectUtils;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.util.Timeout;
import org.cloudinary.json.JSONException;
import org.cloudinary.json.JSONObject;

public class ApiStrategy
extends AbstractApiStrategy {
    private static final String APACHE_HTTP_CLIENT_VERSION = System.getProperty("apache.http.client.version", "5.3.1");
    private CloseableHttpClient client;

    public void init(Api api) {
        super.init(api);
        HttpClientBuilder clientBuilder = HttpClients.custom();
        clientBuilder.useSystemProperties().setUserAgent(this.api.cloudinary.getUserAgent() + " ApacheHttpClient/" + APACHE_HTTP_CLIENT_VERSION);
        HttpClientConnectionManager connectionManager = (HttpClientConnectionManager)api.cloudinary.config.properties.get("connectionManager");
        if (connectionManager != null) {
            clientBuilder.setConnectionManager(connectionManager);
        }
        RequestConfig requestConfig = this.buildRequestConfig();
        this.client = clientBuilder.setDefaultRequestConfig(requestConfig).build();
    }

    public RequestConfig buildRequestConfig() {
        int timeout;
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        if (this.api.cloudinary.config.proxyHost != null && this.api.cloudinary.config.proxyPort != 0) {
            HttpHost proxy = new HttpHost(this.api.cloudinary.config.proxyHost, this.api.cloudinary.config.proxyPort);
            requestConfigBuilder.setProxy(proxy);
        }
        if ((timeout = this.api.cloudinary.config.timeout) > 0) {
            requestConfigBuilder.setResponseTimeout(Timeout.ofSeconds((long)timeout)).setConnectionRequestTimeout(Timeout.ofSeconds((long)timeout)).setConnectTimeout(Timeout.ofSeconds((long)timeout));
        }
        return requestConfigBuilder.build();
    }

    public ApiResponse callApi(Api.HttpMethod method, String apiUrl, Map<String, ?> params, Map options, String autorizationHeader) throws Exception {
        HttpUriRequestBase request = this.prepareRequest(method, apiUrl, params, options);
        request.setHeader("Authorization", (Object)autorizationHeader);
        return this.getApiResponse(request);
    }

    private ApiResponse getApiResponse(HttpUriRequestBase request) throws Exception {
        Map result;
        CloseableHttpResponse response;
        String responseData = null;
        int code = 0;
        try {
            response = this.client.execute((ClassicHttpRequest)request);
            code = response.getCode();
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                responseData = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            throw new GeneralError("Error executing request: " + e.getMessage());
        }
        if (code != 200) {
            try {
                JSONObject responseJSON = new JSONObject(responseData);
                result = ObjectUtils.toMap((JSONObject)responseJSON);
            }
            catch (JSONException e) {
                throw new RuntimeException("Invalid JSON response from server " + e.getMessage());
            }
            String message = (String)((Map)result.get("error")).get("message");
            Class exceptionClass = (Class)Api.CLOUDINARY_API_ERROR_CLASSES.get(code);
            if (exceptionClass != null) {
                Constructor exceptionConstructor = exceptionClass.getConstructor(String.class);
                throw (Exception)exceptionConstructor.newInstance(message);
            }
            throw new GeneralError("Server returned unexpected status code - " + code + " - " + responseData);
        }
        try {
            JSONObject responseJSON = new JSONObject(responseData);
            result = ObjectUtils.toMap((JSONObject)responseJSON);
        }
        catch (JSONException e) {
            throw new RuntimeException("Invalid JSON response from server " + e.getMessage());
        }
        return new Response((HttpResponse)response, result);
    }

    public ApiResponse callAccountApi(Api.HttpMethod method, String apiUrl, Map<String, ?> params, Map options, String authorizationHeader) throws Exception {
        HttpUriRequestBase request = this.prepareRequest(method, apiUrl, params, options);
        request.setHeader("Authorization", (Object)authorizationHeader);
        return this.getApiResponse(request);
    }

    private HttpUriRequestBase prepareRequest(Api.HttpMethod method, String apiUrl, Map<String, ? extends Object> params, Map<String, ?> options) throws URISyntaxException {
        HttpPost request;
        String contentType = ObjectUtils.asString(options.get("content_type"), (String)"urlencoded");
        switch (method) {
            case GET: {
                URIBuilder uriBuilder = new URIBuilder(apiUrl);
                for (NameValuePair param : ApiUtils.prepareParams(params)) {
                    uriBuilder.addParameter(param.getName(), param.getValue());
                }
                request = new HttpGet(uriBuilder.toString());
                break;
            }
            case POST: {
                request = new HttpPost(apiUrl);
                this.setEntity((HttpUriRequestBase)request, params, contentType);
                break;
            }
            case PUT: {
                request = new HttpPut(apiUrl);
                this.setEntity((HttpUriRequestBase)request, params, contentType);
                break;
            }
            case DELETE: {
                request = new HttpDelete(apiUrl);
                this.setEntity((HttpUriRequestBase)request, params, contentType);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown HTTP method");
            }
        }
        ApiUtils.setTimeouts((HttpUriRequestBase)request, options);
        return request;
    }

    private void setEntity(HttpUriRequestBase request, Map<String, ?> params, String contentType) {
        if ("json".equals(contentType)) {
            JSONObject json = ObjectUtils.toJSON(params);
            StringEntity entity = new StringEntity(json.toString(), StandardCharsets.UTF_8);
            request.setEntity((HttpEntity)entity);
            request.setHeader("Content-Type", (Object)"application/json");
        } else {
            List<NameValuePair> formParams = ApiUtils.prepareParams(params);
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(formParams, StandardCharsets.UTF_8));
        }
    }
}

