/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.http5;

import com.cloudinary.ProgressCallback;
import com.cloudinary.Uploader;
import com.cloudinary.Util;
import com.cloudinary.strategies.AbstractUploaderStrategy;
import com.cloudinary.utils.ObjectUtils;
import com.cloudinary.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.mime.ByteArrayBody;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.FileBody;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.util.Timeout;

public class UploaderStrategy
extends AbstractUploaderStrategy {
    private static final String APACHE_HTTP_CLIENT_VERSION = System.getProperty("apache.http.client.version", "5.3.1");
    private CloseableHttpClient client;

    public void init(Uploader uploader) {
        super.init(uploader);
        HttpClientBuilder clientBuilder = HttpClients.custom();
        clientBuilder.useSystemProperties().setUserAgent(this.cloudinary().getUserAgent() + " ApacheHttpClient/" + APACHE_HTTP_CLIENT_VERSION);
        HttpClientConnectionManager connectionManager = (HttpClientConnectionManager)this.cloudinary().config.properties.get("connectionManager");
        if (connectionManager != null) {
            clientBuilder.setConnectionManager(connectionManager);
        }
        RequestConfig requestConfig = this.buildRequestConfig();
        this.client = clientBuilder.setDefaultRequestConfig(requestConfig).build();
    }

    public RequestConfig buildRequestConfig() {
        int timeout;
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        if (this.cloudinary().config.proxyHost != null && this.cloudinary().config.proxyPort != 0) {
            HttpHost proxy = new HttpHost(this.cloudinary().config.proxyHost, this.cloudinary().config.proxyPort);
            requestConfigBuilder.setProxy(proxy);
        }
        if ((timeout = this.cloudinary().config.timeout) > 0) {
            requestConfigBuilder.setResponseTimeout(Timeout.ofSeconds((long)timeout)).setConnectionRequestTimeout(Timeout.ofSeconds((long)timeout)).setConnectTimeout(Timeout.ofSeconds((long)timeout));
        }
        return requestConfigBuilder.build();
    }

    public Map callApi(String action, Map<String, Object> params, Map options, Object file, ProgressCallback progressCallback) throws IOException {
        String responseData;
        int code;
        if (progressCallback != null) {
            throw new IllegalArgumentException("Progress callback is not supported");
        }
        if (options == null) {
            options = ObjectUtils.emptyMap();
        }
        boolean returnError = ObjectUtils.asBoolean(options.get("return_error"), (Boolean)false);
        if (this.requiresSigning(action, options)) {
            this.uploader.signRequestParams(params, options);
        } else {
            Util.clearEmpty(params);
        }
        String apiUrl = this.buildUploadUrl(action, options);
        HttpUriRequestBase request = this.prepareRequest(apiUrl, params, options, file);
        try (CloseableHttpResponse response = this.client.execute((ClassicHttpRequest)request);){
            code = response.getCode();
            responseData = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return this.processResponse(returnError, code, responseData);
    }

    private HttpUriRequestBase prepareRequest(String apiUrl, Map<String, Object> params, Map<String, ?> options, Object file) throws IOException {
        HttpPost request = new HttpPost(apiUrl);
        MultipartEntityBuilder multipartBuilder = MultipartEntityBuilder.create().setCharset(StandardCharsets.UTF_8).setMode(HttpMultipartMode.LEGACY);
        for (Map.Entry<String, Object> param : params.entrySet()) {
            if (param.getValue() instanceof Collection) {
                for (Object value : (Collection)param.getValue()) {
                    multipartBuilder.addTextBody(param.getKey() + "[]", ObjectUtils.asString(value), ContentType.TEXT_PLAIN.withCharset(StandardCharsets.UTF_8));
                }
                continue;
            }
            String value = param.getValue().toString();
            if (!StringUtils.isNotBlank((String)value)) continue;
            multipartBuilder.addTextBody(param.getKey(), value, ContentType.TEXT_PLAIN.withCharset(StandardCharsets.UTF_8));
        }
        this.addFilePart(multipartBuilder, file, options);
        request.setEntity(multipartBuilder.build());
        Map extraHeaders = (Map)options.get("extra_headers");
        if (extraHeaders != null) {
            for (Map.Entry header : extraHeaders.entrySet()) {
                request.addHeader((String)header.getKey(), header.getValue());
            }
        }
        return request;
    }

    private void addFilePart(MultipartEntityBuilder multipartBuilder, Object file, Map<String, ?> options) throws IOException {
        String filename = (String)options.get("filename");
        if (file instanceof String && !StringUtils.isRemoteUrl((String)((String)file))) {
            File _file = new File((String)file);
            if (!_file.isFile() || !_file.canRead()) {
                throw new IOException("File not found or unreadable: " + file);
            }
            file = _file;
        }
        if (file instanceof File) {
            if (filename == null) {
                filename = ((File)file).getName();
            }
            filename = new String(filename.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8);
            FileBody fileBody = new FileBody((File)file, ContentType.APPLICATION_OCTET_STREAM, filename);
            multipartBuilder.addPart("file", (ContentBody)fileBody);
        } else if (file instanceof String) {
            multipartBuilder.addTextBody("file", (String)file, ContentType.TEXT_PLAIN);
        } else if (file instanceof byte[]) {
            if (filename == null) {
                filename = "file";
            }
            ByteArrayBody byteArrayBody = new ByteArrayBody((byte[])file, ContentType.APPLICATION_OCTET_STREAM, filename);
            multipartBuilder.addPart("file", (ContentBody)byteArrayBody);
        } else if (file != null) {
            throw new IOException("Unrecognized file parameter " + file);
        }
    }
}

