/*
 * Decompiled with CFR 0.152.
 */
package com.cloudipsp.android;

import android.os.Parcel;
import android.os.Parcelable;
import com.cloudipsp.android.CvvUtils;
import java.util.Calendar;

public final class Card
implements Parcelable {
    public static final Parcelable.Creator<Card> CREATOR = new Parcelable.Creator<Card>(){

        public Card createFromParcel(Parcel input) {
            return new Card(input);
        }

        public Card[] newArray(int size) {
            return new Card[size];
        }
    };
    static final int INVALID_VALUE = -1;
    public static final int SOURCE_FORM = 0;
    public static final int SOURCE_NFC = 1;
    String cardNumber;
    int mm;
    int yy;
    String cvv;
    public final int source;

    Card(String cardNumber, String expireMm, String expireYy, String cvv) {
        this(cardNumber, expireMm, expireYy, cvv, 0);
    }

    Card(String cardNumber, String expireMm, String expireYy, String cvv, int source) {
        this.setCardNumber(cardNumber);
        this.setExpireMonth(expireMm);
        this.setExpireYear(expireYy);
        this.setCvv(cvv);
        this.source = source;
    }

    private Card(Parcel input) {
        this.cardNumber = input.readString();
        this.mm = input.readInt();
        this.yy = input.readInt();
        this.cvv = input.readString();
        this.source = input.readInt();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel output, int flags) {
        output.writeString(this.cardNumber);
        output.writeInt(this.mm);
        output.writeInt(this.yy);
        output.writeString(this.cvv);
        output.writeInt(this.source);
    }

    public void setCvv(String value) {
        this.cvv = value;
    }

    public void setExpireMonth(String value) {
        try {
            this.mm = Integer.valueOf(value);
        }
        catch (Exception e) {
            this.mm = -1;
        }
    }

    public void setExpireYear(String value) {
        try {
            this.yy = Integer.valueOf(value);
        }
        catch (Exception e) {
            this.yy = -1;
        }
    }

    public void setCardNumber(String value) {
        this.cardNumber = value;
    }

    public boolean isValidExpireMonth() {
        return this.mm >= 1 && this.mm <= 12;
    }

    private boolean isValidExpireYearValue() {
        return this.yy >= 21 && this.yy <= 99;
    }

    public boolean isValidExpireYear() {
        if (!this.isValidExpireYearValue()) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1) - 2000;
        return year <= this.yy;
    }

    public boolean isValidExpireDate() {
        if (!this.isValidExpireMonth()) {
            return false;
        }
        if (!this.isValidExpireYear()) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1) - 2000;
        return this.yy > year || this.yy >= year && this.mm >= calendar.get(2) + 1;
    }

    public boolean isValidCvv() {
        if (this.source == 0) {
            if (this.cvv == null) {
                return false;
            }
            int length = this.cvv.length();
            if (CvvUtils.isCvv4Length(this.cardNumber)) {
                return length == 4;
            }
            return length == 3;
        }
        return true;
    }

    private static boolean lunaCheck(String cardNumber) {
        char[] cardChars = cardNumber.toCharArray();
        int sum = 0;
        boolean odd = true;
        for (int i = cardChars.length - 1; i >= 0; --i) {
            char a = cardChars[i];
            if ('0' > a || a > '9') {
                return false;
            }
            int num = a - 48;
            boolean bl = odd = !odd;
            if (odd) {
                num *= 2;
            }
            if (num > 9) {
                num -= 9;
            }
            sum += num;
        }
        return sum % 10 == 0;
    }

    public boolean isValidCardNumber() {
        if (this.cardNumber == null) {
            return false;
        }
        int length = this.cardNumber.length();
        if (12 > length || length > 19) {
            return false;
        }
        return Card.lunaCheck(this.cardNumber);
    }

    public boolean isValidCard() {
        return this.isValidExpireDate() && this.isValidCvv() && this.isValidCardNumber();
    }

    public Type getType() {
        if (!this.isValidCardNumber()) {
            throw new IllegalStateException("CardNumber should be valid before for getType");
        }
        return Type.fromCardNumber(this.cardNumber);
    }

    public static enum Type {
        VISA{

            @Override
            protected boolean is(String cardNumber) {
                return cardNumber.charAt(0) == '4';
            }
        }
        ,
        MASTERCARD{

            @Override
            protected boolean is(String cardNumber) {
                if (cardNumber.charAt(0) != '5') {
                    return false;
                }
                char a = cardNumber.charAt(1);
                return '0' <= a && a <= '5';
            }
        }
        ,
        MAESTRO{

            @Override
            protected boolean is(String cardNumber) {
                return cardNumber.charAt(0) == '6';
            }
        }
        ,
        UNKNOWN{

            @Override
            protected boolean is(String cardNumber) {
                return true;
            }
        };


        protected abstract boolean is(String var1);

        private static Type fromCardNumber(String cardNumber) {
            for (Type type : Type.values()) {
                if (!type.is(cardNumber)) continue;
                return type;
            }
            return null;
        }
    }
}

