/*
 * Decompiled with CFR 0.152.
 */
package com.cloudipsp.android;

import android.content.Context;
import android.os.Parcelable;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.cloudipsp.android.BaseConfirmationErrorHandler;
import com.cloudipsp.android.Card;
import com.cloudipsp.android.CardCvvEdit;
import com.cloudipsp.android.CardDisplay;
import com.cloudipsp.android.CardExpMmEdit;
import com.cloudipsp.android.CardExpYyEdit;
import com.cloudipsp.android.CardInputBase;
import com.cloudipsp.android.CardNumberEdit;
import com.cloudipsp.android.CvvUtils;
import com.cloudipsp.android.R;
import java.util.ArrayList;

public final class CardInputLayout
extends FrameLayout
implements CardDisplay {
    private CardNumberEdit editCardNumber;
    private CardExpMmEdit editMm;
    private CardExpYyEdit editYy;
    CardCvvEdit editCvv;
    private Card displayedCard;

    public CardInputLayout(Context context) {
        super(context);
    }

    public CardInputLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CardInputLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.editCardNumber = this.findOne(CardNumberEdit.class);
        this.editMm = this.findOne(CardExpMmEdit.class);
        this.editYy = this.findOne(CardExpYyEdit.class);
        this.editCvv = this.findOne(CardCvvEdit.class);
        this.editCardNumber.addTextChangedListenerInternal(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                CardInputLayout.this.editCvv.setCvv4(CvvUtils.isCvv4Length(s.toString()));
            }
        });
    }

    protected void dispatchSaveInstanceState(SparseArray<Parcelable> container) {
        this.setRealIds();
        super.dispatchSaveInstanceState(container);
        this.setFakeIds();
    }

    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        this.setRealIds();
        super.dispatchRestoreInstanceState(container);
        this.setFakeIds();
    }

    public void setCardNumberFormatting(boolean enable) {
        this.editCardNumber.setCardNumberFormatting(enable);
    }

    @Override
    public void display(Card card) {
        boolean enabled = true;
        if (card == null) {
            this.editCardNumber.setTextInternal("");
            this.editMm.setTextInternal("");
            this.editYy.setTextInternal("");
            this.editCvv.setTextInternal("");
            this.displayedCard = null;
        } else if (card.source == 1) {
            enabled = false;
            this.editCardNumber.setTextInternal(CardInputLayout.formattedCardNumber(card.cardNumber));
            this.editMm.setTextInternal(String.valueOf(card.mm));
            this.editYy.setTextInternal(String.valueOf(card.yy));
            this.editCvv.setTextInternal("");
            this.displayedCard = card;
        }
        this.editCardNumber.setEnabled(enabled);
        this.editMm.setEnabled(enabled);
        this.editYy.setEnabled(enabled);
        this.editCvv.setEnabled(enabled);
    }

    static String formattedCardNumber(String cardNumber) {
        String masked = cardNumber.substring(0, 4) + " " + cardNumber.substring(4, 6);
        masked = masked + "** **** ";
        masked = masked + cardNumber.substring(12, 16);
        return masked;
    }

    void setHelpCard(String card, String expMm, String expYy, String cvv) {
        this.editCardNumber.setTextInternal(card);
        this.editMm.setTextInternal(expMm);
        this.editYy.setTextInternal(expYy);
        this.editCvv.setTextInternal(cvv);
        this.editCardNumber.setEnabled(true);
        this.editMm.setEnabled(true);
        this.editYy.setEnabled(true);
        this.editCvv.setEnabled(true);
    }

    public Card confirm(ConfirmationErrorHandler handler) {
        if (this.displayedCard != null) {
            return null;
        }
        handler.onCardInputErrorClear(this, this.editCardNumber);
        handler.onCardInputErrorClear(this, this.editMm);
        handler.onCardInputErrorClear(this, this.editYy);
        handler.onCardInputErrorClear(this, this.editCvv);
        Card card = new Card(this.editCardNumber.getTextInternal().toString(), this.editMm.getTextInternal().toString(), this.editYy.getTextInternal().toString(), this.editCvv.getTextInternal().toString());
        if (!card.isValidCardNumber()) {
            handler.onCardInputErrorCatched(this, this.editCardNumber, this.getContext().getString(R.string.e_invalid_card_number));
        } else if (!card.isValidExpireMonth()) {
            handler.onCardInputErrorCatched(this, this.editMm, this.getContext().getString(R.string.e_invalid_mm));
        } else if (!card.isValidExpireYear()) {
            handler.onCardInputErrorCatched(this, this.editYy, this.getContext().getString(R.string.e_invalid_yy));
        } else if (!card.isValidExpireDate()) {
            handler.onCardInputErrorCatched(this, this.editYy, this.getContext().getString(R.string.e_invalid_date));
        } else if (!card.isValidCvv()) {
            handler.onCardInputErrorCatched(this, this.editCvv, this.getContext().getString(R.string.e_invalid_cvv));
        } else {
            return card;
        }
        return null;
    }

    private void setFakeIds() {
        if (this.editCardNumber == null) {
            return;
        }
        this.editCardNumber.setId(-1);
        this.editMm.setId(-1);
        this.editYy.setId(-1);
        this.editCvv.setId(-1);
    }

    private void setRealIds() {
        if (this.editCardNumber == null) {
            return;
        }
        this.editCardNumber.setId(R.id.edit_card_number);
        this.editMm.setId(R.id.edit_mm);
        this.editYy.setId(R.id.edit_yy);
        this.editCvv.setId(R.id.edit_cvv);
    }

    private <V extends CardInputBase> V findOne(Class<V> clazz) {
        ArrayList views = new ArrayList();
        CardInputLayout.find(clazz, (ViewGroup)this, views);
        int count = views.size();
        if (count == 0) {
            throw new RuntimeException(this.getClass().getName() + " should contains " + clazz.getName());
        }
        if (count > 1) {
            throw new RuntimeException(this.getClass().getName() + " should contains only one view " + clazz.getName() + ". Now here " + count + " instances of " + clazz.getName() + ".");
        }
        return (V)((Object)((CardInputBase)((Object)views.get(0))));
    }

    private static <V extends CardInputBase> void find(Class<V> clazz, ViewGroup parent, ArrayList<V> out) {
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            if (child instanceof ViewGroup) {
                CardInputLayout.find(clazz, (ViewGroup)child, out);
                continue;
            }
            if (!child.getClass().equals(clazz)) continue;
            out.add((V)((Object)((CardInputBase)child)));
        }
    }

    public static interface ConfirmationErrorHandler
    extends BaseConfirmationErrorHandler<CardInputLayout> {
    }
}

