/*
 * Decompiled with CFR 0.152.
 */
package com.cloudipsp.android;

import android.content.Context;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.cloudipsp.android.BaseConfirmationErrorHandler;
import com.cloudipsp.android.Card;
import com.cloudipsp.android.CardDisplay;
import com.cloudipsp.android.CardInputLayout;
import com.cloudipsp.android.R;

public final class CardInputView
extends FrameLayout
implements CardDisplay {
    private static final ConfirmationErrorHandler DEFAULT_CONFIRMATION_ERROR_HANDLER = new ConfirmationErrorHandler(){

        @Override
        public void onCardInputErrorClear(CardInputView view, EditText editText) {
            editText.setError(null);
        }

        @Override
        public void onCardInputErrorCatched(CardInputView view, EditText editText, String error) {
            editText.setError((CharSequence)error);
            editText.requestFocus();
        }
    };
    private static final String[] HELP_CARDS = new String[]{"4444555566661111", "4444111166665555", "4444555511116666", "4444111155556666"};
    private final CardInputLayout view;
    private CompletionListener completionListener;
    private int currentHelpCard = 0;
    private boolean helpedNeeded = false;

    public CardInputView(Context context) {
        this(context, null);
    }

    public CardInputView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CardInputView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.view = (CardInputLayout)LayoutInflater.from((Context)context).inflate(R.layout.com_cloudipsp_android_card_input_view, null);
        this.view.findViewById(R.id.btn_help_next_card).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CardInputView.this.nextHelpCard();
            }
        });
        this.addView((View)this.view);
        this.setCompletionListener(null);
    }

    public void setCompletionListener(CompletionListener listener) {
        this.setCompletionListener(listener, 6);
    }

    public void setCompletionListener(final CompletionListener listener, final int lastViewImeOptions) {
        this.completionListener = listener;
        this.view.editCvv.setImeOptions(lastViewImeOptions);
        if (this.completionListener != null) {
            this.view.editCvv.setOnEditorActionListener(new TextView.OnEditorActionListener(){

                public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                    if (lastViewImeOptions == actionId) {
                        listener.onCompleted(CardInputView.this);
                        return true;
                    }
                    return false;
                }
            });
        }
    }

    private void nextHelpCard() {
        if (this.helpedNeeded) {
            this.currentHelpCard %= HELP_CARDS.length;
            this.view.setHelpCard(HELP_CARDS[this.currentHelpCard++], "12", "29", "111");
        }
    }

    public void setHelpedNeeded(boolean value) {
        this.helpedNeeded = value;
    }

    public void setCardNumberFormatting(boolean enable) {
        this.view.setCardNumberFormatting(enable);
    }

    public boolean isHelpedNeeded() {
        return this.helpedNeeded;
    }

    @Override
    public void display(Card card) {
        this.view.display(card);
    }

    public Card confirm() {
        return this.confirm(DEFAULT_CONFIRMATION_ERROR_HANDLER);
    }

    public Card confirm(final ConfirmationErrorHandler handler) {
        return this.view.confirm(new CardInputLayout.ConfirmationErrorHandler(){

            @Override
            public void onCardInputErrorClear(CardInputLayout view, EditText editText) {
                handler.onCardInputErrorClear(CardInputView.this, editText);
            }

            @Override
            public void onCardInputErrorCatched(CardInputLayout view, EditText editText, String error) {
                handler.onCardInputErrorCatched(CardInputView.this, editText, error);
            }
        });
    }

    public static interface CompletionListener {
        public void onCompleted(CardInputView var1);
    }

    public static interface ConfirmationErrorHandler
    extends BaseConfirmationErrorHandler<CardInputView> {
    }
}

