/*
 * Decompiled with CFR 0.152.
 */
package com.cloudipsp.android;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.text.style.ReplacementSpan;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import com.cloudipsp.android.CardInputBase;

public final class CardNumberEdit
extends CardInputBase {
    private static final int MIN_NUMBER_LENGTH = 16;
    private static final int MAX_NUMBER_LENGTH = 19;
    private CreditCardFormatTextWatcher formatTextWatcher;

    public CardNumberEdit(Context context) {
        super(context);
        this.init();
    }

    public CardNumberEdit(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public CardNumberEdit(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setRawInputType(2);
        this.setCardNumberFormatting(true);
        this.setFiltersInternal(new InputFilter[]{new InputFilter.LengthFilter(19)});
        this.setSingleLine();
    }

    @Override
    protected CharSequence getMaskedValue() {
        CharSequence cardNumber = this.getTextInternal();
        int length = cardNumber.length();
        if (length >= 16) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < 6) {
                sb.append(cardNumber.charAt(i++));
            }
            int tail = length - 4;
            while (i++ < tail) {
                sb.append('*');
            }
            while (i < length) {
                sb.append(cardNumber.charAt(i++));
            }
            return sb.toString();
        }
        return "";
    }

    public void setCardNumberFormatting(boolean enable) {
        if (enable) {
            if (this.formatTextWatcher == null) {
                this.formatTextWatcher = new CreditCardFormatTextWatcher(10, 19);
            }
            this.removeTextChangedListener(this.formatTextWatcher);
            this.addTextChangedListenerInternal(this.formatTextWatcher);
        } else if (this.formatTextWatcher != null) {
            this.removeTextChangedListener(this.formatTextWatcher);
        }
    }

    private static class CreditCardFormatTextWatcher
    implements TextWatcher {
        private final int maxLength;
        private final int paddingPx;
        private boolean internalStopFormatFlag;

        private CreditCardFormatTextWatcher(int paddingPx, int maxLength) {
            this.paddingPx = paddingPx;
            this.maxLength = maxLength;
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void afterTextChanged(Editable s) {
            if (this.internalStopFormatFlag) {
                return;
            }
            this.internalStopFormatFlag = true;
            CreditCardFormatTextWatcher.formatCardNumber(s, this.paddingPx, this.maxLength);
            this.internalStopFormatFlag = false;
        }

        private static void formatCardNumber(@NonNull Editable ccNumber, int paddingPx, int maxLength) {
            PaddingRightSpan[] spans;
            int textLength = ccNumber.length();
            for (PaddingRightSpan span : spans = (PaddingRightSpan[])ccNumber.getSpans(0, ccNumber.length(), PaddingRightSpan.class)) {
                ccNumber.removeSpan((Object)span);
            }
            if (maxLength > 0 && textLength > maxLength - 1) {
                ccNumber.replace(maxLength, textLength, (CharSequence)"");
            }
            for (int i = 1; i <= (textLength - 1) / 4; ++i) {
                int end = i * 4;
                int start = end - 1;
                PaddingRightSpan marginSpan = new PaddingRightSpan(paddingPx);
                ccNumber.setSpan((Object)marginSpan, start, end, 33);
            }
        }

        public static class PaddingRightSpan
        extends ReplacementSpan {
            private final int padding;

            private PaddingRightSpan(int padding) {
                this.padding = padding;
            }

            public int getSize(@NonNull Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
                float[] widths = new float[end - start];
                paint.getTextWidths(text, start, end, widths);
                int sum = this.padding;
                for (float width : widths) {
                    sum = (int)((float)sum + width);
                }
                return sum;
            }

            public void draw(@NonNull Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
                canvas.drawText(text, start, end, x, (float)y, paint);
            }
        }
    }
}

