/*
 * Decompiled with CFR 0.152.
 */
package com.cloudipsp.android;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.util.AttributeSet;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.SslErrorHandler;
import android.webkit.ValueCallback;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.cloudipsp.android.CloudipspView;
import com.cloudipsp.android.Tls12SocketFactory;
import java.net.URLDecoder;
import org.json.JSONException;
import org.json.JSONObject;

public class CloudipspWebView
extends WebView
implements CloudipspView {
    private static final String URL_START_PATTERN = "http://secure-redirect.cloudipsp.com/submit/#";

    public CloudipspWebView(Context context) {
        super(context);
        this.init();
    }

    public CloudipspWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public CloudipspWebView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        WebSettings settings = this.getSettings();
        settings.setJavaScriptEnabled(true);
        settings.setJavaScriptCanOpenWindowsAutomatically(false);
        settings.setCacheMode(2);
        settings.setDomStorageEnabled(true);
        settings.setLoadsImagesAutomatically(true);
        settings.setAllowFileAccess(false);
        settings.setDatabaseEnabled(true);
        this.setVisibility(8);
    }

    public final boolean waitingForConfirm() {
        return this.getVisibility() == 0;
    }

    public final void skipConfirm() {
        this.stopLoading();
        this.setVisibility(8);
    }

    @Override
    public final void confirm(final CloudipspView.PayConfirmation confirmation) {
        if (confirmation == null) {
            throw new NullPointerException("confirmation should be not null");
        }
        this.setVisibility(0);
        this.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (this.checkUrl(url)) {
                    return true;
                }
                return super.shouldOverrideUrlLoading(view, url);
            }

            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                if (Build.VERSION.SDK_INT >= 21 && this.checkUrl(request.getUrl().toString())) {
                    return true;
                }
                return super.shouldOverrideUrlLoading(view, request);
            }

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                this.checkUrl(url);
            }

            private boolean checkUrl(String url) {
                boolean detectsStartPattern = url.startsWith(CloudipspWebView.URL_START_PATTERN);
                boolean detectsCallbackUrl = false;
                boolean detectsApiToken = false;
                if (!detectsStartPattern && !(detectsCallbackUrl = url.startsWith(confirmation.callbackUrl))) {
                    detectsApiToken = url.startsWith(confirmation.host + "/api/checkout?token=");
                }
                if (detectsStartPattern || detectsCallbackUrl || detectsApiToken) {
                    CloudipspWebView.this.blankPage();
                    JSONObject response = null;
                    if (detectsStartPattern) {
                        String jsonOfConfirmation = url.split(CloudipspWebView.URL_START_PATTERN)[1];
                        try {
                            response = new JSONObject(jsonOfConfirmation);
                        }
                        catch (JSONException jsonException) {
                            try {
                                response = new JSONObject(URLDecoder.decode(jsonOfConfirmation, "UTF-8"));
                            }
                            catch (Exception e) {
                                response = null;
                            }
                        }
                    }
                    confirmation.listener.onConfirmed(response);
                    CloudipspWebView.this.setVisibility(8);
                    return true;
                }
                return false;
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                this.handleError(errorCode, description);
            }

            @TargetApi(value=23)
            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                this.handleError(error.getErrorCode(), error.getDescription().toString());
            }

            private void handleError(int errorCode, String description) {
                switch (errorCode) {
                    case -7: 
                    case -6: 
                    case -2: {
                        confirmation.listener.onNetworkAccessError(description);
                        this.handleError();
                        break;
                    }
                    case -11: {
                        confirmation.listener.onNetworkSecurityError(description);
                        this.handleError();
                    }
                }
            }

            public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
                super.onReceivedSslError(view, handler, error);
                confirmation.listener.onNetworkSecurityError(error.toString());
                this.handleError();
            }

            private void handleError() {
                CloudipspWebView.this.blankPage();
                CloudipspWebView.this.skipConfirm();
            }
        });
        if (Tls12SocketFactory.needHere()) {
            this.loadProxy(confirmation);
        } else {
            final Runnable l = new Runnable(){

                @Override
                public void run() {
                    CloudipspWebView.this.loadDataWithBaseURL(confirmation.url, confirmation.htmlPageContent, confirmation.contentType, CloudipspWebView.encoding(confirmation.contentType), null);
                }
            };
            if (Build.VERSION.SDK_INT >= 21 && confirmation.cookie != null) {
                CookieManager.getInstance().setCookie(confirmation.url, confirmation.cookie, (ValueCallback)new ValueCallback<Boolean>(){

                    public void onReceiveValue(Boolean value) {
                        l.run();
                    }
                });
            } else {
                l.run();
            }
        }
    }

    private void blankPage() {
        this.loadDataWithBaseURL(null, "<html></html>", "text/html", "UTF-8", null);
        this.invalidate();
    }

    private static String encoding(String contentType) {
        String[] parts = contentType.split("charset\\=");
        if (parts.length < 2) {
            return "UTF-8";
        }
        return parts[1];
    }

    private void loadProxy(CloudipspView.PayConfirmation confirmation) {
        try {
            Uri uri = Uri.parse((String)confirmation.url);
            String oldHost = uri.getAuthority();
            String newHost = "3dse.fondy.eu";
            Uri.Builder uriBuilder = uri.buildUpon().authority("3dse.fondy.eu").path(uri.getPath()).appendQueryParameter("jd91mx8", oldHost);
            String url = uriBuilder.toString();
            String htmlPageContent = confirmation.htmlPageContent;
            String quoted = oldHost.replace(".", "\\.");
            htmlPageContent = htmlPageContent.replaceAll(quoted, "3dse.fondy.eu");
            this.clearProxy();
            this.loadDataWithBaseURL(url, htmlPageContent, confirmation.contentType, CloudipspWebView.encoding(confirmation.contentType), null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void clearProxy() {
        if (Build.VERSION.SDK_INT >= 22) {
            CookieManager.getInstance().removeAllCookies(null);
            CookieManager.getInstance().flush();
        } else {
            CookieSyncManager cookieSyncMngr = CookieSyncManager.createInstance((Context)this.getContext());
            cookieSyncMngr.startSync();
            CookieManager cookieManager = CookieManager.getInstance();
            cookieManager.removeAllCookie();
            cookieManager.removeSessionCookie();
            cookieSyncMngr.stopSync();
            cookieSyncMngr.sync();
        }
        this.clearCache(true);
    }
}

