/*
 * Decompiled with CFR 0.152.
 */
package com.cloudipsp.android;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Patterns;
import com.cloudipsp.android.Currency;
import java.io.Serializable;
import java.util.HashMap;

public class Order
implements Parcelable {
    public static final Parcelable.Creator<Order> CREATOR = new Parcelable.Creator<Order>(){

        public Order createFromParcel(Parcel input) {
            return new Order(input);
        }

        public Order[] newArray(int size) {
            return new Order[size];
        }
    };
    public final int amount;
    public final String currency;
    public final String id;
    public final String description;
    public final String email;
    String productId;
    String paymentSystems;
    String defaultPaymentSystem;
    int lifetime = -1;
    String merchantData;
    boolean preauth = false;
    boolean requiredRecToken = false;
    boolean verification = false;
    Verification verificationType = Verification.amount;
    String recToken;
    String version;
    Lang lang;
    String serverCallbackUrl;
    String reservationData;
    String paymentSystem;
    boolean delayed = false;
    final HashMap<String, String> arguments = new HashMap();

    private Order(Parcel input) {
        this.amount = input.readInt();
        this.currency = input.readString();
        this.id = input.readString();
        this.description = input.readString();
        this.email = input.readString();
        this.productId = input.readString();
        this.paymentSystems = input.readString();
        this.defaultPaymentSystem = input.readString();
        this.lifetime = input.readInt();
        this.merchantData = input.readString();
        this.preauth = input.readInt() == 1;
        this.requiredRecToken = input.readInt() == 1;
        this.verification = input.readInt() == 1;
        this.verificationType = (Verification)((Object)input.readSerializable());
        this.recToken = input.readString();
        this.version = input.readString();
        this.lang = (Lang)((Object)input.readSerializable());
        this.serverCallbackUrl = input.readString();
        this.reservationData = input.readString();
        this.paymentSystem = input.readString();
        this.delayed = input.readInt() == 1;
        Bundle bundle = input.readBundle();
        for (String key : bundle.keySet()) {
            this.arguments.put(key, bundle.getString(key));
        }
    }

    public Order(int amount, Currency currency, String id2, String description) {
        this(amount, currency, id2, description, null);
    }

    public Order(int amount, Currency currency, String id2, String description, String email) {
        this(amount, currency == null ? null : currency.name(), id2, description, email);
    }

    public Order(int amount, String currency, String id2, String description, String email) {
        if (amount <= 0) {
            throw new IllegalArgumentException("Amount should be more than 0");
        }
        if (currency == null) {
            throw new NullPointerException("currency should be not null");
        }
        if (id2 == null) {
            throw new NullPointerException("id should be not null");
        }
        if (id2.length() == 0 || id2.length() > 1024) {
            throw new IllegalArgumentException("id's length should be > 0 && <= 1024");
        }
        if (description == null) {
            throw new NullPointerException("description should be not null");
        }
        if (description.length() == 0 || description.length() > 1024) {
            throw new IllegalArgumentException("description's length should be > 0 && <= 1024");
        }
        if (!TextUtils.isEmpty((CharSequence)email) && !Patterns.EMAIL_ADDRESS.matcher(email).matches()) {
            throw new IllegalArgumentException("email is not valid");
        }
        this.amount = amount;
        this.currency = currency;
        this.id = id2;
        this.description = description;
        this.email = email;
    }

    public void setProductId(String value) {
        if (value == null) {
            throw new NullPointerException("ProductId should be not null");
        }
        if (value.length() > 1024) {
            throw new IllegalArgumentException("ProductId should be not more than 1024 symbols");
        }
        this.productId = value;
    }

    public void setPaymentSystems(String value) {
        if (value == null) {
            throw new NullPointerException("PaymentSystems should be not null");
        }
        this.paymentSystems = value;
    }

    public void setDelayed(boolean value) {
        this.delayed = value;
    }

    public void setDefaultPaymentSystem(String value) {
        if (value == null) {
            throw new NullPointerException("Default payment system should be not null");
        }
        this.defaultPaymentSystem = value;
    }

    public void setLifetime(int value) {
        this.lifetime = value;
    }

    public void setMerchantData(String value) {
        if (value == null) {
            throw new NullPointerException("MerchantData should be not null");
        }
        if (value.length() > 2048) {
            throw new IllegalArgumentException("MerchantData should be not more than 2048 symbols");
        }
        this.merchantData = value;
    }

    public void setPreauth(boolean enable) {
        this.preauth = enable;
    }

    public void setRequiredRecToken(boolean enable) {
        this.requiredRecToken = enable;
    }

    public void setVerification(boolean enable) {
        this.verification = enable;
    }

    public void setVerificationType(Verification type) {
        if (type == null) {
            throw new NullPointerException("VerificationType should be not null");
        }
        this.verificationType = type;
    }

    public void setRecToken(String value) {
        if (value == null) {
            throw new NullPointerException("RecToken should be not null");
        }
        this.recToken = value;
    }

    public void setVersion(String value) {
        if (value == null) {
            throw new NullPointerException("version should be not null");
        }
        if (value.length() > 10) {
            throw new IllegalArgumentException("version should be not more than 10 symbols");
        }
        this.version = value;
    }

    public void setLang(Lang value) {
        if (value == null) {
            throw new NullPointerException("Lang should be not null");
        }
        this.lang = value;
    }

    public void setServerCallbackUrl(String value) {
        if (value == null) {
            throw new NullPointerException("server callback url should be not null");
        }
        if (value.length() > 2048) {
            throw new IllegalArgumentException("server callback url should be not more than 10 symbols");
        }
        this.serverCallbackUrl = value;
    }

    public void setReservationData(String value) {
        if (value == null) {
            throw new NullPointerException("reservation data should be not null");
        }
        this.reservationData = value;
    }

    public void addArgument(String name, String value) {
        this.arguments.put(name, value);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel output, int flags) {
        output.writeInt(this.amount);
        output.writeSerializable((Serializable)((Object)this.currency));
        output.writeString(this.id);
        output.writeString(this.description);
        output.writeString(this.email);
        output.writeString(this.productId);
        output.writeString(this.paymentSystems);
        output.writeString(this.defaultPaymentSystem);
        output.writeInt(this.lifetime);
        output.writeString(this.merchantData);
        output.writeInt(this.preauth ? 1 : 0);
        output.writeInt(this.requiredRecToken ? 1 : 0);
        output.writeInt(this.verification ? 1 : 0);
        output.writeSerializable((Serializable)((Object)this.verificationType));
        output.writeString(this.recToken);
        output.writeString(this.version);
        output.writeSerializable((Serializable)((Object)this.lang));
        output.writeString(this.serverCallbackUrl);
        output.writeString(this.reservationData);
        output.writeString(this.paymentSystem);
        output.writeInt(this.delayed ? 1 : 0);
        Bundle bundle = new Bundle();
        for (String key : this.arguments.keySet()) {
            bundle.putString(key, this.arguments.get(key));
        }
    }

    public static enum Lang {
        ru,
        uk,
        en,
        lv,
        fr;

    }

    public static enum Verification {
        amount,
        code;

    }
}

