/*
 * Decompiled with CFR 0.152.
 */
package com.cloudogu.cb.spring;

import com.cloudogu.cb.Command;
import com.cloudogu.cb.CommandHandler;
import com.cloudogu.cb.spring.CommandProvider;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.GenericTypeResolver;

public class Registry {
    private Map<Class<? extends Command>, CommandProvider> providerMap = new HashMap<Class<? extends Command>, CommandProvider>();

    @Autowired
    public Registry(ApplicationContext applicationContext) {
        String[] names;
        for (String name : names = applicationContext.getBeanNamesForType(CommandHandler.class)) {
            this.register(applicationContext, name);
        }
    }

    private void register(ApplicationContext applicationContext, String name) {
        Class handlerClass = applicationContext.getType(name);
        Class[] generics = GenericTypeResolver.resolveTypeArguments((Class)handlerClass, CommandHandler.class);
        Class commandType = generics[1];
        this.providerMap.put(commandType, new CommandProvider(applicationContext, handlerClass));
    }

    <R, C extends Command<R>> CommandHandler<R, C> get(Class<C> commandClass) {
        return this.providerMap.get(commandClass).get();
    }
}

